/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Wasm is 'TP' before Qt 6.4.0 (in Qt6 series)

    if (typeof(dev) == 'number' && dev < 640) {
        var dynamicDisplayName = component.value("DisplayName");
        var dynamicDescription = component.value("Description") + "&lt;br&gt;&lt;br&gt;The release of " + dynamicDisplayName + " with Qt 6.8 is a Technology Preview.";
        dynamicDisplayName = dynamicDisplayName + " (TP)";
        component.setValue("DisplayName", dynamicDisplayName);
        component.setValue("Description", dynamicDescription);
    }

    // Wasm requires host binaries so add a dependency to host binaries
    var hostDependencyStr = "";
    if (installer.value("os") == "x11") {
        // Linux on ARM supported from Qt 6.7 onward
        if ("dev" == "dev" || 68 >= 67) {
            if (systemInfo.currentCpuArchitecture == "arm64") {
                hostDependencyStr = "qt.qt6.dev.linux_gcc_arm64"
            }
            else {
                hostDependencyStr = "qt.qt6.dev.linux_gcc_64"
            }
        }
        else {
            hostDependencyStr = "qt.qt6.dev.gcc_64"
        }
    }
    else if (installer.value("os") == "mac") {
        hostDependencyStr = "qt.qt6.dev.clang_64"
    }
    else if (installer.value("os") == "win") {
        hostDependencyStr = "qt.qt6.dev.win64_mingw"
    }
    component.addDependency(hostDependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    qtExecutePatching_dev("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64", "singlethread", "/6.8.0/wasm_singlethread", component.value("Name"));

    var qtPath = getNativePath_dev("/6.8.0/wasm_singlethread");
    var qmakeBinary = qtPath + qmakeScript_dev();

    addInitQtPatchOperation(component, platformIdentification_dev(), qtPath, qmakeBinary, "qt5");

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} WebAssembly (single-threaded)",
                            "--type", "Qt4ProjectManager.QtVersion.WebAssembly",
                            "--qmake", qmakeBinary,
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    var kitName = component.name + "_kit";
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addKit",
                            "--id", kitName,
                            "--name", "WebAssembly Qt %{Qt:Version} (single-threaded)",
                            "--Ctoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--Cxxtoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--qt", component.name,
                            "--devicetype", "WebAssemblyDeviceType",
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // enable WebAssembly Qt Creator plugin
    var settingsFile = installer.value("QtCreatorInstallerSettingsFile");
    component.addOperation("Settings", "path="+settingsFile, "method=add_array_value", "key=Plugins/ForceEnabled", "value=WebAssembly");

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.8.0/wasm_singlethread", "Qt-6.8.0");
}

