/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class CheckGlobalNames
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private final CheckLevel level;
    private GlobalNamespace namespace = null;
    private final Set<String> objectPrototypeProps = new HashSet<String>();
    private final Set<String> functionPrototypeProps = new HashSet<String>();
    static final DiagnosticType UNDEFINED_NAME_WARNING = DiagnosticType.warning("JSC_UNDEFINED_NAME", "{0} is never defined");
    static final DiagnosticType NAME_DEFINED_LATE_WARNING = DiagnosticType.warning("JSC_NAME_DEFINED_LATE", "{0} defined before its owner. {1} is defined at {2}:{3}");
    static final DiagnosticType STRICT_MODULE_DEP_QNAME = DiagnosticType.disabled("JSC_STRICT_MODULE_DEP_QNAME", "cannot reference {2} because of a missing module dependency\ndefined in module {1}, referenced from module {0}");

    CheckGlobalNames(AbstractCompiler compiler, CheckLevel level) {
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        this.level = level;
    }

    CheckGlobalNames injectNamespace(GlobalNamespace namespace) {
        Preconditions.checkArgument(namespace.hasExternsRoot());
        this.namespace = namespace;
        return this;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, externs, root);
        }
        Preconditions.checkState(this.namespace.hasExternsRoot());
        this.findPrototypeProps("Object", this.objectPrototypeProps);
        this.findPrototypeProps("Function", this.functionPrototypeProps);
        this.objectPrototypeProps.addAll(this.convention.getIndirectlyDeclaredProperties());
        for (GlobalNamespace.Name name : this.namespace.getNameForest()) {
            if (name.getSourceKind() != GlobalNamespace.SourceKind.CODE) continue;
            this.checkDescendantNames(name, name.getGlobalSets() + name.getLocalSets() > 0);
        }
    }

    private void findPrototypeProps(String type, Set<String> props) {
        GlobalNamespace.Name slot = this.namespace.getSlot(type);
        if (slot != null) {
            for (GlobalNamespace.Ref ref : slot.getRefs()) {
                Node fullName;
                if (ref.type != GlobalNamespace.Ref.Type.PROTOTYPE_GET || !(fullName = ref.getNode().getGrandparent()).isGetProp()) continue;
                props.add(fullName.getLastChild().getString());
            }
        }
    }

    private void checkDescendantNames(GlobalNamespace.Name name, boolean nameIsDefined) {
        if (name.props != null) {
            for (GlobalNamespace.Name prop : name.props) {
                boolean propIsDefined = false;
                if (nameIsDefined) {
                    propIsDefined = !this.propertyMustBeInitializedByFullName(prop) || prop.getGlobalSets() + prop.getLocalSets() > 0;
                }
                this.validateName(prop, propIsDefined);
                this.checkDescendantNames(prop, propIsDefined);
            }
        }
    }

    private void validateName(GlobalNamespace.Name name, boolean isDefined) {
        GlobalNamespace.Name parent = name.getParent();
        boolean isTypedef = CheckGlobalNames.isTypedef(name);
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            boolean isPrototypeGet;
            GlobalNamespace.Name owner;
            boolean singleGlobalParentDecl;
            boolean isGlobalExpr = ref.getNode().getParent().isExprResult();
            if (!isDefined && !isTypedef) {
                if (isGlobalExpr) continue;
                this.reportRefToUndefinedName(name, ref);
                continue;
            }
            if (this.checkForBadModuleReference(name, ref)) {
                this.reportBadModuleReference(name, ref);
                continue;
            }
            if (!((Scope)ref.scope.getClosestHoistScope()).isGlobal() || !(singleGlobalParentDecl = (owner = (isPrototypeGet = ref.type == GlobalNamespace.Ref.Type.PROTOTYPE_GET) ? name : parent) != null && owner.getDeclaration() != null && owner.getLocalSets() == 0) || owner.getDeclaration().preOrderIndex <= ref.preOrderIndex) continue;
            String refName = isPrototypeGet ? name.getFullName() + ".prototype" : name.getFullName();
            this.compiler.report(JSError.make(ref.getNode(), NAME_DEFINED_LATE_WARNING, refName, owner.getFullName(), owner.getDeclaration().getSourceFile().getName(), String.valueOf(owner.getDeclaration().getNode().getLineno())));
        }
    }

    private static boolean isTypedef(GlobalNamespace.Name name) {
        if (name.getDeclaration() != null) {
            return false;
        }
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            JSDocInfo info;
            Node parent = ref.getNode().getParent();
            if (!parent.isExprResult() || (info = ref.getNode().getJSDocInfo()) == null || !info.hasTypedefType()) continue;
            return true;
        }
        return false;
    }

    private boolean checkForBadModuleReference(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        if (!(name.getParent().isObjectLiteral() || name.getParent().isClass() || name.getParent().isFunction())) {
            return false;
        }
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        if (name.getGlobalSets() == 0 || ref.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL) {
            return false;
        }
        if (name.getGlobalSets() == 1) {
            GlobalNamespace.Ref declaration = Preconditions.checkNotNull(name.getDeclaration());
            return !CheckGlobalNames.isSetFromPrecedingModule(ref, declaration, moduleGraph);
        }
        for (GlobalNamespace.Ref set : name.getRefs()) {
            if (!CheckGlobalNames.isSetFromPrecedingModule(ref, set, moduleGraph)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSetFromPrecedingModule(GlobalNamespace.Ref originalRef, GlobalNamespace.Ref set, JSModuleGraph moduleGraph) {
        return set.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL && (originalRef.getModule() == set.getModule() || moduleGraph.dependsOn(originalRef.getModule(), set.getModule()));
    }

    private void reportBadModuleReference(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.getNode(), STRICT_MODULE_DEP_QNAME, ref.getModule().getName(), name.getDeclaration().getModule().getName(), name.getFullName()));
    }

    private void reportRefToUndefinedName(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        while (name.getParent() != null && name.getParent().getGlobalSets() + name.getParent().getLocalSets() == 0) {
            name = name.getParent();
        }
        this.compiler.report(JSError.make(ref.getNode(), this.level, UNDEFINED_NAME_WARNING, name.getFullName()));
    }

    private boolean propertyMustBeInitializedByFullName(GlobalNamespace.Name name) {
        if (name.getParent() == null) {
            return false;
        }
        if (this.isNameUnsafelyAliased(name.getParent())) {
            return false;
        }
        if (this.objectPrototypeProps.contains(name.getBaseName())) {
            return false;
        }
        if (name.getParent().isObjectLiteral()) {
            return true;
        }
        if (name.getParent().isClass()) {
            return !this.hasSuperclass(name.getParent());
        }
        return name.getParent().isFunction() && name.getParent().isDeclaredType() && !this.functionPrototypeProps.contains(name.getBaseName());
    }

    private boolean hasSuperclass(GlobalNamespace.Name es6Class) {
        Node decl = es6Class.getDeclaration().getNode();
        Node classNode = NodeUtil.getRValueOfLValue(decl);
        Preconditions.checkState(classNode.isClass(), classNode);
        Node superclass = classNode.getSecondChild();
        return !superclass.isEmpty();
    }

    private boolean isNameUnsafelyAliased(GlobalNamespace.Name name) {
        if (name.getAliasingGets() > 0) {
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                Node aliaser;
                boolean isKnownAlias;
                if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET || (isKnownAlias = (aliaser = ref.getNode().getParent()).isCall() && (this.convention.getClassesDefinedByCall(aliaser) != null || this.convention.getSingletonGetterClassName(aliaser) != null))) continue;
                return true;
            }
        }
        return name.getParent() != null && this.isNameUnsafelyAliased(name.getParent());
    }
}

