/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RenameReferences;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleRenaming;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class Es6RewriteModules
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType LHS_OF_GOOG_REQUIRE_MUST_BE_CONST = DiagnosticType.error("JSC_LHS_OF_GOOG_REQUIRE_MUST_BE_CONST", "The left side of a goog.require() or goog.requireType() must use ''const'' (not ''let'' or ''var'')");
    static final DiagnosticType REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST = DiagnosticType.error("JSC_REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST", "goog.requireType alias for ES6 module should be const.");
    static final DiagnosticType FORWARD_DECLARE_FOR_ES6_SHOULD_BE_CONST = DiagnosticType.error("JSC_FORWARD_DECLARE_FOR_ES6_SHOULD_BE_CONST", "goog.forwardDeclare alias for ES6 module should be const.");
    static final DiagnosticType SHOULD_IMPORT_ES6_MODULE = DiagnosticType.warning("JSC_SHOULD_IMPORT_ES6_MODULE", "ES6 modules should import other ES6 modules rather than goog.require them.");
    private final AbstractCompiler compiler;
    @Nullable
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private int scriptNodeCount;
    private Map<String, String> namesToInlineByAlias;
    private Set<String> typedefs;
    private final ModuleMetadataMap moduleMetadataMap;
    private final ModuleMap moduleMap;

    public Es6RewriteModules(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap, ModuleMap moduleMap, @Nullable PreprocessorSymbolTable preprocessorSymbolTable) {
        Preconditions.checkNotNull(moduleMetadataMap);
        this.compiler = compiler;
        this.moduleMetadataMap = moduleMetadataMap;
        this.moduleMap = moduleMap;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
    }

    public static boolean isEs6ModuleRoot(Node scriptNode) {
        Preconditions.checkArgument(scriptNode.isScript(), scriptNode);
        if (scriptNode.getBooleanProp(Node.GOOG_MODULE)) {
            return false;
        }
        return scriptNode.hasChildren() && scriptNode.getFirstChild().isModuleBody();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument(externs.isRoot(), externs);
        Preconditions.checkArgument(root.isRoot(), root);
        for (Node file : Iterables.concat(externs.children(), root.children())) {
            Preconditions.checkState(file.isScript(), file);
            this.hotSwapScript(file, null);
        }
        this.compiler.setFeatureSet(this.compiler.getFeatureSet().without(FeatureSet.Feature.MODULES, new FeatureSet.Feature[0]));
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptNode, Node originalRoot) {
        new RewriteRequiresForEs6Modules().rewrite(scriptNode);
        if (Es6RewriteModules.isEs6ModuleRoot(scriptNode)) {
            this.processFile(scriptNode);
        }
    }

    private void processFile(Node root) {
        Preconditions.checkArgument(Es6RewriteModules.isEs6ModuleRoot(root), root);
        this.clearState();
        root.putBooleanProp(Node.TRANSPILED, true);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    public void clearState() {
        this.scriptNodeCount = 0;
        this.typedefs = new HashSet<String>();
        this.namesToInlineByAlias = new HashMap<String, String>();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isImport()) {
            this.maybeWarnExternModule(t, n, parent);
            this.visitImport(t, n, parent);
        } else if (n.isExport()) {
            this.maybeWarnExternModule(t, n, parent);
            this.visitExport(t, n, parent);
        } else if (n.isScript()) {
            ++this.scriptNodeCount;
            this.visitScript(t, n);
        } else if (n.isCall() && n.getFirstChild().matchesQualifiedName("goog.declareModuleId")) {
            n.getParent().detach();
        }
    }

    private void maybeWarnExternModule(NodeTraversal t, Node n, Node parent) {
        Preconditions.checkState(parent.isModuleBody());
        if (parent.isFromExterns() && !NodeUtil.isFromTypeSummary(parent.getParent())) {
            t.report(n, Es6ToEs3Util.CANNOT_CONVERT_YET, "ES6 modules in externs");
        }
    }

    private void visitImport(NodeTraversal t, Node importDecl, Node parent) {
        Preconditions.checkArgument(parent.isModuleBody(), parent);
        String importName = importDecl.getLastChild().getString();
        boolean isNamespaceImport = importName.startsWith("goog:");
        if (isNamespaceImport) {
            String namespace = importName.substring("goog:".length());
            ModuleMetadataMap.ModuleMetadata m = this.moduleMetadataMap.getModulesByGoogNamespace().get(namespace);
            if (m == null) {
                t.report(importDecl, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE, namespace);
            } else {
                Preconditions.checkState(m.isEs6Module() || m.isGoogModule() || m.isGoogProvide());
            }
        } else {
            ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(importName, importDecl.getSourceFileName(), importDecl.getLineno(), importDecl.getCharno());
            if (modulePath == null) {
                modulePath = t.getInput().getPath().resolveModuleAsPath(importName);
            }
            this.maybeAddImportedFileReferenceToSymbolTable(importDecl.getLastChild(), modulePath.toString());
        }
        for (Node child : importDecl.children()) {
            if (child.isImportSpecs()) {
                for (Node grandChild : child.children()) {
                    this.maybeAddAliasToSymbolTable(grandChild.getFirstChild(), t.getSourceName());
                    Preconditions.checkState(grandChild.hasTwoChildren());
                }
                continue;
            }
            if (!child.isImportStar()) continue;
            this.maybeAddAliasToSymbolTable(child, t.getSourceName());
        }
        parent.removeChild(importDecl);
        t.reportCodeChange();
    }

    private void visitExport(NodeTraversal t, Node export, Node parent) {
        Preconditions.checkArgument(parent.isModuleBody(), parent);
        if (export.getBooleanProp(Node.EXPORT_DEFAULT)) {
            Node child = export.getFirstChild();
            String name = null;
            if (child.isFunction() || child.isClass()) {
                name = NodeUtil.getName(child);
            }
            if (name != null) {
                Node decl = child.detach();
                parent.replaceChild(export, decl);
            } else {
                Node var = IR.var(IR.name("$jscompDefaultExport"), export.removeFirstChild());
                var.setJSDocInfo(child.getJSDocInfo());
                child.setJSDocInfo(null);
                var.useSourceInfoIfMissingFromForTree(export);
                parent.replaceChild(export, var);
            }
            t.reportCodeChange();
        } else if (export.getBooleanProp(Node.EXPORT_ALL_FROM) || export.hasTwoChildren() || export.getFirstChild().getToken() == Token.EXPORT_SPECS) {
            parent.removeChild(export);
            t.reportCodeChange();
        } else {
            this.visitExportDeclaration(t, export, parent);
        }
    }

    private void visitExportNameDeclaration(Node declaration) {
        List<Node> lhsNodes = NodeUtil.findLhsNodesInNode(declaration);
        for (Node lhs : lhsNodes) {
            Preconditions.checkState(lhs.isName());
            String name = lhs.getString();
            if (declaration.getJSDocInfo() == null || !declaration.getJSDocInfo().hasTypedefType()) continue;
            this.typedefs.add(name);
        }
    }

    private void visitExportDeclaration(NodeTraversal t, Node export, Node parent) {
        Node declaration = export.getFirstChild();
        if (NodeUtil.isNameDeclaration(declaration)) {
            this.visitExportNameDeclaration(declaration);
        }
        parent.replaceChild(export, declaration.detach());
        t.reportCodeChange();
    }

    private void inlineModuleToGlobalScope(Node moduleNode) {
        Preconditions.checkState(moduleNode.isModuleBody());
        Node scriptNode = moduleNode.getParent();
        moduleNode.detach();
        scriptNode.addChildrenToFront(moduleNode.removeChildren());
    }

    private void visitScript(NodeTraversal t, Node script) {
        this.inlineModuleToGlobalScope(script.getFirstChild());
        ClosureRewriteModule.checkAndSetStrictModeDirective(t, script);
        Preconditions.checkArgument(this.scriptNodeCount == 1, "Es6RewriteModules supports only one invocation per CompilerInput / script node");
        Module thisModule = this.moduleMap.getModule(t.getInput().getPath());
        String moduleName = ModuleRenaming.getGlobalName(thisModule.metadata(), null);
        Node moduleVar = this.createExportsObject(moduleName, t, script);
        NodeTraversal.traverse(this.compiler, script, new RenameGlobalVars(thisModule));
        this.rewriteRequires(script);
        moduleVar.getFirstChild().setString(moduleName);
        moduleVar.makeNonIndexableRecursive();
        t.reportCodeChange();
    }

    private Node createExportsObject(String moduleName, NodeTraversal t, Node script) {
        Node objLit = IR.objectlit(new Node[0]);
        Node moduleVar = IR.var(IR.name("exports"), objLit);
        moduleVar.getFirstChild().putBooleanProp(Node.MODULE_EXPORT, true);
        JSDocInfoBuilder infoBuilder = new JSDocInfoBuilder(false);
        infoBuilder.recordConstancy();
        moduleVar.setJSDocInfo(infoBuilder.build());
        script.addChildToBack(moduleVar.useSourceInfoIfMissingFromForTree(script));
        Module thisModule = this.moduleMap.getModule(t.getInput().getPath());
        for (Map.Entry entry : thisModule.namespace().entrySet()) {
            JSDocInfo info;
            String exportedName = (String)entry.getKey();
            Binding binding = (Binding)entry.getValue();
            Node nodeForSourceInfo = binding.sourceNode();
            boolean mutated = binding.isMutated();
            String boundVariableName = ModuleRenaming.getGlobalName(binding);
            Node getProp = IR.getprop(IR.name(moduleName), IR.string(exportedName));
            getProp.putBooleanProp(Node.MODULE_EXPORT, true);
            if (this.typedefs.contains(exportedName)) {
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                JSTypeExpression typeExpr = new JSTypeExpression(IR.string(exportedName), script.getSourceFileName());
                builder.recordTypedef(typeExpr);
                info = builder.build();
                getProp.setJSDocInfo(info);
                Node exprResult = IR.exprResult(getProp).useSourceInfoIfMissingFromForTree(nodeForSourceInfo);
                script.addChildToBack(exprResult);
                continue;
            }
            if (mutated) {
                this.addGetterExport(script, nodeForSourceInfo, objLit, exportedName, boundVariableName);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.GETTER);
                continue;
            }
            Node assign = IR.assign(getProp, NodeUtil.newQName(this.compiler, boundVariableName));
            JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
            builder.recordConstancy();
            info = builder.build();
            assign.setJSDocInfo(info);
            script.addChildToBack(IR.exprResult(assign).useSourceInfoIfMissingFromForTree(nodeForSourceInfo));
        }
        return moduleVar;
    }

    private void addGetterExport(Node script, Node forSourceInfo, Node objLit, String exportedName, String localName) {
        Node getter = Node.newString(Token.GETTER_DEF, exportedName);
        getter.putBooleanProp(Node.MODULE_EXPORT, true);
        objLit.addChildToBack(getter);
        Node name = NodeUtil.newQName(this.compiler, localName);
        Node function = IR.function(IR.name(""), IR.paramList(new Node[0]), IR.block(IR.returnNode(name)));
        getter.addChildToFront(function);
        JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
        builder.recordReturnType(new JSTypeExpression(new Node(Token.QMARK), script.getSourceFileName()));
        getter.setJSDocInfo(builder.build());
        getter.useSourceInfoIfMissingFromForTree(forSourceInfo);
        this.compiler.reportChangeToEnclosingScope(getter.getFirstChild().getLastChild());
        this.compiler.reportChangeToEnclosingScope(getter);
    }

    private void rewriteRequires(Node script) {
        NodeTraversal.traversePostOrder(this.compiler, script, (t, n, parent) -> {
            if (n.isCall()) {
                Node fn = n.getFirstChild();
                if (fn.matchesQualifiedName("goog.require") || fn.matchesQualifiedName("goog.requireType")) {
                    this.visitRequireOrGet(t, n, parent, true);
                } else if (fn.matchesQualifiedName("goog.module.get")) {
                    this.visitGoogModuleGet(t, n, parent);
                }
            }
        });
        NodeTraversal.traversePostOrder(this.compiler, script, (t, n, parent) -> {
            Var v;
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.inlineAliasedTypes(t, typeNode);
                }
            }
            if (n.isName() && this.namesToInlineByAlias.containsKey(n.getString()) && ((v = (Var)t.getScope().getVar(n.getString())) == null || v.getNameNode() != n)) {
                Node replacement = NodeUtil.newQName(this.compiler, this.namesToInlineByAlias.get(n.getString()));
                replacement.useSourceInfoFromForTree(n);
                n.replaceWith(replacement);
            }
        });
    }

    private void inlineAliasedTypes(NodeTraversal t, Node typeNode) {
        if (typeNode.isString()) {
            String replacement;
            String name = typeNode.getString();
            List<String> split = Splitter.on('.').limit(2).splitToList(name);
            if (t.getScope().getVar(split.get(0)) == null && (replacement = this.namesToInlineByAlias.get(split.get(0))) != null) {
                String rest = "";
                if (split.size() == 2) {
                    rest = "." + split.get(1);
                }
                typeNode.setOriginalName(name);
                typeNode.setString(replacement + rest);
                t.reportCodeChange();
            }
        }
        for (Node child : typeNode.children()) {
            this.inlineAliasedTypes(t, child);
        }
    }

    private void visitGoogModuleGet(NodeTraversal t, Node getCall, Node parent) {
        if (!getCall.hasTwoChildren() || !getCall.getLastChild().isString()) {
            t.report(getCall, ClosurePrimitiveErrors.INVALID_GET_NAMESPACE, new String[0]);
            return;
        }
        if (t.inGlobalHoistScope()) {
            t.report(getCall, ClosurePrimitiveErrors.MODULE_USES_GOOG_MODULE_GET, new String[0]);
            return;
        }
        this.visitRequireOrGet(t, getCall, parent, false);
    }

    private ModuleMetadataMap.ModuleMetadata getFallbackMetadataForNamespace(String namespace) {
        ModuleMetadataMap.ModuleMetadata.Builder builder = ModuleMetadataMap.ModuleMetadata.builder().moduleType(ModuleMetadataMap.ModuleType.GOOG_PROVIDE).usesClosure(true).isTestOnly(false);
        builder.googNamespacesBuilder().add((Object)namespace);
        return builder.build();
    }

    private void visitRequireOrGet(NodeTraversal t, Node requireCall, Node parent, boolean isRequire) {
        ModuleMetadataMap.ModuleMetadata m;
        if (!requireCall.hasTwoChildren() || !requireCall.getLastChild().isString()) {
            t.report(requireCall, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
            return;
        }
        if (isRequire && !t.getScope().isGlobal()) {
            t.report(requireCall, ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]);
            return;
        }
        String namespace = requireCall.getLastChild().getString();
        boolean isStoredInDeclaration = NodeUtil.isDeclaration(parent.getParent());
        if (isStoredInDeclaration && !parent.getParent().isConst()) {
            this.compiler.report(JSError.make(parent.getParent(), LHS_OF_GOOG_REQUIRE_MUST_BE_CONST, new String[0]));
        }
        if ((m = this.moduleMetadataMap.getModulesByGoogNamespace().get(namespace)) == null) {
            t.report(requireCall, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE, namespace);
            m = this.getFallbackMetadataForNamespace(namespace);
        }
        if (isStoredInDeclaration) {
            if (isRequire) {
                Node toDetach;
                if (parent.isDestructuringLhs()) {
                    Preconditions.checkState(parent.getFirstChild().isObjectPattern());
                    toDetach = parent.getParent();
                    for (Node child : parent.getFirstChild().children()) {
                        if (child.isStringKey()) {
                            Preconditions.checkState(child.getFirstChild().isName());
                            this.namesToInlineByAlias.put(child.getFirstChild().getString(), ModuleRenaming.getGlobalName(m, namespace) + "." + child.getString());
                            continue;
                        }
                        Preconditions.checkState(child.isName());
                        this.namesToInlineByAlias.put(child.getString(), ModuleRenaming.getGlobalName(m, namespace) + "." + child.getString());
                    }
                } else if (parent.isName()) {
                    this.namesToInlineByAlias.put(parent.getString(), ModuleRenaming.getGlobalName(m, namespace));
                    toDetach = parent.getParent();
                } else {
                    Preconditions.checkState(parent.isExprResult());
                    toDetach = parent;
                }
                toDetach.detach();
            } else {
                Node replacement = NodeUtil.newQName(this.compiler, ModuleRenaming.getGlobalName(m, namespace)).srcrefTree(requireCall);
                parent.replaceChild(requireCall, replacement);
            }
        } else {
            Preconditions.checkState(requireCall.getParent().isExprResult());
            requireCall.getParent().detach();
        }
    }

    private void maybeAddAliasToSymbolTable(Node n, String module) {
        if (this.preprocessorSymbolTable == null) {
            return;
        }
        n.putBooleanProp(Node.MODULE_ALIAS, true);
        String nodeName = n.isString() || n.isImportStar() ? n.getString() : this.preprocessorSymbolTable.getQualifiedName(n);
        String name = "alias_" + module + "_" + nodeName;
        this.preprocessorSymbolTable.addReference(n, name);
    }

    private void maybeAddImportedFileReferenceToSymbolTable(Node importStringNode, String importedFilePath) {
        Node scriptNode;
        if (this.preprocessorSymbolTable == null) {
            return;
        }
        if (this.preprocessorSymbolTable.getSlot(importedFilePath) == null && (scriptNode = this.compiler.getScriptNode(importedFilePath)) != null) {
            this.preprocessorSymbolTable.addReference(scriptNode, importedFilePath);
        }
        this.preprocessorSymbolTable.addReference(importStringNode, importedFilePath);
    }

    private class RenameGlobalVars
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Module thisModule;

        RenameGlobalVars(Module thisModule) {
            this.thisModule = thisModule;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            if (n.isName()) {
                String name = n.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    String newName = ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(this.thisModule.metadata(), name);
                    n.setString(newName);
                    n.setOriginalName(name);
                    t.reportCodeChange(n);
                } else if (var == null && this.thisModule.boundNames().containsKey(name)) {
                    Es6RewriteModules.this.maybeAddAliasToSymbolTable(n, t.getSourceName());
                    Binding binding = this.thisModule.boundNames().get(name);
                    Node replacement = ModuleRenaming.replace(Es6RewriteModules.this.compiler, Es6RewriteModules.this.moduleMap, binding, n);
                    if (replacement.isName() && parent.isCall() && parent.getFirstChild() == n && parent.getBooleanProp(Node.FREE_CALL)) {
                        parent.putBooleanProp(Node.FREE_CALL, true);
                    }
                    t.reportCodeChange();
                }
            }
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                Var var;
                Module thisModule = Es6RewriteModules.this.moduleMap.getModule(t.getInput().getPath());
                String name = typeNode.getString();
                List<String> splitted = Splitter.on('.').splitToList(name);
                String baseName = splitted.get(0);
                String rest = "";
                if (splitted.size() > 1) {
                    rest = name.substring(baseName.length());
                }
                if ((var = (Var)t.getScope().getVar(baseName)) != null && var.isGlobal()) {
                    this.maybeSetNewName(t, typeNode, name, ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(thisModule.metadata(), baseName) + rest);
                } else if (var == null && thisModule.boundNames().containsKey(baseName)) {
                    Binding binding = thisModule.boundNames().get(baseName);
                    String globalName = ModuleRenaming.getGlobalNameForJsDoc(Es6RewriteModules.this.moduleMap, binding, splitted.subList(1, splitted.size()));
                    this.maybeSetNewName(t, typeNode, name, globalName);
                    if (Es6RewriteModules.this.preprocessorSymbolTable != null) {
                        Node onlyBaseName = Node.newString(baseName).useSourceInfoFrom(typeNode);
                        onlyBaseName.setLength(baseName.length());
                        Es6RewriteModules.this.maybeAddAliasToSymbolTable(onlyBaseName, t.getSourceName());
                    }
                }
                typeNode.setOriginalName(name);
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }

        private void maybeSetNewName(NodeTraversal t, Node node, String name, String newName) {
            if (!name.equals(newName)) {
                node.setString(newName);
                node.setOriginalName(name);
                t.reportCodeChange();
            }
        }
    }

    private class RewriteRequiresForEs6Modules
    extends NodeTraversal.AbstractPostOrderCallback {
        private boolean transpiled = false;
        private Table<Node, String, String> renameTable;

        private RewriteRequiresForEs6Modules() {
        }

        void rewrite(Node scriptNode) {
            this.transpiled = false;
            this.renameTable = HashBasedTable.create();
            NodeTraversal.traverse(Es6RewriteModules.this.compiler, scriptNode, this);
            if (this.transpiled) {
                scriptNode.putBooleanProp(Node.TRANSPILED, true);
            }
            if (!this.renameTable.isEmpty()) {
                NodeTraversal.traverse(Es6RewriteModules.this.compiler, scriptNode, new Es6RenameReferences(this.renameTable, true));
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            ModuleMetadataMap.ModuleMetadata currentModuleMetadata;
            if (!n.isCall()) {
                return;
            }
            boolean isRequire = n.getFirstChild().matchesQualifiedName("goog.require");
            boolean isRequireType = n.getFirstChild().matchesQualifiedName("goog.requireType");
            boolean isGet = n.getFirstChild().matchesQualifiedName("goog.module.get");
            boolean isForwardDeclare = n.getFirstChild().matchesQualifiedName("goog.forwardDeclare");
            if (!(isRequire || isRequireType || isGet || isForwardDeclare)) {
                return;
            }
            if (!n.hasTwoChildren() || !n.getLastChild().isString()) {
                if (isRequire) {
                    t.report(n, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
                } else if (isRequireType) {
                    t.report(n, ClosurePrimitiveErrors.INVALID_REQUIRE_TYPE_NAMESPACE, new String[0]);
                } else if (isGet) {
                    t.report(n, ClosurePrimitiveErrors.INVALID_GET_NAMESPACE, new String[0]);
                } else {
                    t.report(n, ClosurePrimitiveErrors.INVALID_FORWARD_DECLARE_NAMESPACE, new String[0]);
                }
                return;
            }
            String name = n.getLastChild().getString();
            ModuleMetadataMap.ModuleMetadata moduleMetadata = Es6RewriteModules.this.moduleMetadataMap.getModulesByGoogNamespace().get(name);
            if (moduleMetadata == null || !moduleMetadata.isEs6Module()) {
                return;
            }
            if (isRequire && (currentModuleMetadata = Es6RewriteModules.this.moduleMetadataMap.getModulesByPath().get(t.getInput().getPath().toString())) != null && currentModuleMetadata.isEs6Module()) {
                t.report(n, SHOULD_IMPORT_ES6_MODULE, new String[0]);
            }
            if (isGet && t.inGlobalHoistScope()) {
                t.report(n, ClosurePrimitiveErrors.INVALID_GET_CALL_SCOPE, new String[0]);
                return;
            }
            Node statementNode = NodeUtil.getEnclosingStatement(n);
            boolean importHasAlias = NodeUtil.isNameDeclaration(statementNode);
            if (importHasAlias) {
                if (statementNode.getFirstChild().isDestructuringLhs()) {
                    if (isForwardDeclare) {
                        t.report(n, ClosurePrimitiveErrors.INVALID_DESTRUCTURING_FORWARD_DECLARE, new String[0]);
                        return;
                    }
                    if (isRequireType) {
                        if (!statementNode.isConst()) {
                            t.report(statementNode, REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST, new String[0]);
                            return;
                        }
                        for (Node child : statementNode.getFirstFirstChild().children()) {
                            Preconditions.checkState(child.isStringKey());
                            Preconditions.checkState(child.getFirstChild().isName());
                            this.renameTable.put(t.getScopeRoot(), child.getFirstChild().getString(), ModuleRenaming.getGlobalName(moduleMetadata, name) + "." + child.getString());
                        }
                    } else {
                        for (Node child : statementNode.getFirstFirstChild().children()) {
                            Preconditions.checkState(child.isStringKey());
                            Preconditions.checkState(child.getFirstChild().isName());
                            Node constNode = IR.constNode(IR.name(child.getFirstChild().getString()), IR.getprop(IR.name(ModuleRenaming.getGlobalName(moduleMetadata, name)), IR.string(child.getString())));
                            constNode.useSourceInfoFromForTree(child);
                            statementNode.getParent().addChildBefore(constNode, statementNode);
                        }
                    }
                    statementNode.detach();
                    t.reportCodeChange();
                } else if (isForwardDeclare || isRequireType) {
                    if (!statementNode.isConst()) {
                        DiagnosticType diagnostic = isForwardDeclare ? FORWARD_DECLARE_FOR_ES6_SHOULD_BE_CONST : REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST;
                        t.report(statementNode, diagnostic, new String[0]);
                        return;
                    }
                    this.renameTable.put(t.getScopeRoot(), statementNode.getFirstChild().getString(), ModuleRenaming.getGlobalName(moduleMetadata, name));
                    statementNode.detach();
                    t.reportCodeChange();
                } else {
                    n.replaceWith(IR.name(ModuleRenaming.getGlobalName(moduleMetadata, name)).useSourceInfoFromForTree(n));
                    t.reportCodeChange();
                }
            } else {
                if (isForwardDeclare || isRequireType) {
                    this.renameTable.put(t.getScopeRoot(), name, ModuleRenaming.getGlobalName(moduleMetadata, name));
                    statementNode.detach();
                } else if (statementNode.isExprResult() && statementNode.getFirstChild() == n) {
                    statementNode.detach();
                } else {
                    n.replaceWith(IR.name(ModuleRenaming.getGlobalName(moduleMetadata, name)).useSourceInfoFromForTree(n));
                }
                t.reportCodeChange();
            }
            this.transpiled = true;
        }
    }
}

