/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.StaticSymbolTable;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class GlobalNamespace
implements StaticScope,
StaticSymbolTable<Name, Ref> {
    private final AbstractCompiler compiler;
    private final Node root;
    private final Node externsRoot;
    private SourceKind sourceKind;
    private Scope externsScope;
    private boolean generated = false;
    private int currentPreOrderIndex = 0;
    private final List<Name> globalNames = new ArrayList<Name>();
    private final Map<String, Name> nameMap = new HashMap<String, Name>();

    GlobalNamespace(AbstractCompiler compiler, Node root) {
        this(compiler, null, root);
    }

    GlobalNamespace(AbstractCompiler compiler, Node externsRoot, Node root) {
        this.compiler = compiler;
        this.externsRoot = externsRoot;
        this.root = root;
    }

    boolean hasExternsRoot() {
        return this.externsRoot != null;
    }

    @Override
    public Node getRootNode() {
        return this.root.getParent();
    }

    @Override
    public StaticScope getParentScope() {
        return null;
    }

    @Override
    public Name getSlot(String name) {
        return this.getOwnSlot(name);
    }

    @Override
    public Name getOwnSlot(String name) {
        this.ensureGenerated();
        return this.nameMap.get(name);
    }

    @Override
    public Iterable<Ref> getReferences(Name slot) {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(slot.getRefs());
    }

    @Override
    public StaticScope getScope(Name slot) {
        return this;
    }

    @Override
    public Iterable<Name> getAllSymbols() {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(this.getNameIndex().values());
    }

    private void ensureGenerated() {
        if (!this.generated) {
            this.process();
        }
    }

    List<Name> getNameForest() {
        this.ensureGenerated();
        return this.globalNames;
    }

    Map<String, Name> getNameIndex() {
        this.ensureGenerated();
        return this.nameMap;
    }

    void scanNewNodes(Set<AstChange> newNodes) {
        BuildGlobalNamespace builder = new BuildGlobalNamespace();
        for (AstChange info : newNodes) {
            if (!info.node.isQualifiedName() && !NodeUtil.mayBeObjectLitKey(info.node)) continue;
            this.scanFromNode(builder, info.module, info.scope, info.node);
        }
    }

    private void scanFromNode(BuildGlobalNamespace builder, JSModule module, Scope scope, Node n) {
        Node parent = n.getParent();
        if ((n.isName() || n.isGetProp()) && parent.isGetProp()) {
            this.scanFromNode(builder, module, scope, n.getParent());
        } else if (n.getPrevious() != null && n.getPrevious().isObjectPattern()) {
            Node pattern = n.getPrevious();
            for (Node key : pattern.children()) {
                if (!key.isStringKey()) continue;
                this.scanFromNode(builder, module, scope, key);
            }
        }
        builder.collect(module, scope, n);
    }

    private void process() {
        if (this.hasExternsRoot()) {
            this.sourceKind = SourceKind.EXTERN;
            NodeTraversal.traverse(this.compiler, this.externsRoot, new BuildGlobalNamespace());
        }
        this.sourceKind = SourceKind.CODE;
        NodeTraversal.traverse(this.compiler, this.root, new BuildGlobalNamespace());
        this.generated = true;
        this.externsScope = null;
    }

    private boolean isGlobalNameReference(String name, Scope s) {
        String topVarName = GlobalNamespace.getTopVarName(name);
        return this.isGlobalVarReference(topVarName, s);
    }

    private static String getTopVarName(String name) {
        int firstDotIndex = name.indexOf(46);
        return firstDotIndex == -1 ? name : name.substring(0, firstDotIndex);
    }

    private boolean isGlobalVarReference(String name, Scope s) {
        Var v = (Var)s.getVar(name);
        if (v == null && this.externsScope != null) {
            v = (Var)this.externsScope.getVar(name);
        }
        return v != null && !v.isLocal();
    }

    private static boolean isQnameDeclarationWithoutAssignment(@Nullable Node node) {
        return node != null && node.isGetProp() && node.getParent().isExprResult();
    }

    static class Ref
    implements StaticRef {
        private Node node;
        final JSModule module;
        final Name name;
        final Type type;
        final Scope scope;
        final int preOrderIndex;
        private Ref twin = null;

        private Ref(JSModule module, Scope scope, Node node, Name name, Type type, int index) {
            this.node = node;
            this.name = name;
            this.module = module;
            this.type = type;
            this.scope = scope;
            this.preOrderIndex = index;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.node != null ? this.node.getStaticSourceFile() : null;
        }

        @Override
        public StaticSlot getSymbol() {
            return this.name;
        }

        JSModule getModule() {
            return this.module;
        }

        Ref getTwin() {
            return this.twin;
        }

        boolean isSet() {
            return this.type == Type.SET_FROM_GLOBAL || this.type == Type.SET_FROM_LOCAL;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("type", (Object)this.type).add("node", this.node).add("preOrderIndex", this.preOrderIndex).add("isTwin", this.twin != null).add("module", this.module).add("scope", this.scope).toString();
        }

        static enum Type {
            SET_FROM_GLOBAL,
            SET_FROM_LOCAL,
            PROTOTYPE_GET,
            ALIASING_GET,
            DIRECT_GET,
            CALL_GET,
            DELETE_PROP,
            SUBCLASSING_GET;

        }
    }

    static final class Name
    implements StaticSlot {
        private final String baseName;
        private final Name parent;
        @Nullable
        List<Name> props;
        private Ref declaration;
        private final LinkedHashSet<Ref> refs = new LinkedHashSet();
        private final Map<Node, ImmutableList<Ref>> refsForNodeMap = new HashMap<Node, ImmutableList<Ref>>();
        @Nullable
        List<Name> subclasses;
        private Type type;
        private boolean declaredType = false;
        private boolean isDeclared = false;
        private boolean isModuleProp = false;
        private boolean usedHasOwnProperty = false;
        private int globalSets = 0;
        private int localSets = 0;
        private int localSetsWithNoCollapse = 0;
        private int aliasingGets = 0;
        private int totalGets = 0;
        private int callGets = 0;
        private int deleteProps = 0;
        int subclassingGets = 0;
        private final SourceKind sourceKind;
        @Nullable
        private JSDocInfo firstDeclarationJSDocInfo = null;
        @Nullable
        private JSDocInfo firstQnameDeclarationWithoutAssignmentJsDocInfo = null;

        static Name createForTesting(String name) {
            return new Name(name, null, SourceKind.CODE);
        }

        private Name(String name, Name parent, SourceKind sourceKind) {
            this.baseName = name;
            this.parent = parent;
            this.type = Type.OTHER;
            this.sourceKind = sourceKind;
        }

        Name addProperty(String name, SourceKind sourceKind) {
            if (this.props == null) {
                this.props = new ArrayList<Name>();
            }
            Name node = new Name(name, this, sourceKind);
            this.props.add(node);
            return node;
        }

        String getBaseName() {
            return this.baseName;
        }

        boolean inExterns() {
            return this.sourceKind == SourceKind.EXTERN;
        }

        SourceKind getSourceKind() {
            return this.sourceKind;
        }

        @Override
        public String getName() {
            return this.getFullName();
        }

        String getFullName() {
            return this.parent == null ? this.baseName : this.parent.getFullName() + '.' + this.baseName;
        }

        @Override
        @Nullable
        public Ref getDeclaration() {
            return this.declaration;
        }

        boolean isFunction() {
            return this.type == Type.FUNCTION;
        }

        boolean isClass() {
            return this.type == Type.CLASS;
        }

        boolean isObjectLiteral() {
            return this.type == Type.OBJECTLIT;
        }

        int getAliasingGets() {
            return this.aliasingGets;
        }

        int getSubclassingGets() {
            return this.subclassingGets;
        }

        int getLocalSets() {
            return this.localSets;
        }

        int getGlobalSets() {
            return this.globalSets;
        }

        int getCallGets() {
            return this.callGets;
        }

        int getTotalGets() {
            return this.totalGets;
        }

        int getDeleteProps() {
            return this.deleteProps;
        }

        Name getParent() {
            return this.parent;
        }

        @Override
        public StaticScope getScope() {
            throw new UnsupportedOperationException();
        }

        private void addTwinRefs(JSModule module, Scope scope, Node node, Ref.Type setType, int setRefPreOrderIndex) {
            Preconditions.checkArgument(setType == Ref.Type.SET_FROM_GLOBAL || setType == Ref.Type.SET_FROM_LOCAL, (Object)setType);
            Ref setRef = this.createNewRef(module, scope, node, setType, setRefPreOrderIndex);
            Ref getRef = this.createNewRef(module, scope, node, Ref.Type.ALIASING_GET, setRefPreOrderIndex + 1);
            setRef.twin = getRef;
            getRef.twin = setRef;
            this.refsForNodeMap.put(node, ImmutableList.of(setRef, getRef));
            this.refs.add(setRef);
            this.updateStateForAddedRef(setRef);
            this.refs.add(getRef);
            this.updateStateForAddedRef(getRef);
        }

        private void addSingleRef(JSModule module, Scope scope, Node node, Ref.Type type, int preOrderIndex) {
            this.checkNoExistingRefsForNode(node);
            Ref ref = this.createNewRef(module, scope, node, type, preOrderIndex);
            this.refs.add(ref);
            this.refsForNodeMap.put(node, ImmutableList.of(ref));
            this.updateStateForAddedRef(ref);
        }

        private void checkNoExistingRefsForNode(Node node) {
            ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(node);
            Preconditions.checkState(refsForNode == null, "Refs already exist for node: %s", refsForNode);
        }

        private Ref createNewRef(JSModule module, Scope scope, Node node, Ref.Type type, int preOrderIndex) {
            return new Ref(module, Preconditions.checkNotNull(scope), Preconditions.checkNotNull(node), this, type, preOrderIndex);
        }

        Ref addSingleRefForTesting(Ref.Type type, int preOrderIndex) {
            Ref ref = new Ref(null, null, null, this, type, preOrderIndex);
            this.refs.add(ref);
            this.updateStateForAddedRef(ref);
            return ref;
        }

        void addAliasingGetClonedFromDeclaration(Node newRefNode) {
            Ref declRef = Preconditions.checkNotNull(this.declaration);
            this.addSingleRef(declRef.module, declRef.scope, newRefNode, Ref.Type.ALIASING_GET, declRef.preOrderIndex);
        }

        private void updateStateForAddedRef(Ref ref) {
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    if (this.declaration == null) {
                        this.declaration = ref;
                    }
                    if (this.firstDeclarationJSDocInfo == null) {
                        this.firstDeclarationJSDocInfo = Name.getDocInfoForDeclaration(ref);
                    }
                    ++this.globalSets;
                    break;
                }
                case SET_FROM_LOCAL: {
                    JSDocInfo info;
                    ++this.localSets;
                    JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                    if (info == null || !info.isNoCollapse()) break;
                    ++this.localSetsWithNoCollapse;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    Node node = ref.getNode();
                    if (this.firstQnameDeclarationWithoutAssignmentJsDocInfo == null && GlobalNamespace.isQnameDeclarationWithoutAssignment(node)) {
                        this.firstQnameDeclarationWithoutAssignmentJsDocInfo = node.getJSDocInfo();
                    }
                    ++this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case CALL_GET: {
                    ++this.callGets;
                    ++this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    ++this.deleteProps;
                    break;
                }
                case SUBCLASSING_GET: {
                    ++this.subclassingGets;
                    ++this.totalGets;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        void updateRefNode(Ref ref, @Nullable Node newNode) {
            Preconditions.checkArgument(ref.node != newNode, "redundant update to Ref node: %s", (Object)ref);
            Node oldNode = ref.getNode();
            Preconditions.checkState(oldNode != null, "Ref's node is already null: %s", (Object)ref);
            ref.node = newNode;
            Ref twinRef = ref.getTwin();
            if (twinRef != null) {
                ref.twin = null;
                twinRef.twin = null;
                this.refsForNodeMap.put(oldNode, ImmutableList.of(twinRef));
            } else {
                this.refsForNodeMap.remove(oldNode);
            }
            if (newNode != null) {
                ImmutableList<Ref> existingRefsForNewNode = this.refsForNodeMap.get(newNode);
                Preconditions.checkArgument(existingRefsForNewNode == null, "refs already exist: %s", existingRefsForNewNode);
                this.refsForNodeMap.put(newNode, ImmutableList.of(ref));
            }
        }

        void removeTwinRefs(Ref ref) {
            Preconditions.checkArgument(ref.name == this, "removeTwinRefs(%s): node does not belong to this name: %s", (Object)ref, (Object)this);
            Preconditions.checkState(this.refs.contains(ref), "removeRef(%s): unknown ref", (Object)ref);
            Ref twinRef = ref.getTwin();
            Preconditions.checkArgument(twinRef != null, ref);
            this.removeTwinRefsFromNodeMap(ref);
            this.removeRefAndUpdateState(ref);
            this.removeRefAndUpdateState(twinRef);
        }

        void removeRef(Ref ref) {
            Preconditions.checkState(ref.name == this, "removeRef(%s): node does not belong to this name: %s", (Object)ref, (Object)this);
            Preconditions.checkState(this.refs.contains(ref), "removeRef(%s): unknown ref", (Object)ref);
            Node refNode = ref.getNode();
            if (refNode != null) {
                this.removeSingleRefFromNodeMap(ref);
            }
            this.removeRefAndUpdateState(ref);
        }

        private void removeRefAndUpdateState(Ref ref) {
            this.refs.remove(ref);
            if (ref == this.declaration) {
                this.declaration = null;
                for (Ref maybeNewDecl : this.refs) {
                    if (maybeNewDecl.type != Ref.Type.SET_FROM_GLOBAL) continue;
                    this.declaration = maybeNewDecl;
                    break;
                }
            }
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    --this.globalSets;
                    break;
                }
                case SET_FROM_LOCAL: {
                    JSDocInfo info;
                    --this.localSets;
                    JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                    if (info == null || !info.isNoCollapse()) break;
                    --this.localSetsWithNoCollapse;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    --this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    --this.aliasingGets;
                    --this.totalGets;
                    break;
                }
                case CALL_GET: {
                    --this.callGets;
                    --this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    --this.deleteProps;
                    break;
                }
                case SUBCLASSING_GET: {
                    --this.subclassingGets;
                    --this.totalGets;
                }
            }
        }

        private void removeSingleRefFromNodeMap(Ref ref) {
            Node refNode = Preconditions.checkNotNull(ref.getNode(), ref);
            if (ref.getTwin() != null) {
                this.removeTwinRefsFromNodeMap(ref);
                Ref twinRef = ref.getTwin();
                ref.twin = null;
                twinRef.twin = null;
                this.refsForNodeMap.put(refNode, ImmutableList.of(twinRef));
            } else {
                ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(refNode);
                Preconditions.checkState(refsForNode.size() == 1 && refsForNode.get(0) == ref, "Unexpected Refs for Node: %s: when removing Ref: %s", refsForNode, (Object)ref);
                this.refsForNodeMap.remove(refNode);
            }
        }

        private void removeTwinRefsFromNodeMap(Ref ref) {
            Ref twinRef = Preconditions.checkNotNull(ref.getTwin(), ref);
            Node refNode = Preconditions.checkNotNull(ref.getNode(), ref);
            ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(refNode);
            Preconditions.checkState(refsForNode.size() == 2, "unexpected Refs for Node: %s, when removing: %s", refsForNode, (Object)ref);
            Preconditions.checkState(refsForNode.contains(ref), "Refs for Node: %s does not contain Ref to remove: %s", refsForNode, (Object)ref);
            Preconditions.checkState(refsForNode.contains(twinRef), "Refs for Node: %s does not contain expected twin: %s", refsForNode, (Object)twinRef);
            this.refsForNodeMap.remove(refNode);
        }

        Collection<Ref> getRefs() {
            return this.refs == null ? ImmutableList.of() : Collections.unmodifiableCollection(this.refs);
        }

        @VisibleForTesting
        ImmutableList<Ref> getRefsForNode(Node node) {
            ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(Preconditions.checkNotNull(node));
            return refsForNode == null ? ImmutableList.of() : refsForNode;
        }

        Ref getFirstRef() {
            Preconditions.checkState(!this.refs.isEmpty(), "no first Ref to get");
            return Iterables.get(this.refs, 0);
        }

        boolean canEliminate() {
            if (!this.canCollapseUnannotatedChildNames() || this.totalGets > 0) {
                return false;
            }
            if (this.props != null) {
                for (Name n : this.props) {
                    if (n.canCollapse()) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isSimpleStubDeclaration() {
            Ref ref;
            return this.getRefs().size() == 1 && (ref = Iterables.get(this.refs, 0)).node.getParent().isExprResult();
        }

        boolean isCollapsingExplicitlyDenied() {
            JSDocInfo docInfo = this.getJSDocInfo();
            return docInfo != null && docInfo.isNoCollapse();
        }

        Inlinability calculateInlinability() {
            if (this.inExterns() || this.globalSets != 1 || this.localSets != 0) {
                return Inlinability.DO_NOT_INLINE;
            }
            Inlinability collapsibility = this.canCollapseOrInline();
            if (!collapsibility.shouldInlineUsages()) {
                return Inlinability.DO_NOT_INLINE;
            }
            block6: for (Ref ref : this.getRefs()) {
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        continue block6;
                    }
                    case SET_FROM_LOCAL: {
                        throw new IllegalStateException();
                    }
                    case PROTOTYPE_GET: 
                    case DIRECT_GET: 
                    case ALIASING_GET: 
                    case CALL_GET: 
                    case SUBCLASSING_GET: {
                        continue block6;
                    }
                    case DELETE_PROP: {
                        return Inlinability.DO_NOT_INLINE;
                    }
                }
                throw new IllegalStateException();
            }
            return collapsibility;
        }

        boolean canCollapse() {
            return this.canCollapseOrInline().canCollapse();
        }

        private Inlinability canCollapseOrInline() {
            Node declaration;
            if (this.inExterns()) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isGetOrSetDefinition()) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isCollapsingExplicitlyDenied()) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.referencesSuperOrInnerClassName()) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.getDeclaration() != null && (declaration = this.getDeclaration().getNode()).getParent().isObjectLit()) {
                if (Streams.stream(declaration.siblings()).anyMatch(Node::isSpread)) {
                    return Inlinability.DO_NOT_INLINE;
                }
                Token gp = declaration.getGrandparent().getToken();
                if (gp == Token.OR || gp == Token.HOOK) {
                    return Inlinability.DO_NOT_INLINE;
                }
            }
            boolean isUnchangedThroughFullName = (this.globalSets > 0 || this.localSets > 0) && this.localSetsWithNoCollapse == 0 && this.deleteProps == 0;
            Inlinability parentInlinability = this.parent == null ? Inlinability.INLINE_COMPLETELY : this.parent.canCollapseOrInlineChildNames();
            switch (parentInlinability) {
                case INLINE_COMPLETELY: {
                    if (isUnchangedThroughFullName) {
                        return Inlinability.INLINE_COMPLETELY;
                    }
                    return this.declaredType ? Inlinability.INLINE_BUT_KEEP_DECLARATION : Inlinability.DO_NOT_INLINE;
                }
                case INLINE_BUT_KEEP_DECLARATION: {
                    if (this.declaredType) {
                        return Inlinability.INLINE_BUT_KEEP_DECLARATION;
                    }
                    return isUnchangedThroughFullName ? Inlinability.INLINE_BUT_KEEP_DECLARATION : Inlinability.DO_NOT_INLINE;
                }
                case DO_NOT_INLINE: {
                    return this.declaredType ? Inlinability.INLINE_BUT_KEEP_DECLARATION : Inlinability.DO_NOT_INLINE;
                }
            }
            throw new IllegalStateException("unknown enum value " + (Object)((Object)parentInlinability));
        }

        boolean referencesSuperOrInnerClassName() {
            Ref ref = this.getDeclaration();
            if (ref == null) {
                return false;
            }
            Node member = ref.getNode();
            if (member == null || !member.isStaticMember() || !member.getParent().isClassMembers()) {
                return false;
            }
            if (NodeUtil.referencesSuper(NodeUtil.getFunctionBody(member.getFirstChild()))) {
                return true;
            }
            Node classNode = member.getGrandparent();
            if (NodeUtil.isClassDeclaration(classNode)) {
                return false;
            }
            Node innerNameNode = classNode.getFirstChild();
            return !innerNameNode.isEmpty() && NodeUtil.isNameReferenced(member, innerNameNode.getString());
        }

        private boolean isSetInLoop() {
            Node n;
            Ref ref = this.getDeclaration();
            if (ref != null && (n = ref.getNode()) != null) {
                return NodeUtil.isWithinLoop(n);
            }
            return false;
        }

        boolean isGetOrSetDefinition() {
            return this.type == Type.GET_SET;
        }

        boolean canCollapseUnannotatedChildNames() {
            return this.canCollapseOrInlineChildNames().canCollapse();
        }

        private Inlinability canCollapseOrInlineChildNames() {
            if (this.type == Type.OTHER || this.isGetOrSetDefinition() || this.globalSets != 1 || this.localSets != 0 || this.deleteProps != 0) {
                return Inlinability.DO_NOT_INLINE;
            }
            Preconditions.checkNotNull(this.declaration);
            if (this.declaration.getTwin() != null) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isCollapsingExplicitlyDenied()) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isSetInLoop()) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.usedHasOwnProperty) {
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.parent != null && this.parent.shouldKeepKeys()) {
                return this.declaredType ? Inlinability.INLINE_BUT_KEEP_DECLARATION : Inlinability.DO_NOT_INLINE;
            }
            if (this.aliasingGets > 0) {
                return this.declaredType ? Inlinability.INLINE_BUT_KEEP_DECLARATION : Inlinability.DO_NOT_INLINE;
            }
            if (this.parent == null) {
                return Inlinability.INLINE_COMPLETELY;
            }
            Inlinability parentInlinability = this.parent.canCollapseOrInlineChildNames();
            if (parentInlinability == Inlinability.DO_NOT_INLINE) {
                return this.declaredType ? Inlinability.INLINE_BUT_KEEP_DECLARATION : Inlinability.DO_NOT_INLINE;
            }
            return parentInlinability;
        }

        boolean shouldKeepKeys() {
            return this.type == Type.OBJECTLIT && (this.aliasingGets > 0 || this.isCollapsingExplicitlyDenied());
        }

        boolean needsToBeStubbed() {
            return this.globalSets == 0 && this.localSets > 0 && this.localSetsWithNoCollapse == 0 && !this.isCollapsingExplicitlyDenied();
        }

        void setDeclaredType() {
            this.declaredType = true;
            Name ancestor = this.parent;
            while (ancestor != null) {
                ancestor.isDeclared = true;
                ancestor = ancestor.parent;
            }
        }

        boolean isDeclaredType() {
            return this.declaredType;
        }

        boolean isConstructor() {
            Node declNode = this.declaration.node;
            Node rvalueNode = NodeUtil.getRValueOfLValue(declNode);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(declNode);
            return rvalueNode != null && rvalueNode.isFunction() && jsdoc != null && jsdoc.isConstructor();
        }

        boolean isNamespaceObjectLit() {
            return this.isDeclared && this.type == Type.OBJECTLIT;
        }

        boolean isSimpleName() {
            return this.parent == null;
        }

        public String toString() {
            return this.getFullName() + " (" + (Object)((Object)this.type) + "): " + Joiner.on(", ").join("globalSets=" + this.globalSets, "localSets=" + this.localSets, "totalGets=" + this.totalGets, "aliasingGets=" + this.aliasingGets, "callGets=" + this.callGets, "subclassingGets=" + this.subclassingGets);
        }

        @Override
        @Nullable
        public JSDocInfo getJSDocInfo() {
            return this.firstDeclarationJSDocInfo != null ? this.firstDeclarationJSDocInfo : this.firstQnameDeclarationWithoutAssignmentJsDocInfo;
        }

        private static JSDocInfo getDocInfoForDeclaration(Ref ref) {
            if (ref.node != null) {
                Node refParent = ref.node.getParent();
                if (refParent == null) {
                    return null;
                }
                switch (refParent.getToken()) {
                    case ASSIGN: 
                    case FUNCTION: 
                    case CLASS: {
                        return refParent.getJSDocInfo();
                    }
                    case VAR: 
                    case LET: 
                    case CONST: {
                        return ref.node == refParent.getFirstChild() ? refParent.getJSDocInfo() : ref.node.getJSDocInfo();
                    }
                    case OBJECTLIT: 
                    case CLASS_MEMBERS: {
                        return ref.node.getJSDocInfo();
                    }
                }
            }
            return null;
        }

        boolean isModuleExport() {
            return this.isModuleProp;
        }

        static enum Inlinability {
            INLINE_COMPLETELY,
            INLINE_BUT_KEEP_DECLARATION,
            DO_NOT_INLINE;


            boolean shouldInlineUsages() {
                return this != DO_NOT_INLINE;
            }

            boolean shouldRemoveDeclaration() {
                return this == INLINE_COMPLETELY;
            }

            boolean canCollapse() {
                return this != DO_NOT_INLINE;
            }
        }

        private static enum Type {
            CLASS,
            OBJECTLIT,
            FUNCTION,
            SUBCLASSING_GET,
            GET_SET,
            OTHER;

        }
    }

    private class BuildGlobalNamespace
    extends NodeTraversal.AbstractPreOrderCallback {
        private BuildGlobalNamespace() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (GlobalNamespace.this.hasExternsRoot()) {
                if (n == GlobalNamespace.this.externsRoot) {
                    GlobalNamespace.this.externsScope = t.getScope();
                } else if (n.isScript()) {
                    GlobalNamespace.this.sourceKind = SourceKind.fromScriptNode(n);
                }
            }
            this.collect(t.getModule(), t.getScope(), n);
            return true;
        }

        private void collect(JSModule module, Scope scope, Node n) {
            String name;
            Node parent = n.getParent();
            boolean isSet = false;
            Name.Type type = Name.Type.OTHER;
            switch (n.getToken()) {
                case GETTER_DEF: 
                case SETTER_DEF: 
                case MEMBER_FUNCTION_DEF: {
                    if (parent.isClassMembers() && !n.isStaticMember()) {
                        return;
                    }
                    name = NodeUtil.getBestLValueName(n);
                    isSet = true;
                    type = n.isMemberFunctionDef() ? Name.Type.FUNCTION : Name.Type.GET_SET;
                    break;
                }
                case STRING_KEY: {
                    name = null;
                    if (parent.isObjectLit()) {
                        name = NodeUtil.getBestLValueName(n);
                        isSet = true;
                    } else if (parent.isObjectPattern()) {
                        name = this.getNameForObjectPatternKey(n);
                    }
                    type = this.getValueType(n.getFirstChild());
                    break;
                }
                case NAME: {
                    switch (parent.getToken()) {
                        case VAR: 
                        case LET: 
                        case CONST: {
                            isSet = true;
                            Node rvalue = n.getFirstChild();
                            type = rvalue == null ? Name.Type.OTHER : this.getValueType(rvalue);
                            break;
                        }
                        case ASSIGN: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = this.getValueType(n.getNext());
                            break;
                        }
                        case GETPROP: {
                            return;
                        }
                        case FUNCTION: {
                            Node grandparent = parent.getParent();
                            if (grandparent == null || NodeUtil.isFunctionExpression(parent)) {
                                return;
                            }
                            isSet = true;
                            type = Name.Type.FUNCTION;
                            break;
                        }
                        case CATCH: 
                        case INC: 
                        case DEC: {
                            isSet = true;
                            type = Name.Type.OTHER;
                            break;
                        }
                        case CLASS: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = Name.Type.CLASS;
                            break;
                        }
                        case STRING_KEY: 
                        case ARRAY_PATTERN: 
                        case DEFAULT_VALUE: 
                        case COMPUTED_PROP: 
                        case ITER_REST: 
                        case OBJECT_REST: {
                            if (!NodeUtil.isLhsByDestructuring(n)) break;
                            isSet = true;
                            type = Name.Type.OTHER;
                            break;
                        }
                        case ITER_SPREAD: 
                        case OBJECT_SPREAD: {
                            break;
                        }
                        default: {
                            if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                            isSet = true;
                            type = Name.Type.OTHER;
                        }
                    }
                    name = n.getString();
                    break;
                }
                case GETPROP: {
                    if (parent != null) {
                        switch (parent.getToken()) {
                            case ASSIGN: {
                                if (parent.getFirstChild() != n) break;
                                isSet = true;
                                type = this.getValueType(n.getNext());
                                break;
                            }
                            case GETPROP: {
                                return;
                            }
                            case INC: 
                            case DEC: 
                            case ITER_SPREAD: 
                            case OBJECT_SPREAD: {
                                break;
                            }
                            default: {
                                if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                                isSet = true;
                                type = Name.Type.OTHER;
                            }
                        }
                    }
                    if (!n.isQualifiedName()) {
                        return;
                    }
                    name = n.getQualifiedName();
                    break;
                }
                case CALL: {
                    if (this.isObjectHasOwnPropertyCall(n)) {
                        String qname = n.getFirstFirstChild().getQualifiedName();
                        Name globalName = this.getOrCreateName(qname);
                        globalName.usedHasOwnProperty = true;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            if (name == null) {
                return;
            }
            if (!GlobalNamespace.this.isGlobalNameReference(name, scope)) {
                return;
            }
            if (isSet) {
                Scope hoistScope = (Scope)scope.getClosestHoistScope();
                if (hoistScope.isGlobal()) {
                    this.handleSetFromGlobal(module, scope, n, parent, name, type);
                } else {
                    this.handleSetFromLocal(module, scope, n, parent, name);
                }
            } else {
                this.handleGet(module, scope, n, parent, name);
            }
        }

        String getNameForObjectPatternKey(Node stringKey) {
            Node parent = stringKey.getParent();
            Preconditions.checkState(parent.isObjectPattern());
            Node patternParent = parent.getParent();
            if (patternParent.isAssign() || patternParent.isDestructuringLhs()) {
                Node rhs = patternParent.getSecondChild();
                if (rhs == null || !rhs.isQualifiedName()) {
                    return null;
                }
                return rhs.getQualifiedName() + "." + stringKey.getString();
            }
            return null;
        }

        Name.Type getValueType(Node n) {
            if (n == null) {
                return Name.Type.OTHER;
            }
            switch (n.getToken()) {
                case CLASS: {
                    return Name.Type.CLASS;
                }
                case OBJECTLIT: {
                    return Name.Type.OBJECTLIT;
                }
                case FUNCTION: {
                    return Name.Type.FUNCTION;
                }
                case OR: {
                    return this.getValueType(n.getLastChild());
                }
                case HOOK: {
                    Node second = n.getSecondChild();
                    Name.Type t = this.getValueType(second);
                    if (t != Name.Type.OTHER) {
                        return t;
                    }
                    Node third = second.getNext();
                    return this.getValueType(third);
                }
            }
            return Name.Type.OTHER;
        }

        void handleSetFromGlobal(JSModule module, Scope scope, Node n, Node parent, String name, Name.Type type) {
            if (this.maybeHandlePrototypePrefix(module, scope, n, parent, name)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name);
            if (!nameObj.isGetOrSetDefinition()) {
                nameObj.type = type;
            }
            if (n.getBooleanProp(Node.MODULE_EXPORT)) {
                nameObj.isModuleProp = true;
            }
            if (this.isNestedAssign(parent)) {
                Ref.Type refType = Ref.Type.SET_FROM_GLOBAL;
                this.addOrConfirmTwinRefs(nameObj, n, refType, module, scope);
            } else {
                this.addOrConfirmRef(nameObj, n, Ref.Type.SET_FROM_GLOBAL, module, scope);
                if (this.isTypeDeclaration(n)) {
                    nameObj.setDeclaredType();
                }
            }
        }

        private void addOrConfirmTwinRefs(Name nameObj, Node node, Ref.Type setRefType, JSModule module, Scope scope) {
            ImmutableList<Ref> existingRefs = nameObj.getRefsForNode(node);
            if (existingRefs.isEmpty()) {
                nameObj.addTwinRefs(module, scope, node, setRefType, GlobalNamespace.this.currentPreOrderIndex);
                GlobalNamespace.this.currentPreOrderIndex = GlobalNamespace.this.currentPreOrderIndex + 2;
            } else {
                Preconditions.checkState(existingRefs.size() == 2, "unexpected existing refs: %s", existingRefs);
                Ref setRef = (Ref)existingRefs.get(0);
                Preconditions.checkState(setRef.type == setRefType, "unexpected existing set Ref type: %s", (Object)setRef.type);
            }
        }

        private boolean isTypeDeclaration(Node n) {
            Node valueNode = NodeUtil.getRValueOfLValue(n);
            if (valueNode == null) {
                return false;
            }
            if (valueNode.isClass()) {
                return true;
            }
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            return info != null && (info.isConstructor() && valueNode.isFunction() || info.isInterface() && valueNode.isFunction() || info.hasEnumParameterType() && valueNode.isObjectLit());
        }

        void handleSetFromLocal(JSModule module, Scope scope, Node n, Node parent, String name) {
            if (this.maybeHandlePrototypePrefix(module, scope, n, parent, name)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name);
            if (n.getBooleanProp(Node.MODULE_EXPORT)) {
                nameObj.isModuleProp = true;
            }
            if (this.isNestedAssign(parent)) {
                this.addOrConfirmTwinRefs(nameObj, n, Ref.Type.SET_FROM_LOCAL, module, scope);
            } else {
                this.addOrConfirmRef(nameObj, n, Ref.Type.SET_FROM_LOCAL, module, scope);
            }
        }

        void handleGet(JSModule module, Scope scope, Node n, Node parent, String name) {
            Ref.Type type;
            if (this.maybeHandlePrototypePrefix(module, scope, n, parent, name)) {
                return;
            }
            block0 : switch (parent.getToken()) {
                case EXPR_RESULT: 
                case IF: 
                case INSTANCEOF: 
                case TYPEOF: 
                case VOID: 
                case NOT: 
                case BITNOT: 
                case POS: 
                case NEG: {
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case CALL: {
                    if (n == parent.getFirstChild()) {
                        type = Ref.Type.CALL_GET;
                        break;
                    }
                    if (this.isClassDefiningCall(parent)) {
                        type = Ref.Type.DIRECT_GET;
                        break;
                    }
                    type = Ref.Type.ALIASING_GET;
                    break;
                }
                case NEW: {
                    type = n == parent.getFirstChild() ? Ref.Type.DIRECT_GET : Ref.Type.ALIASING_GET;
                    break;
                }
                case OR: 
                case AND: {
                    type = this.determineGetTypeForHookOrBooleanExpr(module, scope, parent, name);
                    break;
                }
                case HOOK: {
                    if (n != parent.getFirstChild()) {
                        type = this.determineGetTypeForHookOrBooleanExpr(module, scope, parent, name);
                        break;
                    }
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case DELPROP: {
                    type = Ref.Type.DELETE_PROP;
                    break;
                }
                case CLASS: {
                    type = Ref.Type.SUBCLASSING_GET;
                    break;
                }
                case ASSIGN: 
                case DESTRUCTURING_LHS: {
                    Node lhs = n.getPrevious();
                    if (lhs.isCast()) {
                        lhs = lhs.getOnlyChild();
                    }
                    switch (lhs.getToken()) {
                        case GETPROP: 
                        case ARRAY_PATTERN: 
                        case NAME: 
                        case GETELEM: {
                            type = Ref.Type.ALIASING_GET;
                            break block0;
                        }
                        case OBJECT_PATTERN: {
                            type = lhs.hasChildren() && lhs.getLastChild().isRest() ? Ref.Type.ALIASING_GET : Ref.Type.DIRECT_GET;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unexpected previous sibling of " + (Object)((Object)n.getToken()) + ": " + n.getPrevious());
                }
                default: {
                    type = Ref.Type.ALIASING_GET;
                }
            }
            this.handleGet(module, scope, n, parent, name, type);
        }

        void handleGet(JSModule module, Scope scope, Node n, Node parent, String name, Ref.Type type) {
            Name nameObj = this.getOrCreateName(name);
            this.addOrConfirmRef(nameObj, n, type, module, scope);
        }

        private void addOrConfirmRef(Name nameObj, Node node, Ref.Type refType, JSModule module, Scope scope) {
            ImmutableList<Ref> existingRefs = nameObj.getRefsForNode(node);
            if (existingRefs.isEmpty()) {
                nameObj.addSingleRef(module, scope, node, refType, GlobalNamespace.this.currentPreOrderIndex++);
            } else {
                Preconditions.checkState(existingRefs.size() == 1, "unexpected twin refs: %s", existingRefs);
                Ref.Type existingRefType = ((Ref)existingRefs.get((int)0)).type;
                Preconditions.checkState(existingRefType == refType, "existing ref type: %s expected: %s", (Object)existingRefType, (Object)refType);
            }
        }

        private boolean isClassDefiningCall(Node callNode) {
            CodingConvention convention = GlobalNamespace.this.compiler.getCodingConvention();
            CodingConvention.SubclassRelationship classes = convention.getClassesDefinedByCall(callNode);
            if (classes != null) {
                return true;
            }
            String className = convention.getSingletonGetterClassName(callNode);
            return className != null;
        }

        private boolean isObjectHasOwnPropertyCall(Node callNode) {
            Preconditions.checkArgument(callNode.isCall(), callNode);
            if (!callNode.hasTwoChildren()) {
                return false;
            }
            Node fn = callNode.getFirstChild();
            if (!fn.isGetProp()) {
                return false;
            }
            Node callee = fn.getFirstChild();
            Node method = fn.getSecondChild();
            return method.isString() && "hasOwnProperty".equals(method.getString()) && callee.isQualifiedName();
        }

        Ref.Type determineGetTypeForHookOrBooleanExpr(JSModule module, Scope scope, Node parent, String name) {
            Node prev = parent;
            for (Node anc : parent.getAncestors()) {
                switch (anc.getToken()) {
                    case VAR: 
                    case LET: 
                    case CONST: 
                    case EXPR_RESULT: 
                    case IF: 
                    case INSTANCEOF: 
                    case TYPEOF: 
                    case VOID: 
                    case NOT: 
                    case BITNOT: 
                    case POS: 
                    case NEG: 
                    case WHILE: 
                    case FOR: 
                    case FOR_IN: {
                        return Ref.Type.DIRECT_GET;
                    }
                    case HOOK: {
                        if (anc.getFirstChild() != prev) break;
                        return Ref.Type.DIRECT_GET;
                    }
                    case ASSIGN: {
                        if (anc.getFirstChild().matchesQualifiedName(name)) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case NAME: {
                        if (name.equals(anc.getString())) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case CALL: {
                        if (anc.getFirstChild() == prev) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case DELPROP: {
                        return Ref.Type.DELETE_PROP;
                    }
                }
                prev = anc;
            }
            return Ref.Type.ALIASING_GET;
        }

        boolean maybeHandlePrototypePrefix(JSModule module, Scope scope, Node n, Node parent, String name) {
            int i;
            String prefix;
            int numLevelsToRemove;
            if (name.endsWith(".prototype")) {
                numLevelsToRemove = 1;
                prefix = name.substring(0, name.length() - 10);
            } else {
                i = name.indexOf(".prototype.");
                if (i == -1) {
                    return false;
                }
                prefix = name.substring(0, i);
                numLevelsToRemove = 2;
                i = name.indexOf(46, i + 11);
                while (i >= 0) {
                    ++numLevelsToRemove;
                    i = name.indexOf(46, i + 1);
                }
            }
            if (parent != null && NodeUtil.mayBeObjectLitKey(n)) {
                return true;
            }
            for (i = 0; i < numLevelsToRemove; ++i) {
                parent = n;
                n = n.getFirstChild();
            }
            this.handleGet(module, scope, n, parent, prefix, Ref.Type.PROTOTYPE_GET);
            return true;
        }

        boolean isNestedAssign(Node parent) {
            return parent.isAssign() && !parent.getParent().isExprResult();
        }

        Name getOrCreateName(String name) {
            Name node = (Name)GlobalNamespace.this.nameMap.get(name);
            if (node == null) {
                int i = name.lastIndexOf(46);
                if (i >= 0) {
                    String parentName = name.substring(0, i);
                    Name parent = this.getOrCreateName(parentName);
                    node = parent.addProperty(name.substring(i + 1), GlobalNamespace.this.sourceKind);
                } else {
                    node = new Name(name, null, GlobalNamespace.this.sourceKind);
                    GlobalNamespace.this.globalNames.add(node);
                }
                GlobalNamespace.this.nameMap.put(name, node);
            }
            return node;
        }
    }

    static class AstChange {
        final JSModule module;
        final Scope scope;
        final Node node;

        AstChange(JSModule module, Scope scope, Node node) {
            this.module = module;
            this.scope = scope;
            this.node = node;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AstChange) {
                AstChange other = (AstChange)obj;
                return Objects.equals(this.module, other.module) && Objects.equals(this.scope, other.scope) && Objects.equals(this.node, other.node);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.module, this.scope, this.node);
        }
    }

    static enum SourceKind {
        EXTERN,
        TYPE_SUMMARY,
        CODE;


        static SourceKind fromScriptNode(Node n) {
            if (!n.isFromExterns()) {
                return CODE;
            }
            if (NodeUtil.isFromTypeSummary(n)) {
                return TYPE_SUMMARY;
            }
            return EXTERN;
        }
    }
}

