/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.ExportTrace;
import com.google.javascript.jscomp.modules.GoogEsImports;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMapCreator;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.modules.ModuleRequestResolver;
import com.google.javascript.jscomp.modules.ResolveExportResult;
import com.google.javascript.jscomp.modules.UnresolvedModule;
import com.google.javascript.rhino.Node;
import java.util.Set;
import javax.annotation.Nullable;

final class NonEsModuleProcessor
implements ModuleMapCreator.ModuleProcessor {
    NonEsModuleProcessor() {
    }

    @Override
    public UnresolvedModule process(ModuleMetadataMap.ModuleMetadata metadata, ModuleLoader.ModulePath path, Node script) {
        return new NonEsModule(metadata, path, script);
    }

    private static class NonEsModule
    extends UnresolvedModule {
        private final ModuleMetadataMap.ModuleMetadata metadata;
        private final ModuleLoader.ModulePath path;
        private final Node scriptNode;

        NonEsModule(ModuleMetadataMap.ModuleMetadata metadata, ModuleLoader.ModulePath path, Node scriptNode) {
            this.metadata = metadata;
            this.path = path;
            this.scriptNode = scriptNode;
        }

        @Override
        @Nullable
        public ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, String exportName) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier, String exportName, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
            String namespace = null;
            if (moduleSpecifier != null && GoogEsImports.isGoogImportSpecifier(moduleSpecifier)) {
                namespace = GoogEsImports.getClosureIdFromGoogImportSpecifier(moduleSpecifier);
            }
            if (this.metadata.isCommonJs() && !exportName.equals("default")) {
                return ResolveExportResult.NOT_FOUND;
            }
            return ResolveExportResult.of(Binding.from(Export.builder().exportName(exportName).moduleMetadata(this.metadata).modulePath(this.path).closureNamespace(namespace).build(), this.scriptNode));
        }

        @Override
        void reset() {
        }

        @Override
        public Module resolve(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier) {
            String namespace = null;
            if (moduleSpecifier != null && GoogEsImports.isGoogImportSpecifier(moduleSpecifier)) {
                namespace = GoogEsImports.getClosureIdFromGoogImportSpecifier(moduleSpecifier);
            }
            return Module.builder().path(this.path).metadata(this.metadata).namespace(ImmutableMap.of()).boundNames(ImmutableMap.of()).localNameToLocalExport(ImmutableMap.of()).closureNamespace(namespace).unresolvedModule(this).build();
        }

        @Override
        ModuleMetadataMap.ModuleMetadata metadata() {
            return this.metadata;
        }

        @Override
        public ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver, Set<UnresolvedModule> visited) {
            throw new UnsupportedOperationException();
        }
    }
}

