/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.ClosurePrimitive;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class CodingConventions {
    private CodingConventions() {
    }

    public static CodingConvention getDefault() {
        return new DefaultCodingConvention();
    }

    public static boolean defaultIsFunctionCallThatAlwaysThrows(Node n, String alwaysThrowsFunctionName) {
        if (n.isExprResult() ? !n.getFirstChild().isCall() : !n.isCall()) {
            return false;
        }
        if (n.isExprResult()) {
            n = n.getFirstChild();
        }
        return n.getFirstChild().matchesQualifiedName(alwaysThrowsFunctionName);
    }

    static boolean isAliasingGlobalThis(CodingConvention convention, Node n) {
        return n.isAssign() && n.getFirstChild().matchesQualifiedName(convention.getGlobalObject()) && n.getLastChild().isThis();
    }

    @Immutable
    private static class DefaultCodingConvention
    implements CodingConvention {
        private static final long serialVersionUID = 1L;

        private DefaultCodingConvention() {
        }

        @Override
        public boolean isConstant(String variableName) {
            return false;
        }

        @Override
        public boolean isConstantKey(String variableName) {
            return false;
        }

        @Override
        public boolean isValidEnumKey(String key) {
            return key != null && key.length() > 0;
        }

        @Override
        public boolean isOptionalParameter(Node parameter) {
            return parameter.isOptionalArg();
        }

        @Override
        public boolean isVarArgsParameter(Node parameter) {
            return parameter.isRest() || parameter.isVarArgs();
        }

        @Override
        public boolean isFunctionCallThatAlwaysThrows(Node n) {
            if (NodeUtil.isExprCall(n)) {
                FunctionType fnType = FunctionType.toMaybeFunctionType(n.getFirstFirstChild().getJSType());
                return fnType != null && ClosurePrimitive.ASSERTS_FAIL == fnType.getClosurePrimitive();
            }
            return false;
        }

        @Override
        public String getPackageName(StaticSourceFile source) {
            String name = source.getName();
            int lastSlash = name.lastIndexOf(47);
            return lastSlash == -1 ? "" : name.substring(0, lastSlash);
        }

        @Override
        public boolean isExported(String name, boolean local) {
            return local && name.startsWith("$super");
        }

        @Override
        public boolean isExported(String name) {
            return this.isExported(name, false) || this.isExported(name, true);
        }

        @Override
        public boolean blockRenamingForProperty(String name) {
            return false;
        }

        @Override
        public boolean isPrivate(String name) {
            return false;
        }

        @Override
        public boolean hasPrivacyConvention() {
            return false;
        }

        @Override
        public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
            Node callName = callNode.getFirstChild();
            if ((callName.matchesQualifiedName("$jscomp.inherits") || callName.matchesName("$jscomp$inherits")) && callNode.hasXChildren(3)) {
                Node subclass = callName.getNext();
                Node superclass = subclass.getNext();
                if (subclass.isQualifiedName() && superclass.isQualifiedName()) {
                    return new CodingConvention.SubclassRelationship(CodingConvention.SubclassType.INHERITS, subclass, superclass);
                }
            }
            return null;
        }

        @Override
        public boolean isClassFactoryCall(Node callNode) {
            return false;
        }

        @Override
        public boolean isSuperClassReference(String propertyName) {
            return false;
        }

        @Override
        public boolean extractIsModuleFile(Node node, Node parent) {
            String message = "only implemented in ClosureCodingConvention";
            throw new UnsupportedOperationException(message);
        }

        @Override
        public String extractClassNameIfProvide(Node node, Node parent) {
            String message = "only implemented in ClosureCodingConvention";
            throw new UnsupportedOperationException(message);
        }

        @Override
        public String extractClassNameIfRequire(Node node, Node parent) {
            String message = "only implemented in ClosureCodingConvention";
            throw new UnsupportedOperationException(message);
        }

        @Override
        public String getExportPropertyFunction() {
            return null;
        }

        @Override
        public String getExportSymbolFunction() {
            return null;
        }

        @Override
        public List<String> identifyTypeDeclarationCall(Node n) {
            return null;
        }

        @Override
        public void applySubclassRelationship(NominalTypeBuilder parent, NominalTypeBuilder child, CodingConvention.SubclassType type) {
        }

        @Override
        public String getAbstractMethodName() {
            return null;
        }

        @Override
        public String getSingletonGetterClassName(Node callNode) {
            return null;
        }

        @Override
        public void applySingletonGetter(NominalTypeBuilder classType, FunctionType getterType) {
        }

        @Override
        public boolean isInlinableFunction(Node n) {
            Preconditions.checkState(n.isFunction(), n);
            return true;
        }

        @Override
        public CodingConvention.DelegateRelationship getDelegateRelationship(Node callNode) {
            return null;
        }

        @Override
        public void applyDelegateRelationship(NominalTypeBuilder delegateSuperclass, NominalTypeBuilder delegateBase, NominalTypeBuilder delegator, ObjectType delegateProxy, FunctionType findDelegate) {
        }

        @Override
        public String getDelegateSuperclassName() {
            return null;
        }

        @Override
        public void checkForCallingConventionDefinitions(Node n, Map<String, String> delegateCallingConventions) {
        }

        @Override
        public void defineDelegateProxyPrototypeProperties(JSTypeRegistry registry, List<NominalTypeBuilder> delegateProxies, Map<String, String> delegateCallingConventions) {
        }

        @Override
        public String getGlobalObject() {
            return "window";
        }

        @Override
        public boolean isAliasingGlobalThis(Node n) {
            return CodingConventions.isAliasingGlobalThis(this, n);
        }

        @Override
        public boolean isPropertyTestFunction(Node call) {
            return call.getFirstChild().matchesQualifiedName("Array.isArray");
        }

        @Override
        public boolean isPropertyRenameFunction(String name) {
            return "JSCompiler_renameProperty".equals(name) || "$jscomp.reflectProperty".equals(name);
        }

        @Override
        public boolean isPrototypeAlias(Node getProp) {
            return false;
        }

        @Override
        public CodingConvention.ObjectLiteralCast getObjectLiteralCast(Node callNode) {
            return null;
        }

        public ImmutableSet<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
            return ImmutableSet.of(CodingConvention.AssertionFunctionSpec.forTruthy().setClosurePrimitive(ClosurePrimitive.ASSERTS_TRUTHY).build(), CodingConvention.AssertionFunctionSpec.forMatchesReturn().setClosurePrimitive(ClosurePrimitive.ASSERTS_MATCHES_RETURN).build());
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n) {
            return this.describeFunctionBind(n, false, false);
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n, boolean callerChecksTypes, boolean iCheckTypes) {
            if (!n.isCall()) {
                return null;
            }
            Node callTarget = n.getFirstChild();
            if (callTarget.isQualifiedName() && callTarget.matchesQualifiedName("Function.prototype.bind.call")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = DefaultCodingConvention.safeNext(fn);
                Node parameters = DefaultCodingConvention.safeNext(thisValue);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
            if (callTarget.isGetProp() && callTarget.getLastChild().getString().equals("bind")) {
                Node maybeFn = callTarget.getFirstChild();
                JSType maybeFnType = maybeFn.getJSType();
                FunctionType fnType = null;
                if (iCheckTypes && maybeFnType != null) {
                    fnType = maybeFnType.restrictByNotNullOrUndefined().toMaybeFunctionType();
                }
                if (fnType != null || callerChecksTypes || maybeFn.isFunction()) {
                    Node thisValue = callTarget.getNext();
                    Node parameters = DefaultCodingConvention.safeNext(thisValue);
                    return new CodingConvention.Bind(maybeFn, thisValue, parameters);
                }
            }
            return null;
        }

        @Override
        public CodingConvention.Cache describeCachingCall(Node node) {
            return null;
        }

        @Override
        public Collection<String> getIndirectlyDeclaredProperties() {
            return ImmutableList.of();
        }

        private static Node safeNext(Node n) {
            if (n != null) {
                return n.getNext();
            }
            return null;
        }
    }

    @Immutable
    public static class Proxy
    implements CodingConvention {
        protected final CodingConvention nextConvention;

        protected Proxy(CodingConvention convention) {
            this.nextConvention = convention;
        }

        @Override
        public boolean isConstant(String variableName) {
            return this.nextConvention.isConstant(variableName);
        }

        @Override
        public boolean isConstantKey(String keyName) {
            return this.nextConvention.isConstantKey(keyName);
        }

        @Override
        public boolean isValidEnumKey(String key) {
            return this.nextConvention.isValidEnumKey(key);
        }

        @Override
        public boolean isOptionalParameter(Node parameter) {
            return this.nextConvention.isOptionalParameter(parameter);
        }

        @Override
        public boolean isVarArgsParameter(Node parameter) {
            return this.nextConvention.isVarArgsParameter(parameter);
        }

        @Override
        public boolean isFunctionCallThatAlwaysThrows(Node n) {
            return this.nextConvention.isFunctionCallThatAlwaysThrows(n);
        }

        @Override
        public boolean isExported(String name, boolean local) {
            return this.nextConvention.isExported(name, local);
        }

        @Override
        public final boolean isExported(String name) {
            return this.isExported(name, false) || this.isExported(name, true);
        }

        @Override
        public String getPackageName(StaticSourceFile source) {
            return this.nextConvention.getPackageName(source);
        }

        @Override
        public boolean blockRenamingForProperty(String name) {
            return this.nextConvention.blockRenamingForProperty(name);
        }

        @Override
        public boolean isPrivate(String name) {
            return this.nextConvention.isPrivate(name);
        }

        @Override
        public boolean hasPrivacyConvention() {
            return this.nextConvention.hasPrivacyConvention();
        }

        @Override
        public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
            return this.nextConvention.getClassesDefinedByCall(callNode);
        }

        @Override
        public boolean isClassFactoryCall(Node callNode) {
            return this.nextConvention.isClassFactoryCall(callNode);
        }

        @Override
        public boolean isSuperClassReference(String propertyName) {
            return this.nextConvention.isSuperClassReference(propertyName);
        }

        @Override
        public boolean extractIsModuleFile(Node node, Node parent) {
            return this.nextConvention.extractIsModuleFile(node, parent);
        }

        @Override
        public String extractClassNameIfProvide(Node node, Node parent) {
            return this.nextConvention.extractClassNameIfProvide(node, parent);
        }

        @Override
        public String extractClassNameIfRequire(Node node, Node parent) {
            return this.nextConvention.extractClassNameIfRequire(node, parent);
        }

        @Override
        public String getExportPropertyFunction() {
            return this.nextConvention.getExportPropertyFunction();
        }

        @Override
        public String getExportSymbolFunction() {
            return this.nextConvention.getExportSymbolFunction();
        }

        @Override
        public List<String> identifyTypeDeclarationCall(Node n) {
            return this.nextConvention.identifyTypeDeclarationCall(n);
        }

        @Override
        public void applySubclassRelationship(NominalTypeBuilder parent, NominalTypeBuilder child, CodingConvention.SubclassType type) {
            this.nextConvention.applySubclassRelationship(parent, child, type);
        }

        @Override
        public String getAbstractMethodName() {
            return this.nextConvention.getAbstractMethodName();
        }

        @Override
        public String getSingletonGetterClassName(Node callNode) {
            return this.nextConvention.getSingletonGetterClassName(callNode);
        }

        @Override
        public void applySingletonGetter(NominalTypeBuilder classType, FunctionType getterType) {
            this.nextConvention.applySingletonGetter(classType, getterType);
        }

        @Override
        public boolean isInlinableFunction(Node n) {
            return this.nextConvention.isInlinableFunction(n);
        }

        @Override
        public CodingConvention.DelegateRelationship getDelegateRelationship(Node callNode) {
            return this.nextConvention.getDelegateRelationship(callNode);
        }

        @Override
        public void applyDelegateRelationship(NominalTypeBuilder delegateSuperclass, NominalTypeBuilder delegateBase, NominalTypeBuilder delegator, ObjectType delegateProxy, FunctionType findDelegate) {
            this.nextConvention.applyDelegateRelationship(delegateSuperclass, delegateBase, delegator, delegateProxy, findDelegate);
        }

        @Override
        public String getDelegateSuperclassName() {
            return this.nextConvention.getDelegateSuperclassName();
        }

        @Override
        public void checkForCallingConventionDefinitions(Node n, Map<String, String> delegateCallingConventions) {
            this.nextConvention.checkForCallingConventionDefinitions(n, delegateCallingConventions);
        }

        @Override
        public void defineDelegateProxyPrototypeProperties(JSTypeRegistry registry, List<NominalTypeBuilder> delegateProxies, Map<String, String> delegateCallingConventions) {
            this.nextConvention.defineDelegateProxyPrototypeProperties(registry, delegateProxies, delegateCallingConventions);
        }

        @Override
        public String getGlobalObject() {
            return this.nextConvention.getGlobalObject();
        }

        @Override
        public boolean isAliasingGlobalThis(Node n) {
            return this.nextConvention.isAliasingGlobalThis(n);
        }

        @Override
        public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
            return this.nextConvention.getAssertionFunctions();
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n) {
            return this.describeFunctionBind(n, false, false);
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n, boolean callerChecksTypes, boolean iCheckTypes) {
            return this.nextConvention.describeFunctionBind(n, callerChecksTypes, iCheckTypes);
        }

        @Override
        public CodingConvention.Cache describeCachingCall(Node node) {
            return this.nextConvention.describeCachingCall(node);
        }

        @Override
        public boolean isPropertyTestFunction(Node call) {
            return this.nextConvention.isPropertyTestFunction(call);
        }

        @Override
        public boolean isPropertyRenameFunction(String name) {
            return this.nextConvention.isPropertyRenameFunction(name);
        }

        @Override
        public boolean isPrototypeAlias(Node getProp) {
            return false;
        }

        @Override
        public CodingConvention.ObjectLiteralCast getObjectLiteralCast(Node callNode) {
            return this.nextConvention.getObjectLiteralCast(callNode);
        }

        @Override
        public Collection<String> getIndirectlyDeclaredProperties() {
            return this.nextConvention.getIndirectlyDeclaredProperties();
        }
    }
}

