/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionInjector;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class J2clPass
implements CompilerPass {
    private static final String ALL_CLASS_FILE_NAMES = "*";
    private final AbstractCompiler compiler;
    private final Supplier<String> safeNameIdSupplier;

    public J2clPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.safeNameIdSupplier = compiler.getUniqueNameIdSupplier();
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        this.inlineFunctionsInFile(root, "Arrays.impl.java.js", ImmutableSet.of("$create", "$init", "$instanceIsOfType", "$castTo", "$stampType"), FunctionInjector.InliningMode.DIRECT);
        this.inlineFunctionsInFile(root, "Casts.impl.java.js", ImmutableSet.of("$to"), FunctionInjector.InliningMode.DIRECT);
        this.inlineFunctionsInFile(root, ALL_CLASS_FILE_NAMES, ImmutableSet.of("$markImplementor"), FunctionInjector.InliningMode.BLOCK);
        this.inlineFunctionsInFile(root, "Util.impl.java.js", ImmutableSet.of("$setClassMetadata", "$setClassMetadataForInterface", "$setClassMetadataForEnum", "$setClassMetadataForPrimitive"), FunctionInjector.InliningMode.BLOCK);
    }

    private void inlineFunctionsInFile(Node root, String classFileName, Set<String> fnNamesToInline, FunctionInjector.InliningMode inliningMode) {
        new ClassStaticFunctionsInliner(root, classFileName, fnNamesToInline, inliningMode).run();
    }

    private class ClassStaticFunctionsInliner {
        private final String classFileName;
        private final Set<String> fnNamesToInline;
        private final FunctionInjector.InliningMode inliningMode;
        private final Map<String, Node> fnsToInlineByQualifiedName = new HashMap<String, Node>();
        private final FunctionInjector injector;
        private final Node root;

        private ClassStaticFunctionsInliner(Node root, String classFileName, Set<String> fnNamesToInline, FunctionInjector.InliningMode inliningMode) {
            this.root = root;
            this.classFileName = classFileName;
            this.fnNamesToInline = fnNamesToInline;
            this.inliningMode = inliningMode;
            this.injector = new FunctionInjector.Builder(J2clPass.this.compiler).safeNameIdSupplier(J2clPass.this.safeNameIdSupplier).assumeStrictThis(true).assumeMinimumCapture(true).build();
            this.injector.setKnownConstants(fnNamesToInline);
        }

        private void run() {
            NodeTraversal.traverse(J2clPass.this.compiler, this.root, new FunctionDefsCollector());
            NodeTraversal.traverse(J2clPass.this.compiler, this.root, new StaticCallInliner());
        }

        private class StaticCallInliner
        extends NodeTraversal.AbstractPostOrderCallback {
            private StaticCallInliner() {
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (!n.isCall()) {
                    return;
                }
                Node qualifiedNameNode = n.getFirstChild();
                if (!qualifiedNameNode.isGetProp() || !qualifiedNameNode.isQualifiedName()) {
                    return;
                }
                String qualifiedFnName = qualifiedNameNode.getQualifiedName();
                String fnName = qualifiedNameNode.getLastChild().getString();
                Node fnImpl = (Node)ClassStaticFunctionsInliner.this.fnsToInlineByQualifiedName.get(qualifiedFnName);
                if (fnImpl == null) {
                    return;
                }
                if (ClassStaticFunctionsInliner.this.inliningMode == FunctionInjector.InliningMode.DIRECT && !NodeUtil.getFunctionBody(fnImpl).getFirstChild().isReturn()) {
                    throw new IllegalStateException("Attempted to direct inline function " + qualifiedFnName + ", but function is not a simple return.");
                }
                Node inlinedCall = ClassStaticFunctionsInliner.this.injector.unsafeInline(new FunctionInjector.Reference(n, t.getScope(), t.getModule(), ClassStaticFunctionsInliner.this.inliningMode), fnName, fnImpl);
                inlinedCall.useSourceInfoFromForTree(n);
                t.getCompiler().reportChangeToEnclosingScope(inlinedCall);
            }
        }

        private class FunctionDefsCollector
        implements NodeTraversal.Callback {
            private FunctionDefsCollector() {
            }

            @Override
            public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                return !n.isScript() || n.getSourceFileName().endsWith(ClassStaticFunctionsInliner.this.classFileName) || ClassStaticFunctionsInliner.this.classFileName.equals(J2clPass.ALL_CLASS_FILE_NAMES);
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                String fnName;
                String qualifiedFnName;
                switch (n.getToken()) {
                    case ASSIGN: {
                        if (!n.getLastChild().isFunction()) {
                            return;
                        }
                        Node qualifiedNameNode = n.getFirstChild();
                        if (!qualifiedNameNode.isGetProp() || !qualifiedNameNode.isQualifiedName()) {
                            return;
                        }
                        qualifiedFnName = qualifiedNameNode.getQualifiedName();
                        fnName = qualifiedNameNode.getLastChild().getString();
                        break;
                    }
                    case MEMBER_FUNCTION_DEF: {
                        qualifiedFnName = NodeUtil.getBestLValueName(n);
                        fnName = n.getString();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (ClassStaticFunctionsInliner.this.fnNamesToInline.contains(fnName)) {
                    ClassStaticFunctionsInliner.this.fnsToInlineByQualifiedName.put(qualifiedFnName, n.getLastChild());
                }
            }
        }
    }
}

