/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipFile;

@GwtIncompatible(value="java.util.zip.ZipFile")
final class ZipEntryReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ZIP_CACHE_SIZE = Integer.parseInt(System.getProperty("jscomp.zipfile.cachesize", "1000"));
    private static final LoadingCache<String, CachedZipFile> zipFileCache = CacheBuilder.newBuilder().maximumSize(ZIP_CACHE_SIZE).removalListener(notification -> {
        try {
            ((CachedZipFile)notification.getValue()).maybeClose();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }).build(new CacheLoader<String, CachedZipFile>(){

        @Override
        public CachedZipFile load(String key) throws IOException {
            return new CachedZipFile(key);
        }
    });
    private final String zipPath;
    private final String entryName;

    public ZipEntryReader(String zipPath, String entryName) {
        this.zipPath = zipPath;
        this.entryName = entryName;
    }

    public Reader getReader(Charset charset) throws IOException {
        CachedZipFile zipFile = zipFileCache.getUnchecked(this.zipPath);
        return new BufferedReader(zipFile.getReader(this.entryName, charset));
    }

    public String read(Charset charset) throws IOException {
        CachedZipFile zipFile = zipFileCache.getUnchecked(this.zipPath);
        return CharStreams.toString(zipFile.getReader(this.entryName, charset));
    }

    private static class CachedZipFile {
        private final Path path;
        private ZipFile zipFile;
        private volatile FileTime lastModified;

        private CachedZipFile(String zipName) {
            this.path = Paths.get(zipName, new String[0]);
        }

        private Reader getReader(String entryName, Charset charset) throws IOException {
            this.refreshIfNeeded();
            return new InputStreamReader(this.zipFile.getInputStream(this.zipFile.getEntry(entryName)), charset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshIfNeeded() throws IOException {
            FileTime newLastModified = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            if (newLastModified.equals(this.lastModified)) {
                return;
            }
            CachedZipFile cachedZipFile = this;
            synchronized (cachedZipFile) {
                if (newLastModified.equals(this.lastModified)) {
                    return;
                }
                this.maybeClose();
                this.zipFile = new ZipFile(this.path.toFile());
                this.lastModified = newLastModified;
            }
        }

        private void maybeClose() throws IOException {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
    }
}

