/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.Keywords;
import com.google.javascript.jscomp.parsing.parser.LineNumberScanner;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.StringLiteralToken;
import com.google.javascript.jscomp.parsing.parser.TemplateLiteralToken;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class Scanner {
    private final boolean parseTypeSyntax;
    private final ErrorReporter errorReporter;
    private final SourceFile source;
    private final LineNumberScanner lineNumberScanner;
    private final String contents;
    private final int contentsLength;
    private final ArrayList<Token> currentTokens = new ArrayList();
    private int index;
    private final CommentRecorder commentRecorder;
    private int typeParameterLevel;

    public Scanner(boolean parseTypeSyntax, ErrorReporter errorReporter, CommentRecorder commentRecorder, SourceFile source) {
        this(parseTypeSyntax, errorReporter, commentRecorder, source, 0);
    }

    public Scanner(boolean parseTypeSyntax, ErrorReporter errorReporter, CommentRecorder commentRecorder, SourceFile file, int offset) {
        this.parseTypeSyntax = parseTypeSyntax;
        this.errorReporter = errorReporter;
        this.commentRecorder = commentRecorder;
        this.source = file;
        this.lineNumberScanner = new LineNumberScanner(this.source);
        this.contents = file.contents;
        this.contentsLength = file.contents.length();
        this.index = offset;
        this.typeParameterLevel = 0;
    }

    public SourceFile getFile() {
        return this.source;
    }

    public int getOffset() {
        return this.currentTokens.isEmpty() ? this.index : this.peekToken().location.start.offset;
    }

    public void setPosition(SourcePosition position) {
        this.lineNumberScanner.rewindTo(position);
        this.currentTokens.clear();
        this.index = position.offset;
    }

    public SourcePosition getPosition() {
        return this.currentTokens.isEmpty() ? this.getPosition(this.index) : this.peekToken().location.start;
    }

    private SourcePosition getPosition(int offset) {
        return this.lineNumberScanner.getSourcePosition(offset);
    }

    private SourceRange getTokenRange(int startOffset) {
        return this.lineNumberScanner.getSourceRange(startOffset, this.index);
    }

    public Token nextToken() {
        this.peekToken();
        return this.currentTokens.remove(0);
    }

    private void clearTokenLookahead() {
        if (!this.currentTokens.isEmpty()) {
            this.setPosition(this.peekToken().location.start);
        }
    }

    public LiteralToken nextRegularExpressionLiteralToken() {
        this.clearTokenLookahead();
        int beginToken = this.index;
        this.nextChar();
        if (!this.skipRegularExpressionBody()) {
            return new LiteralToken(TokenType.REGULAR_EXPRESSION, this.getTokenString(beginToken), this.getTokenRange(beginToken));
        }
        if (this.peekChar() != '/') {
            this.reportError("Expected '/' in regular expression literal", new Object[0]);
            return new LiteralToken(TokenType.REGULAR_EXPRESSION, this.getTokenString(beginToken), this.getTokenRange(beginToken));
        }
        this.nextChar();
        while (Scanner.isIdentifierPart(this.peekChar())) {
            this.nextChar();
        }
        return new LiteralToken(TokenType.REGULAR_EXPRESSION, this.getTokenString(beginToken), this.getTokenRange(beginToken));
    }

    public TemplateLiteralToken nextTemplateLiteralToken() {
        Token token = this.nextToken();
        if (this.isAtEnd() || token.type != TokenType.CLOSE_CURLY) {
            this.reportError(this.getPosition(this.index), "Expected '}' after expression in template literal", new Object[0]);
        }
        return this.nextTemplateLiteralTokenShared(TokenType.TEMPLATE_TAIL, TokenType.TEMPLATE_MIDDLE);
    }

    private boolean skipRegularExpressionBody() {
        if (!Scanner.isRegularExpressionFirstChar(this.peekChar())) {
            this.reportError("Expected regular expression first char", new Object[0]);
            return false;
        }
        if (!this.skipRegularExpressionChar()) {
            return false;
        }
        while (!this.isAtEnd() && Scanner.isRegularExpressionChar(this.peekChar())) {
            if (this.skipRegularExpressionChar()) continue;
            return false;
        }
        return true;
    }

    private boolean skipRegularExpressionChar() {
        switch (this.peekChar()) {
            case '\\': {
                return this.skipRegularExpressionBackslashSequence();
            }
            case '[': {
                return this.skipRegularExpressionClass();
            }
        }
        this.nextChar();
        return true;
    }

    private boolean skipRegularExpressionBackslashSequence() {
        this.nextChar();
        if (Scanner.isLineTerminator(this.peekChar())) {
            this.reportError("New line not allowed in regular expression literal", new Object[0]);
            return false;
        }
        this.nextChar();
        return true;
    }

    private boolean skipRegularExpressionClass() {
        this.nextChar();
        while (!this.isAtEnd() && this.peekRegularExpressionClassChar()) {
            if (this.skipRegularExpressionClassChar()) continue;
            return false;
        }
        if (this.peekChar() != ']') {
            this.reportError("']' expected", new Object[0]);
            return false;
        }
        this.nextChar();
        return true;
    }

    private boolean peekRegularExpressionClassChar() {
        return this.peekChar() != ']' && !Scanner.isLineTerminator(this.peekChar());
    }

    private boolean skipRegularExpressionClassChar() {
        if (this.peek('\\')) {
            return this.skipRegularExpressionBackslashSequence();
        }
        this.nextChar();
        return true;
    }

    private static boolean isRegularExpressionFirstChar(char ch) {
        return Scanner.isRegularExpressionChar(ch) && ch != '*';
    }

    private static boolean isRegularExpressionChar(char ch) {
        switch (ch) {
            case '/': {
                return false;
            }
            case '[': 
            case '\\': {
                return true;
            }
        }
        return !Scanner.isLineTerminator(ch);
    }

    public Token peekToken() {
        return this.peekToken(0);
    }

    public Token peekToken(int index) {
        while (this.currentTokens.size() <= index) {
            this.currentTokens.add(this.scanToken());
        }
        return this.currentTokens.get(index);
    }

    private boolean isAtEnd() {
        return !this.isValidIndex(this.index);
    }

    private boolean isValidIndex(int index) {
        return index >= 0 & index < this.contentsLength;
    }

    private boolean skipWhitespace() {
        boolean foundLineTerminator = false;
        while (!this.isAtEnd() && this.peekWhitespace()) {
            if (!Scanner.isLineTerminator(this.nextChar())) continue;
            foundLineTerminator = true;
        }
        return foundLineTerminator;
    }

    private boolean peekWhitespace() {
        return Scanner.isWhitespace(this.peekChar());
    }

    private static boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u00a0': 
            case '\u2028': 
            case '\u2029': 
            case '\u3000': 
            case '\ufeff': {
                return true;
            }
        }
        return false;
    }

    private static boolean isLineTerminator(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private static boolean isStringLineTerminator(char ch) {
        switch (ch) {
            case '\u2028': 
            case '\u2029': {
                return false;
            }
        }
        return Scanner.isLineTerminator(ch);
    }

    private void skipComments() {
        while (this.skipComment()) {
        }
    }

    private boolean skipComment() {
        boolean isStartOfLine = this.skipWhitespace();
        if (!this.isAtEnd()) {
            switch (this.peekChar(0)) {
                case '/': {
                    switch (this.peekChar(1)) {
                        case '/': {
                            this.skipSingleLineComment();
                            return true;
                        }
                        case '*': {
                            this.skipMultiLineComment();
                            return true;
                        }
                    }
                    break;
                }
                case '<': {
                    if (this.peekChar(1) != '!' || this.peekChar(2) != '-' || this.peekChar(3) != '-') break;
                    this.reportHtmlCommentWarning();
                    this.skipSingleLineComment();
                    return true;
                }
                case '-': {
                    if (!isStartOfLine || this.peekChar(1) != '-' || this.peekChar(2) != '>') break;
                    this.reportHtmlCommentWarning();
                    this.skipSingleLineComment();
                    return true;
                }
                case '#': {
                    if (this.index != 0 || this.peekChar(1) != '!') break;
                    this.skipSingleLineComment(Comment.Type.SHEBANG);
                    return true;
                }
            }
        }
        return false;
    }

    private void reportHtmlCommentWarning() {
        this.reportWarning("In some cases, '<!--' and '-->' are treated as a '//' for legacy reasons. Removing this from your code is safe for all browsers currently in use.", new Object[0]);
    }

    private void skipSingleLineComment() {
        this.skipSingleLineComment(Comment.Type.LINE);
    }

    private void skipSingleLineComment(Comment.Type type) {
        int startOffset = this.index;
        while (!this.isAtEnd() && !Scanner.isLineTerminator(this.peekChar())) {
            this.nextChar();
        }
        SourceRange range = this.lineNumberScanner.getSourceRange(startOffset, this.index);
        String value = this.contents.substring(startOffset, this.index);
        this.recordComment(type, range, value);
    }

    private void recordComment(Comment.Type type, SourceRange range, String value) {
        this.commentRecorder.recordComment(type, range, value);
    }

    private void skipMultiLineComment() {
        int startOffset = this.index;
        this.nextChar();
        this.nextChar();
        while (!(this.isAtEnd() || this.peekChar() == '*' && this.peekChar(1) == '/')) {
            this.nextChar();
        }
        if (!this.isAtEnd()) {
            this.nextChar();
            this.nextChar();
            Comment.Type type = Comment.Type.BLOCK;
            if (this.index - startOffset > 4) {
                if (this.contents.charAt(startOffset + 2) == '*') {
                    type = Comment.Type.JSDOC;
                } else if (this.contents.charAt(startOffset + 2) == '!') {
                    type = Comment.Type.IMPORTANT;
                }
            }
            SourceRange range = this.lineNumberScanner.getSourceRange(startOffset, this.index);
            String value = this.contents.substring(startOffset, this.index);
            this.recordComment(type, range, value);
        } else {
            this.reportError("unterminated comment", new Object[0]);
        }
    }

    private Token scanToken() {
        this.skipComments();
        int beginToken = this.index;
        if (this.isAtEnd()) {
            return this.createToken(TokenType.END_OF_FILE, beginToken);
        }
        char ch = this.nextChar();
        switch (ch) {
            case '{': {
                return this.createToken(TokenType.OPEN_CURLY, beginToken);
            }
            case '}': {
                return this.createToken(TokenType.CLOSE_CURLY, beginToken);
            }
            case '(': {
                return this.createToken(TokenType.OPEN_PAREN, beginToken);
            }
            case ')': {
                return this.createToken(TokenType.CLOSE_PAREN, beginToken);
            }
            case '[': {
                return this.createToken(TokenType.OPEN_SQUARE, beginToken);
            }
            case ']': {
                return this.createToken(TokenType.CLOSE_SQUARE, beginToken);
            }
            case '.': {
                if (Scanner.isDecimalDigit(this.peekChar())) {
                    return this.scanNumberPostPeriod(beginToken);
                }
                if (this.peek('.') && this.peekChar(1) == '.') {
                    this.nextChar();
                    this.nextChar();
                    return this.createToken(TokenType.ELLIPSIS, beginToken);
                }
                return this.createToken(TokenType.PERIOD, beginToken);
            }
            case ';': {
                return this.createToken(TokenType.SEMI_COLON, beginToken);
            }
            case ',': {
                return this.createToken(TokenType.COMMA, beginToken);
            }
            case '~': {
                return this.createToken(TokenType.TILDE, beginToken);
            }
            case '?': {
                return this.createToken(TokenType.QUESTION, beginToken);
            }
            case ':': {
                return this.createToken(TokenType.COLON, beginToken);
            }
            case '<': {
                switch (this.peekChar()) {
                    case '<': {
                        this.nextChar();
                        if (this.peek('=')) {
                            this.nextChar();
                            return this.createToken(TokenType.LEFT_SHIFT_EQUAL, beginToken);
                        }
                        return this.createToken(TokenType.LEFT_SHIFT, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.LESS_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.OPEN_ANGLE, beginToken);
            }
            case '>': {
                if (this.typeParameterLevel > 0) {
                    return this.createToken(TokenType.CLOSE_ANGLE, beginToken);
                }
                switch (this.peekChar()) {
                    case '>': {
                        this.nextChar();
                        switch (this.peekChar()) {
                            case '=': {
                                this.nextChar();
                                return this.createToken(TokenType.RIGHT_SHIFT_EQUAL, beginToken);
                            }
                            case '>': {
                                this.nextChar();
                                if (this.peek('=')) {
                                    this.nextChar();
                                    return this.createToken(TokenType.UNSIGNED_RIGHT_SHIFT_EQUAL, beginToken);
                                }
                                return this.createToken(TokenType.UNSIGNED_RIGHT_SHIFT, beginToken);
                            }
                        }
                        return this.createToken(TokenType.RIGHT_SHIFT, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.GREATER_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.CLOSE_ANGLE, beginToken);
            }
            case '=': {
                switch (this.peekChar()) {
                    case '=': {
                        this.nextChar();
                        if (this.peek('=')) {
                            this.nextChar();
                            return this.createToken(TokenType.EQUAL_EQUAL_EQUAL, beginToken);
                        }
                        return this.createToken(TokenType.EQUAL_EQUAL, beginToken);
                    }
                    case '>': {
                        this.nextChar();
                        return this.createToken(TokenType.ARROW, beginToken);
                    }
                }
                return this.createToken(TokenType.EQUAL, beginToken);
            }
            case '!': {
                if (this.peek('=')) {
                    this.nextChar();
                    if (this.peek('=')) {
                        this.nextChar();
                        return this.createToken(TokenType.NOT_EQUAL_EQUAL, beginToken);
                    }
                    return this.createToken(TokenType.NOT_EQUAL, beginToken);
                }
                return this.createToken(TokenType.BANG, beginToken);
            }
            case '*': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.STAR_EQUAL, beginToken);
                }
                if (this.peek('*')) {
                    this.nextChar();
                    if (this.peek('=')) {
                        this.nextChar();
                        return this.createToken(TokenType.STAR_STAR_EQUAL, beginToken);
                    }
                    return this.createToken(TokenType.STAR_STAR, beginToken);
                }
                return this.createToken(TokenType.STAR, beginToken);
            }
            case '%': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.PERCENT_EQUAL, beginToken);
                }
                return this.createToken(TokenType.PERCENT, beginToken);
            }
            case '^': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.CARET_EQUAL, beginToken);
                }
                return this.createToken(TokenType.CARET, beginToken);
            }
            case '/': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.SLASH_EQUAL, beginToken);
                }
                return this.createToken(TokenType.SLASH, beginToken);
            }
            case '+': {
                switch (this.peekChar()) {
                    case '+': {
                        this.nextChar();
                        return this.createToken(TokenType.PLUS_PLUS, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.PLUS_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.PLUS, beginToken);
            }
            case '-': {
                switch (this.peekChar()) {
                    case '-': {
                        this.nextChar();
                        return this.createToken(TokenType.MINUS_MINUS, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.MINUS_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.MINUS, beginToken);
            }
            case '&': {
                switch (this.peekChar()) {
                    case '&': {
                        this.nextChar();
                        return this.createToken(TokenType.AND, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.AMPERSAND_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.AMPERSAND, beginToken);
            }
            case '|': {
                switch (this.peekChar()) {
                    case '|': {
                        this.nextChar();
                        return this.createToken(TokenType.OR, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.BAR_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.BAR, beginToken);
            }
            case '#': {
                return this.createToken(TokenType.POUND, beginToken);
            }
            case '0': {
                return this.scanPostZero(beginToken);
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.scanPostDigit(beginToken);
            }
            case '\"': 
            case '\'': {
                return this.scanStringLiteral(beginToken, ch);
            }
            case '`': {
                return this.scanTemplateLiteral(beginToken);
            }
        }
        return this.scanIdentifierOrKeyword(beginToken, ch);
    }

    private Token scanNumberPostPeriod(int beginToken) {
        this.skipDecimalDigits();
        return this.scanExponentOfNumericLiteral(beginToken);
    }

    private Token scanPostDigit(int beginToken) {
        this.skipDecimalDigits();
        return this.scanFractionalNumericLiteral(beginToken);
    }

    private Token scanPostZero(int beginToken) {
        switch (this.peekChar()) {
            case 'B': 
            case 'b': {
                this.nextChar();
                if (!Scanner.isBinaryDigit(this.peekChar())) {
                    this.reportError("Binary Integer Literal must contain at least one digit", new Object[0]);
                }
                this.skipBinaryDigits();
                return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
            }
            case 'O': 
            case 'o': {
                this.nextChar();
                if (!Scanner.isOctalDigit(this.peekChar())) {
                    this.reportError("Octal Integer Literal must contain at least one digit", new Object[0]);
                }
                this.skipOctalDigits();
                if (this.peek('8') || this.peek('9')) {
                    this.reportError("Invalid octal digit in octal literal.", new Object[0]);
                }
                return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
            }
            case 'X': 
            case 'x': {
                this.nextChar();
                if (!this.peekHexDigit()) {
                    this.reportError("Hex Integer Literal must contain at least one digit", new Object[0]);
                }
                this.skipHexDigits();
                return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
            }
            case 'E': 
            case 'e': {
                return this.scanExponentOfNumericLiteral(beginToken);
            }
            case '.': {
                return this.scanFractionalNumericLiteral(beginToken);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.skipDecimalDigits();
                if (this.peek('.')) {
                    this.nextChar();
                    this.skipDecimalDigits();
                }
                return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
            }
        }
        return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
    }

    private Token createToken(TokenType type, int beginToken) {
        return new Token(type, this.getTokenRange(beginToken));
    }

    private Token scanIdentifierOrKeyword(int beginToken, char ch) {
        int valueStartIndex = this.index - 1;
        boolean containsUnicodeEscape = ch == '\\';
        boolean bracedUnicodeEscape = false;
        int unicodeEscapeLen = containsUnicodeEscape ? 1 : 0;
        ch = this.peekChar();
        while (Scanner.isIdentifierPart(ch) || ch == '\\' || ch == '{' && unicodeEscapeLen == 2 || ch == '}' && bracedUnicodeEscape) {
            if (ch == '\\') {
                containsUnicodeEscape = true;
            }
            if (ch == '\\' || unicodeEscapeLen > 0) {
                ++unicodeEscapeLen;
            }
            if (ch == '{') {
                bracedUnicodeEscape = true;
            }
            if (ch == '}' || unicodeEscapeLen >= 6 && !bracedUnicodeEscape) {
                bracedUnicodeEscape = false;
                unicodeEscapeLen = 0;
            }
            this.nextChar();
            ch = this.peekChar();
        }
        String value = this.contents.substring(valueStartIndex, this.index);
        if (containsUnicodeEscape && (value = Scanner.processUnicodeEscapes(value)) == null) {
            this.reportError(this.getPosition(this.index), "Invalid escape sequence", new Object[0]);
            return this.createToken(TokenType.ERROR, beginToken);
        }
        char start = value.charAt(0);
        if (!Scanner.isIdentifierStart(start)) {
            this.reportError(this.getPosition(beginToken), "Character '%c' (U+%04X) is not a valid identifier start char", Character.valueOf(start), (int)start);
            return this.createToken(TokenType.ERROR, beginToken);
        }
        Keywords k = Keywords.get(value, this.parseTypeSyntax);
        if (k != null) {
            return new Token(k.type, this.getTokenRange(beginToken));
        }
        return new IdentifierToken(this.getTokenRange(beginToken), value);
    }

    private static String processUnicodeEscapes(String value) {
        while (value.contains("\\")) {
            int escapeStart = value.indexOf(92);
            try {
                String hexDigits;
                int escapeEnd;
                if (value.charAt(escapeStart + 1) != 'u') {
                    return null;
                }
                if (value.charAt(escapeStart + 2) != '{') {
                    escapeEnd = escapeStart + 6;
                    hexDigits = value.substring(escapeStart + 2, escapeEnd);
                } else {
                    escapeEnd = escapeStart + 3;
                    while (Character.digit(value.charAt(escapeEnd), 16) >= 0) {
                        ++escapeEnd;
                    }
                    if (value.charAt(escapeEnd) != '}') {
                        return null;
                    }
                    hexDigits = value.substring(escapeStart + 3, escapeEnd);
                    ++escapeEnd;
                }
                char ch = (char)Integer.parseInt(hexDigits, 16);
                if (!Scanner.isIdentifierPart(ch)) {
                    return null;
                }
                value = value.substring(0, escapeStart) + ch + value.substring(escapeEnd);
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                return null;
            }
        }
        return value;
    }

    private static boolean isIdentifierStart(char ch) {
        if (ch <= '\u007f') {
            return ch >= 'A' & ch <= 'Z' | ch >= 'a' & ch <= 'z' | (ch == '_' | ch == '$');
        }
        return ch == '\u0275' || ch == '\u0394' || Character.isLetter(ch);
    }

    private static boolean isIdentifierPart(char ch) {
        if (ch <= '\u007f') {
            return ch >= 'A' & ch <= 'Z' | ch >= 'a' & ch <= 'z' | ch >= '0' & ch <= '9' | (ch == '_' | ch == '$');
        }
        return Scanner.isIdentifierStart(ch) || Character.isDigit(ch);
    }

    private Token scanStringLiteral(int beginIndex, char terminator) {
        boolean hasUnescapedUnicodeLineOrParagraphSeparator = false;
        while (this.peekStringLiteralChar(terminator)) {
            char c = this.peekChar();
            boolean bl = hasUnescapedUnicodeLineOrParagraphSeparator = hasUnescapedUnicodeLineOrParagraphSeparator || c == '\u2028' || c == '\u2029';
            if (this.skipStringLiteralChar()) continue;
            return new StringLiteralToken(this.getTokenString(beginIndex), this.getTokenRange(beginIndex), hasUnescapedUnicodeLineOrParagraphSeparator);
        }
        if (this.peekChar() != terminator) {
            this.reportError(this.getPosition(beginIndex), "Unterminated string literal", new Object[0]);
        } else {
            this.nextChar();
        }
        return new StringLiteralToken(this.getTokenString(beginIndex), this.getTokenRange(beginIndex), hasUnescapedUnicodeLineOrParagraphSeparator);
    }

    private Token scanTemplateLiteral(int beginIndex) {
        if (this.isAtEnd()) {
            this.reportError(this.getPosition(beginIndex), "Unterminated template literal", new Object[0]);
        }
        return this.nextTemplateLiteralTokenShared(TokenType.NO_SUBSTITUTION_TEMPLATE, TokenType.TEMPLATE_HEAD);
    }

    private TemplateLiteralToken nextTemplateLiteralTokenShared(TokenType endType, TokenType middleType) {
        int beginIndex = this.index;
        SkipTemplateCharactersResult skipTemplateCharactersResult = this.skipTemplateCharacters();
        if (this.isAtEnd()) {
            this.reportError(this.getPosition(beginIndex), "Unterminated template literal", new Object[0]);
        }
        String value = this.getTokenString(beginIndex);
        switch (this.peekChar()) {
            case '`': {
                this.nextChar();
                return new TemplateLiteralToken(endType, value, skipTemplateCharactersResult.getErrorMessage(), skipTemplateCharactersResult.getPosition(), this.getTokenRange(beginIndex - 1));
            }
            case '$': {
                this.nextChar();
                this.nextChar();
                return new TemplateLiteralToken(middleType, value, skipTemplateCharactersResult.getErrorMessage(), skipTemplateCharactersResult.getPosition(), this.getTokenRange(beginIndex - 1));
            }
        }
        return new TemplateLiteralToken(endType, value, skipTemplateCharactersResult.getErrorMessage(), skipTemplateCharactersResult.getPosition(), this.getTokenRange(beginIndex - 1));
    }

    private String getTokenString(int beginIndex) {
        return this.contents.substring(beginIndex, this.index);
    }

    private boolean peekStringLiteralChar(char terminator) {
        return !this.isAtEnd() && this.peekChar() != terminator && !Scanner.isStringLineTerminator(this.peekChar());
    }

    private boolean skipStringLiteralChar() {
        if (this.peek('\\')) {
            return this.skipStringLiteralEscapeSequence();
        }
        this.nextChar();
        return true;
    }

    private SkipTemplateCharactersResult skipTemplateCharacters() {
        SkipTemplateCharactersResult result = this.createSkipTemplateCharactersResult(null);
        block5: while (!this.isAtEnd()) {
            switch (this.peekChar()) {
                case '`': {
                    return result;
                }
                case '\\': {
                    SkipTemplateCharactersResult newError = this.skipTemplateLiteralEscapeSequence();
                    if (newError == null || result.hasError()) continue block5;
                    result = newError;
                    continue block5;
                }
                case '$': {
                    if (this.peekChar(1) != '{') break;
                    return result;
                }
            }
            this.nextChar();
        }
        return result;
    }

    private SkipTemplateCharactersResult skipTemplateLiteralEscapeSequence() {
        this.nextChar();
        if (this.isAtEnd()) {
            this.reportError("Unterminated template literal escape sequence", new Object[0]);
            return null;
        }
        if (Scanner.isLineTerminator(this.peekChar())) {
            this.skipLineTerminator();
            return null;
        }
        char next = this.nextChar();
        switch (next) {
            case '0': {
                if (this.peekOctalDigit()) {
                    return this.createSkipTemplateCharactersResult("Invalid escape sequence");
                }
                return null;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return this.createSkipTemplateCharactersResult("Invalid escape sequence");
            }
            case 'x': {
                boolean doubleHexDigit;
                boolean bl = doubleHexDigit = this.skipHexDigit() && this.skipHexDigit();
                if (!doubleHexDigit) {
                    return this.createSkipTemplateCharactersResult("Hex digit expected");
                }
                return null;
            }
            case 'u': {
                boolean quadHexDigit;
                if (this.peek('{')) {
                    this.nextChar();
                    if (this.peek('}')) {
                        return this.createSkipTemplateCharactersResult("Empty unicode escape");
                    }
                    boolean allHexDigits = true;
                    while (!this.peek('}') && allHexDigits) {
                        allHexDigits = allHexDigits && this.skipHexDigit();
                    }
                    if (!allHexDigits) {
                        return this.createSkipTemplateCharactersResult("Hex digit expected");
                    }
                    this.nextChar();
                    return null;
                }
                boolean bl = quadHexDigit = this.skipHexDigit() && this.skipHexDigit() && this.skipHexDigit() && this.skipHexDigit();
                if (!quadHexDigit) {
                    return this.createSkipTemplateCharactersResult("Hex digit expected");
                }
                return null;
            }
        }
        return null;
    }

    private boolean skipStringLiteralEscapeSequence() {
        this.nextChar();
        if (this.isAtEnd()) {
            this.reportError("Unterminated string literal escape sequence", new Object[0]);
            return false;
        }
        if (Scanner.isStringLineTerminator(this.peekChar())) {
            this.skipLineTerminator();
            return true;
        }
        char next = this.nextChar();
        switch (next) {
            case '\"': 
            case '\'': 
            case '0': 
            case '\\': 
            case '`': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                return true;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                break;
            }
            case 'x': {
                boolean doubleHexDigit;
                boolean bl = doubleHexDigit = this.skipHexDigit() && this.skipHexDigit();
                if (!doubleHexDigit) {
                    this.reportError("Hex digit expected", new Object[0]);
                }
                return doubleHexDigit;
            }
            case 'u': {
                boolean quadHexDigit;
                if (this.peek('{')) {
                    this.nextChar();
                    if (this.peek('}')) {
                        this.reportError("Empty unicode escape", new Object[0]);
                        return false;
                    }
                    boolean allHexDigits = true;
                    while (!this.peek('}') && allHexDigits) {
                        allHexDigits = allHexDigits && this.skipHexDigit();
                    }
                    if (!allHexDigits) {
                        this.reportError("Hex digit expected", new Object[0]);
                    }
                    this.nextChar();
                    return allHexDigits;
                }
                boolean bl = quadHexDigit = this.skipHexDigit() && this.skipHexDigit() && this.skipHexDigit() && this.skipHexDigit();
                if (!quadHexDigit) {
                    this.reportError("Hex digit expected", new Object[0]);
                }
                return quadHexDigit;
            }
        }
        if (next != '/') {
            this.reportWarning("Unnecessary escape: '\\%s' is equivalent to just '%s'", Character.valueOf(next), Character.valueOf(next));
        }
        return true;
    }

    private boolean skipHexDigit() {
        if (!this.peekHexDigit()) {
            return false;
        }
        this.nextChar();
        return true;
    }

    private void skipLineTerminator() {
        char first = this.nextChar();
        if (first == '\r' && this.peek('\n')) {
            this.nextChar();
        }
    }

    private LiteralToken scanFractionalNumericLiteral(int beginToken) {
        if (this.peek('.')) {
            this.nextChar();
            this.skipDecimalDigits();
        }
        return this.scanExponentOfNumericLiteral(beginToken);
    }

    private LiteralToken scanExponentOfNumericLiteral(int beginToken) {
        switch (this.peekChar()) {
            case 'E': 
            case 'e': {
                this.nextChar();
                switch (this.peekChar()) {
                    case '+': 
                    case '-': {
                        this.nextChar();
                        break;
                    }
                }
                if (!Scanner.isDecimalDigit(this.peekChar())) {
                    this.reportError("Exponent part must contain at least one digit", new Object[0]);
                }
                this.skipDecimalDigits();
                break;
            }
        }
        return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
    }

    private void skipDecimalDigits() {
        while (Scanner.isDecimalDigit(this.peekChar())) {
            this.nextChar();
        }
    }

    private static boolean isDecimalDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private boolean peekHexDigit() {
        return Character.digit(this.peekChar(), 16) >= 0;
    }

    private void skipHexDigits() {
        while (this.peekHexDigit()) {
            this.nextChar();
        }
    }

    private boolean peekOctalDigit() {
        return Scanner.isOctalDigit(this.peekChar());
    }

    private void skipOctalDigits() {
        while (this.peekOctalDigit()) {
            this.nextChar();
        }
    }

    private static boolean isOctalDigit(char ch) {
        return Scanner.valueOfOctalDigit(ch) >= 0;
    }

    private static int valueOfOctalDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return ch - 48;
            }
        }
        return -1;
    }

    private void skipBinaryDigits() {
        while (Scanner.isBinaryDigit(this.peekChar())) {
            this.nextChar();
        }
    }

    private static boolean isBinaryDigit(char ch) {
        return Scanner.valueOfBinaryDigit(ch) >= 0;
    }

    private static int valueOfBinaryDigit(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return -1;
    }

    private char nextChar() {
        if (this.isAtEnd()) {
            return '\u0000';
        }
        return this.contents.charAt(this.index++);
    }

    private boolean peek(char ch) {
        return this.peekChar() == ch;
    }

    private char peekChar() {
        return this.peekChar(0);
    }

    private char peekChar(int offset) {
        return !this.isValidIndex(this.index + offset) ? (char)'\u0000' : this.contents.charAt(this.index + offset);
    }

    @FormatMethod
    private void reportError(@FormatString String format, Object ... arguments) {
        this.reportError(this.getPosition(), format, arguments);
    }

    @FormatMethod
    private void reportError(SourcePosition position, @FormatString String format, Object ... arguments) {
        this.errorReporter.reportError(position, format, arguments);
    }

    @FormatMethod
    private void reportWarning(@FormatString String format, Object ... arguments) {
        this.errorReporter.reportWarning(this.getPosition(), format, arguments);
    }

    void incTypeParameterLevel() {
        ++this.typeParameterLevel;
    }

    void decTypeParameterLevel() {
        --this.typeParameterLevel;
    }

    private SkipTemplateCharactersResult createSkipTemplateCharactersResult(String message) {
        return new SkipTemplateCharactersResult(message, this.getPosition());
    }

    private static class SkipTemplateCharactersResult {
        @Nullable
        private final String errorMessage;
        private final SourcePosition position;

        SkipTemplateCharactersResult(String message, SourcePosition position) {
            this.errorMessage = message;
            this.position = position;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        SourcePosition getPosition() {
            return this.position;
        }

        boolean hasError() {
            return this.errorMessage != null;
        }
    }

    public static interface CommentRecorder {
        public void recordComment(Comment.Type var1, SourceRange var2, String var3);
    }
}

