/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.io.Serializable;

public final class JSTypeExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final JSTypeExpression IMPLICIT_TEMPLATE_BOUND = new JSTypeExpression(new Node(Token.QMARK), "");
    private final Node root;
    private final String sourceName;

    public JSTypeExpression(Node root, String sourceName) {
        this.root = root;
        this.sourceName = sourceName;
    }

    public static JSTypeExpression makeOptionalArg(JSTypeExpression expr) {
        if (expr.isOptionalArg() || expr.isVarArgs()) {
            return expr;
        }
        Node equals = new Node(Token.EQUALS, expr.root);
        equals.clonePropsFrom(expr.root);
        return new JSTypeExpression(equals, expr.sourceName);
    }

    public boolean isOptionalArg() {
        return this.root.getToken() == Token.EQUALS;
    }

    public boolean isVarArgs() {
        return this.root.getToken() == Token.ITER_REST;
    }

    public JSType evaluate(StaticTypedScope scope, JSTypeRegistry registry) {
        JSType type = registry.createTypeFromCommentNode(this.root, this.sourceName, scope);
        this.root.setJSType(type);
        return type;
    }

    public boolean equals(Object other) {
        return other instanceof JSTypeExpression && ((JSTypeExpression)other).root.isEquivalentTo(this.root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public Node getRoot() {
        return this.root;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        return "type: " + this.root.toStringTree();
    }

    public JSTypeExpression copy() {
        return new JSTypeExpression(this.root.cloneTree(), this.sourceName);
    }

    public boolean isExplicitUnknownTemplateBound() {
        return this != IMPLICIT_TEMPLATE_BOUND && this.equals(IMPLICIT_TEMPLATE_BOUND);
    }

    static {
        IMPLICIT_TEMPLATE_BOUND.getRoot().setStaticSourceFile(new SimpleSourceFile("<IMPLICT_TEMPLATE_BOUND>", StaticSourceFile.SourceKind.STRONG));
    }
}

