/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeIterations;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class UnionType
extends JSType {
    private static final long serialVersionUID = 2L;
    private static final int DEFAULT_MAX_UNION_SIZE = 30;
    private static final int PROPERTY_CHECKING_MAX_UNION_SIZE = 3000;
    private ImmutableList<JSType> alternates;

    private UnionType(JSTypeRegistry registry) {
        super(registry);
    }

    public static Builder builder(JSTypeRegistry registry) {
        return new Builder(registry, 30);
    }

    static Builder builderForPropertyChecking(JSTypeRegistry registry) {
        return new Builder(registry, 3000);
    }

    public ImmutableList<JSType> getAlternates() {
        if (!this.isResolved() && JSTypeIterations.anyTypeMatches(JSType::isUnionType, this.alternates)) {
            this.rebuildAlternates();
        }
        return this.alternates;
    }

    private void rebuildAlternates() {
        this.setAlternates(new Builder(this, 30).addAlternates((List<? extends JSType>)this.alternates).buildInternal());
    }

    private UnionType setAlternates(ImmutableList<JSType> alternates) {
        Preconditions.checkState(!alternates.isEmpty());
        this.alternates = alternates;
        return this;
    }

    @Override
    public boolean matchesNumberContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesNumberContext, this);
    }

    @Override
    public boolean matchesStringContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesStringContext, this);
    }

    @Override
    public boolean matchesSymbolContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesSymbolContext, this);
    }

    @Override
    public boolean matchesObjectContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesObjectContext, this);
    }

    @Override
    protected JSType findPropertyTypeWithoutConsideringTemplateTypes(String propertyName) {
        JSType propertyType = null;
        for (JSType alternate : this.alternates) {
            JSType altPropertyType;
            if (alternate.isNullType() || alternate.isVoidType() || (altPropertyType = alternate.findPropertyType(propertyName)) == null) continue;
            if (propertyType == null) {
                propertyType = altPropertyType;
                continue;
            }
            propertyType = propertyType.getLeastSupertype(altPropertyType);
        }
        return propertyType;
    }

    @Override
    public boolean canBeCalled() {
        return JSTypeIterations.allTypesMatch(JSType::canBeCalled, this);
    }

    @Override
    public JSType autobox() {
        return JSTypeIterations.mapTypes(JSType::autobox, this);
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        return JSTypeIterations.mapTypes(JSType::restrictByNotNullOrUndefined, this);
    }

    @Override
    public JSType restrictByNotUndefined() {
        return JSTypeIterations.mapTypes(JSType::restrictByNotUndefined, this);
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = null;
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType t = (JSType)this.alternates.get(i);
            TernaryValue test = t.testForEquality(that);
            if (result == null) {
                result = test;
                continue;
            }
            if (result.equals((Object)test)) continue;
            return TernaryValue.UNKNOWN;
        }
        return result;
    }

    @Override
    public boolean isNullable() {
        return JSTypeIterations.anyTypeMatches(JSType::isNullable, this);
    }

    @Override
    public boolean isVoidable() {
        return JSTypeIterations.anyTypeMatches(JSType::isVoidable, this);
    }

    @Override
    public boolean isExplicitlyVoidable() {
        return JSTypeIterations.anyTypeMatches(JSType::isExplicitlyVoidable, this);
    }

    @Override
    public boolean isUnknownType() {
        return JSTypeIterations.anyTypeMatches(JSType::isUnknownType, this);
    }

    @Override
    public boolean isStruct() {
        return JSTypeIterations.anyTypeMatches(JSType::isStruct, this);
    }

    @Override
    public boolean isDict() {
        return JSTypeIterations.anyTypeMatches(JSType::isDict, this);
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        if (!that.isUnknownType() && !that.isUnionType()) {
            for (int i = 0; i < this.alternates.size(); ++i) {
                JSType alternate = (JSType)this.alternates.get(i);
                if (alternate.isUnknownType() || !that.isSubtypeOf(alternate)) continue;
                return this;
            }
        }
        return JSType.getLeastSupertype(this, that);
    }

    static JSType getGreatestSubtype(UnionType union, JSType that) {
        JSType result;
        JSTypeRegistry registry = union.registry;
        Builder builder = UnionType.builder(registry);
        for (int i = 0; i < union.alternates.size(); ++i) {
            JSType alternate = (JSType)union.alternates.get(i);
            if (!alternate.isSubtypeOf(that)) continue;
            builder.addAlternate(alternate);
        }
        if (that.isUnionType()) {
            ImmutableList<JSType> thoseAlternates = that.toMaybeUnionType().getAlternates();
            for (int i = 0; i < thoseAlternates.size(); ++i) {
                JSType otherAlternate = (JSType)thoseAlternates.get(i);
                if (!otherAlternate.isSubtypeOf(union)) continue;
                builder.addAlternate(otherAlternate);
            }
        } else if (that.isSubtypeOf(union)) {
            builder.addAlternate(that);
        }
        if (!(result = builder.build()).isNoType()) {
            return result;
        }
        if (union.isObject() && that.isObject() && !that.isNoType()) {
            return registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    boolean checkUnionEquivalenceHelper(UnionType that, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        ImmutableList<JSType> thatAlternates = that.getAlternates();
        if (eqMethod == EquivalenceMethod.IDENTITY && this.alternates.size() != thatAlternates.size()) {
            return false;
        }
        for (int i = 0; i < thatAlternates.size(); ++i) {
            JSType thatAlternate = (JSType)thatAlternates.get(i);
            if (this.hasAlternate(thatAlternate, eqMethod, eqCache)) continue;
            return false;
        }
        return true;
    }

    private boolean hasAlternate(JSType type, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType alternate = (JSType)this.alternates.get(i);
            if (!alternate.checkEquivalenceHelper(type, eqMethod, eqCache)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType.HasPropertyKind getPropertyKind(String pname, boolean autobox) {
        boolean found = false;
        boolean always = true;
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType alternate = (JSType)this.alternates.get(i);
            if (alternate.isNullType() || alternate.isVoidType()) continue;
            switch (alternate.getPropertyKind(pname, autobox)) {
                case KNOWN_PRESENT: {
                    found = true;
                    break;
                }
                case ABSENT: {
                    always = false;
                    break;
                }
                case MAYBE_PRESENT: {
                    found = true;
                    always = false;
                }
            }
            if (found && !always) break;
        }
        return found ? (always ? JSType.HasPropertyKind.KNOWN_PRESENT : JSType.HasPropertyKind.MAYBE_PRESENT) : JSType.HasPropertyKind.ABSENT;
    }

    @Override
    final int recursionUnsafeHashCode() {
        int hashCode = this.alternates.size();
        for (int i = 0; i < this.alternates.size(); ++i) {
            hashCode *= ((JSType)this.alternates.get(i)).hashCode();
        }
        return hashCode;
    }

    @Override
    public UnionType toMaybeUnionType() {
        return this;
    }

    @Override
    public boolean isObject() {
        return JSTypeIterations.allTypesMatch(JSType::isObject, this);
    }

    public boolean contains(JSType type) {
        return JSTypeIterations.anyTypeMatches(type::isEquivalentTo, this);
    }

    public JSType getRestrictedUnion(JSType type) {
        Builder restricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType t = (JSType)this.alternates.get(i);
            if (!t.isUnknownType() && !t.isNoResolvedType() && t.isSubtypeOf(type)) continue;
            restricted.addAlternate(t);
        }
        return restricted.build();
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        sb.append("(");
        TreeSet<String> sortedTypeNames = new TreeSet<String>();
        for (JSType jsType : this.alternates) {
            sortedTypeNames.add(jsType.appendTo(new StringBuilder(), forAnnotations).toString());
        }
        Joiner.on('|').appendTo(sb, (Iterable<?>)sortedTypeNames);
        return sb.append(")");
    }

    @Override
    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean outcome) {
        return JSTypeIterations.mapTypes(t -> t.getRestrictedTypeGivenToBooleanOutcome(outcome), this);
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        JSType element;
        BooleanLiteralSet literals = BooleanLiteralSet.EMPTY;
        for (int i = 0; i < this.alternates.size() && (literals = literals.union((element = (JSType)this.alternates.get(i)).getPossibleToBooleanOutcomes())) != BooleanLiteralSet.BOTH; ++i) {
        }
        return literals;
    }

    @Override
    public JSType.TypePair getTypesUnderEquality(JSType that) {
        Builder thisRestricted = UnionType.builder(this.registry);
        Builder thatRestricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType element = (JSType)this.alternates.get(i);
            JSType.TypePair p = element.getTypesUnderEquality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderInequality(JSType that) {
        Builder thisRestricted = UnionType.builder(this.registry);
        Builder thatRestricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType element = (JSType)this.alternates.get(i);
            JSType.TypePair p = element.getTypesUnderInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderShallowInequality(JSType that) {
        Builder thisRestricted = UnionType.builder(this.registry);
        Builder thatRestricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType element = (JSType)this.alternates.get(i);
            JSType.TypePair p = element.getTypesUnderShallowInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseUnionType(this, that);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.setResolvedTypeInternal(this);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType alternate = (JSType)this.alternates.get(i);
            alternate.resolve(reporter);
        }
        this.rebuildAlternates();
        if (this.alternates.size() == 1) {
            return (JSType)this.alternates.get(0);
        }
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        ArrayList<String> hashCodes = new ArrayList<String>();
        for (JSType a : this.alternates) {
            hashCodes.add(a.toDebugHashCodeString());
        }
        return "{(" + Joiner.on(",").join(hashCodes) + ")}";
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType a = (JSType)this.alternates.get(i);
            a.setValidator(validator);
        }
        return true;
    }

    @Override
    public JSType collapseUnion() {
        JSType currentValue = null;
        ObjectType currentCommonSuper = null;
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType a = (JSType)this.alternates.get(i);
            if (a.isUnknownType()) {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            ObjectType obj = a.toObjectType();
            if (obj == null) {
                if (currentValue == null && currentCommonSuper == null) {
                    currentValue = a;
                    continue;
                }
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (currentValue != null) {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            currentCommonSuper = currentCommonSuper == null ? obj : this.registry.findCommonSuperObject(currentCommonSuper, obj);
        }
        return currentCommonSuper;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType alternate = (JSType)this.alternates.get(i);
            alternate.matchConstraint(constraint);
        }
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return JSTypeIterations.anyTypeMatches(JSType::hasAnyTemplateTypes, this);
    }

    public static final class Builder {
        private final UnionType rebuildTarget;
        private final JSTypeRegistry registry;
        private final int maxUnionSize;
        private final List<JSType> alternates = new ArrayList<JSType>();
        private boolean containsVoidType = false;
        private boolean isAllType = false;
        private boolean isNativeUnknownType = false;
        private boolean areAllUnknownsChecked = true;
        private int functionTypePosition = -1;
        private boolean hasBuilt = false;

        private Builder(JSTypeRegistry registry, int maxUnionSize) {
            this.rebuildTarget = null;
            this.registry = registry;
            this.maxUnionSize = maxUnionSize;
        }

        private Builder(UnionType rebuildTarget, int maxUnionSize) {
            this.rebuildTarget = rebuildTarget;
            this.registry = rebuildTarget.registry;
            this.maxUnionSize = maxUnionSize;
        }

        private static boolean isSubtype(JSType rightType, JSType leftType) {
            return rightType.isSubtypeWithoutStructuralTyping(leftType);
        }

        public Builder addAlternates(Collection<? extends JSType> c) {
            for (JSType jSType : c) {
                this.addAlternate(jSType);
            }
            return this;
        }

        public Builder addAlternates(List<? extends JSType> list) {
            for (int i = 0; i < list.size(); ++i) {
                this.addAlternate(list.get(i));
            }
            return this;
        }

        public Builder addAlternate(JSType alternate) {
            this.checkHasNotBuilt();
            if (alternate.isNoType()) {
                return this;
            }
            this.isAllType = this.isAllType || alternate.isAllType();
            this.containsVoidType = this.containsVoidType || alternate.isVoidType();
            boolean isAlternateUnknown = alternate instanceof UnknownType;
            boolean bl = this.isNativeUnknownType = this.isNativeUnknownType || isAlternateUnknown;
            if (isAlternateUnknown) {
                boolean bl2 = this.areAllUnknownsChecked = this.areAllUnknownsChecked && alternate.isCheckedUnknownType();
            }
            if (this.isAllType || this.isNativeUnknownType) {
                return this;
            }
            if (alternate.isUnionType()) {
                this.addAlternates((List<? extends JSType>)alternate.toMaybeUnionType().getAlternates());
                return this;
            }
            if (this.alternates.size() > this.maxUnionSize) {
                return this;
            }
            if (alternate.isFunctionType() && this.functionTypePosition != -1) {
                FunctionType other = this.alternates.get(this.functionTypePosition).toMaybeFunctionType();
                FunctionType supremum = alternate.toMaybeFunctionType().supAndInfHelper(other, true);
                this.alternates.set(this.functionTypePosition, supremum);
                return this;
            }
            for (int index = 0; index < this.alternates.size(); ++index) {
                boolean removeCurrent = false;
                JSType current = this.alternates.get(index);
                if (alternate.isUnknownType() || current.isUnknownType() || alternate.isNoResolvedType() || current.isNoResolvedType() || alternate.hasAnyTemplateTypes() || current.hasAnyTemplateTypes()) {
                    if (alternate.isEquivalentTo(current, false)) {
                        return this;
                    }
                } else if (alternate.isTemplatizedType() || current.isTemplatizedType()) {
                    if (!current.isTemplatizedType()) {
                        if (Builder.isSubtype(alternate, current)) {
                            return this;
                        }
                    } else if (!alternate.isTemplatizedType()) {
                        if (Builder.isSubtype(current, alternate)) {
                            removeCurrent = true;
                        }
                    } else {
                        Preconditions.checkState(current.isTemplatizedType() && alternate.isTemplatizedType());
                        TemplatizedType templatizedAlternate = alternate.toMaybeTemplatizedType();
                        TemplatizedType templatizedCurrent = current.toMaybeTemplatizedType();
                        if (templatizedCurrent.wrapsSameRawType(templatizedAlternate)) {
                            if (alternate.getTemplateTypeMap().checkEquivalenceHelper(current.getTemplateTypeMap(), EquivalenceMethod.IDENTITY, JSType.SubtypingMode.NORMAL)) {
                                return this;
                            }
                            ObjectType rawType = templatizedCurrent.getReferencedObjTypeInternal();
                            alternate = this.registry.createTemplatizedType(rawType, ImmutableList.of());
                            removeCurrent = true;
                        }
                    }
                } else {
                    if (Builder.isSubtype(alternate, current)) {
                        this.mayRegisterDroppedProperties(alternate, current);
                        return this;
                    }
                    if (Builder.isSubtype(current, alternate)) {
                        this.mayRegisterDroppedProperties(current, alternate);
                        removeCurrent = true;
                    }
                }
                if (!removeCurrent) continue;
                this.alternates.remove(index);
                if (index == this.functionTypePosition) {
                    this.functionTypePosition = -1;
                } else if (index < this.functionTypePosition) {
                    --this.functionTypePosition;
                }
                --index;
            }
            if (alternate.isFunctionType()) {
                Preconditions.checkState(this.functionTypePosition == -1);
                this.functionTypePosition = this.alternates.size();
            }
            this.alternates.add(alternate);
            return this;
        }

        private void mayRegisterDroppedProperties(JSType subtype, JSType supertype) {
            if (subtype.toMaybeRecordType() != null && supertype.toMaybeRecordType() != null) {
                this.registry.registerDroppedPropertiesInUnion(subtype.toMaybeRecordType(), supertype.toMaybeRecordType());
            }
        }

        public JSType build() {
            Preconditions.checkState(this.rebuildTarget == null);
            ImmutableList<JSType> alternates = this.buildInternal();
            if (alternates.size() == 1) {
                return (JSType)alternates.get(0);
            }
            return new UnionType(this.registry).setAlternates(alternates);
        }

        private ImmutableList<JSType> buildInternal() {
            this.checkHasNotBuilt();
            this.hasBuilt = true;
            JSType wildcard = this.getNativeWildcardType();
            if (wildcard != null) {
                if (this.containsVoidType) {
                    return ImmutableList.of(wildcard, this.registry.getNativeType(JSTypeNative.VOID_TYPE));
                }
                return ImmutableList.of(wildcard);
            }
            if (this.alternates.isEmpty()) {
                return ImmutableList.of(this.registry.getNativeType(JSTypeNative.NO_TYPE));
            }
            if (this.alternates.size() > this.maxUnionSize) {
                return ImmutableList.of(this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            }
            return ImmutableList.copyOf(this.alternates);
        }

        @Nullable
        private JSType getNativeWildcardType() {
            if (this.isAllType) {
                return this.registry.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (this.isNativeUnknownType) {
                if (this.areAllUnknownsChecked) {
                    return this.registry.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
                }
                return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return null;
        }

        private void checkHasNotBuilt() {
            Preconditions.checkState(!this.hasBuilt, "Cannot reuse a `UnionType.Builder` that has already filled.");
        }
    }
}

