/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    installer.valueChanged.connect(this, Component.prototype.reactOnTargetDirChange);

    // set the default values to QtConanBinary
    Component.prototype.reactOnTargetDirChange("TargetDir", installer.value("TargetDir"));
}

var Dir = new function ()
{
    this.toNativeSeparator = function (path)
    {
        path = path.replace(/\/\//g, '/');
        if (systemInfo.productType === "windows")
            return path.replace(/\//g, '\\');
        return path;
    }
};

Component.prototype.reactOnTargetDirChange = function(key, value)
{
    var dir = Dir.toNativeSeparator(installer.value("TargetDir"));

    var conanBinary = "";

    if (key == "TargetDir") {
        if (installer.value("os") == "win") {
            conanBinary = Dir.toNativeSeparator(value + "//Tools/Conan//conan.exe");
        } else if (installer.value("os") == "mac") {
            conanBinary = Dir.toNativeSeparator(value + "//Tools/Conan//conan");
        } else {
            conanBinary = Dir.toNativeSeparator(value + "//Tools/Conan//conan");
        }

        installer.setValue("QtConanBinary", conanBinary);
        console.log("Using 'QtConanBinary': " + installer.value("QtConanBinary"));
    }
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    var sdkTool = installer.value("SDKToolBinary");
    var settingsFile = installer.value("QtCreatorInstallerSettingsFile");

    if (!sdkTool || !settingsFile) {
        console.log("Unable to register conan tool for Qt Creator. Is Qt Creator installed correctly?");
        return;
    }

    // register conan(.exe) tool for QtCreator integration
    component.addOperation("Settings",
        "path=" + settingsFile,
        "method=set",
        "key=ConanSettings/ConanFilePath",
        "value=" + installer.value("QtConanBinary"));
}

