/*
 * in6_debug.c  --  Insipired by Craig Metz's Net/2 in6_debug.c, but
 *                  not quite as heavyweight (initially, anyway).
 *
 * The idea is to have globals here, and dump netinet6/ data structures.
 *
 * Copyright 1995 by Dan McDonald, Bao Phan, and Randall Atkinson,
 *	All Rights Reserved.  
 *      All Rights under this copyright have been assigned to NRL.
 */

/*----------------------------------------------------------------------
#       @(#)COPYRIGHT   1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

        This product includes software developed at the Information
        Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/


#define _IN6_DEBUG_C

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#ifdef KERNEL
#include <sys/mbuf.h>
#include <sys/systm.h>
#endif /* KERNEL */

#include <net/route.h>
#include <net/if.h>

#include <netinet/in.h>

#include <netinet6/in6.h>
#include <netinet6/ipv6.h>
#include <netinet6/ipv6_icmp.h>
#include <netinet6/in6_debug.h>

#include <netkey/osdep_44bsd.h>

#ifndef DEFARGS
#define DEFARGS(arglist, args) arglist args;
#define AND ;
#endif /* DEFARGS */

/*
 * Globals
 */

/* The following should be sysctl-tweakable. */

unsigned int in6_debug_level = IDL_ERROR;  /* 0 is no debugging */

/*----------------------------------------------------------------------
 * Dump an IPv6 address.  Don't compress 0's out because of debugging.
 ----------------------------------------------------------------------*/
void dump_in6_addr DEFARGS((in6_addr),
     struct in6_addr *in6_addr)
{
  u_short *shorts = (u_short *)in6_addr;
  int i = 0;

  if (!in6_addr) {
    printf("Dereference a NULL in6_addr? I don't think so.\n");
    return;
  }

  printf("(conv. for printing) ");
  while (i < 7)
    printf("%4x:",htons(shorts[i++]));
  printf("%4x\n",htons(shorts[7]));
}

/*----------------------------------------------------------------------
 * Dump an IPv6 socket address.
 ----------------------------------------------------------------------*/
void dump_sockaddr_in6 DEFARGS((sin6),
     struct sockaddr_in6 *sin6)
{
  if (!sin6) {
    printf("Dereference a NULL sockaddr_in6? I don't think so.\n");
    return;
  }

  printf("sin6_len = %d, sin6_family = %d, sin6_port = %d (0x%x)\n",
	 sin6->sin6_len,sin6->sin6_family, htons(sin6->sin6_port),
	 htons(sin6->sin6_port));
  printf("sin6_flowinfo = 0x%x\n", (unsigned int)sin6->sin6_flowinfo);
  printf("sin6_addr = ");
  dump_in6_addr(&sin6->sin6_addr);
}

#ifdef KERNEL
/*----------------------------------------------------------------------
 * Dump an IPv6 header.
 ----------------------------------------------------------------------*/
void dump_ipv6 DEFARGS((ipv6),
     struct ipv6 *ipv6)
{
  if (!ipv6) {
	printf("Dereference a NULL ipv6? I don't think so.\n");
        return;
  }

  printf("Vers & flow label (conv to host order) 0x%x\n",
	 (unsigned int)htonl(ipv6->ipv6_versfl));
  printf("Length (conv) = %d, nexthdr = %d, hoplimit = %d.\n",
	 htons(ipv6->ipv6_length),ipv6->ipv6_nexthdr,ipv6->ipv6_hoplimit);
  printf("Src: ");
  dump_in6_addr(&ipv6->ipv6_src);
  printf("Dst: ");
  dump_in6_addr(&ipv6->ipv6_dst);
}

/*----------------------------------------------------------------------
 * Dump an ICMPv6 header.  This function is not very smart beyond the
 * type, code, and checksum.
 ----------------------------------------------------------------------*/
void
dump_ipv6_icmp DEFARGS((icp),
     struct ipv6_icmp *icp)
{
  if (!icp) {
	printf("Dereference a NULL ipv6_icmp? I don't think so.\n");
        return;
  }

  printf("type %d, code %d, cksum (conv) = 0x%x\n",icp->icmp_type,
	 icp->icmp_code,htons(icp->icmp_cksum));
  printf("First four bytes: 0x%x", (unsigned int)htonl(icp->icmp_unused));
  printf("Next four bytes: 0x");
  dump_buf((void *)icp->icmp_echodata, 4);
  printf("\n");
}

/*----------------------------------------------------------------------
 * Dump an IPv6 header index table, which is terminated by an entry with
 * a NULL mbuf pointer.
 ----------------------------------------------------------------------*/
void dump_ihitab DEFARGS((ihi),
     struct in6_hdrindex *ihi)
{
  int i=0;

  if (!ihi) {
    printf("Dereference a NULL hdrindex/ihi? I don't think so.\n");
    return;
  }

  /* This is dangerous, make sure ihitab was bzeroed. */
  while (ihi[i].ihi_mbuf)
    {
      printf("ihi_nexthdr = %d, ihi_mbuf = 0x%lx.\n",ihi[i].ihi_nexthdr,
	     (unsigned long)ihi[i].ihi_mbuf);
      i++;
    }
}

/*----------------------------------------------------------------------
 * Dump an IPv6 discovery queue structure.
 ----------------------------------------------------------------------*/
void dump_discq DEFARGS((dq),
     struct discq *dq)
{
  if (!dq) {
    printf("Dereference a NULL discq? I don't think so.\n");
    return;
  }

  printf("dq_next = 0x%lx, dq_prev = 0x%lx, dq_rt = 0x%lx,\n", (unsigned long)dq->dq_next,
	 (unsigned long)dq->dq_prev, (unsigned long)dq->dq_rt);
  printf("dq_queue = 0x%lx.\n", (unsigned long)dq->dq_queue);
  /* Dump first mbuf chain? */
  /*printf("dq_expire = %d (0x%x).\n",dq->dq_expire,dq->dq_expire);*/
}
#endif /* KERNEL */
