###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


#### cairo

pkg_search_module( CAIRO cairo )

if( NOT CAIRO_FOUND )
    tde_message_fatal( "cairo is required but was not found on your system" )
endif( )


#### gtk+-3.0

pkg_search_module( GTK3 gtk+-3.0 )

if( NOT GTK3_FOUND )
    tde_message_fatal( "gtk3 is required but was not found on your system" )
endif( )

execute_process(
  COMMAND ${PKG_CONFIG_EXECUTABLE}
    gtk+-3.0 --variable=gtk_binary_version
  OUTPUT_VARIABLE GTK3_BIN_VERSION
  OUTPUT_STRIP_TRAILING_WHITESPACE
)


#### pango

pkg_search_module( PANGO pango )

if( NOT PANGO_FOUND )
    tde_message_fatal( "pango is required but was not found on your system" )
endif( )
