/***************************************************************************
                         documentitem.h  -  description
                             -------------------
    begin                : Do Sep 2 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/

#ifndef DOCUMENTITEM_H
#define DOCUMENTITEM_H

#include <xmlutils.h>
#include <tqobject.h>
#include <tqsortedlist.h> 
#include <tqstring.h>
#include <tqtextstream.h>

#include <tqcolor.h>
#include <tqpen.h>

#include "zplutils.h"

enum ERtti {
    eRtti_Barcode,
    eRtti_Image,
    eRtti_Line,
    eRtti_Rect,
    eRtti_Text,
    //NY33
    eRtti_TextLine
    //NY33
};

class TQDomElement;
class TQPainter;
class TQPaintDevice;
class TQTextStream;
class TCanvasItem;
class TokenProvider;

/**
 * Class DocumentItem
 * Every object which can be placed on a document has to be a subclass of this class.
 */
class DocumentItem : public TQObject, protected XMLUtils {
public:
    DocumentItem ( );
    virtual ~DocumentItem() { };
    
    /**
     * 
     * @param element 
     */
    virtual void loadXML (TQDomElement* element);
        
    
    /**
     * save this item to XML
     */
    virtual void saveXML (TQDomElement* element);
        
    
    /**
     * Draws the item
     */
    virtual void  draw (TQPainter* painter) = 0;
        
    
    /**
     * Draw a border around the item, has to be reimplemented for round items or barcodes which do not allow borders.
     */
    virtual void drawBorder (TQPainter* painter);
        
    virtual int  rtti () const = 0;

    /** 
     * Write a ZPL string for drawing this item onto a zebra printer to a TQTextStream
     */
    virtual void drawZpl( TQTextStream* stream ) = 0;

    /** 
     * Write a IPL string for drawing this item onto a zebra printer to a TQTextStream
     */
    virtual void drawIpl( TQTextStream* stream, IPLUtils* utils ) = 0;
        
    /** 
     * Write a EPCL string for drawing this item onto a zebra printer to a TQTextStream
     */
    virtual void drawEPcl( TQTextStream* stream ) = 0;
    
    void setCanvasItem( TCanvasItem* item );
    TCanvasItem* canvasItem() const;
    
    void setPaintDevice( TQPaintDevice* device );
    TQPaintDevice* paintDevice() const;
    
    void setTokenProvider( TokenProvider* token );
    TokenProvider* tokenProvider() const;
    
    /**
     * 
     * @param b 
     */
    void  setBorder (bool b);
    bool  border ()  const;
        
    void setPen( const TQPen& pen );
    TQPen pen() const;

    /** move the documentitem using pixel coordinates on the current 
      * paint device
      */
    void move( int x, int y );
    /** move the documentitem using 1/1000th of a millimeter coordinates 
      */
    void moveMM( int x, int y );

    /** set the width and height of this item using pixel coordinates
      * of the current paint device
      */
    void setSize( int w, int h );
    /** set the width and height of this item using 1/1000th of a
      * millimeter coordinates
      */
    void setSizeMM( int w, int h );
    
    /** The bounding rectangle. I.e. the rectangle including
      * the border width 
      */
    void setBoundingRect( const TQRect & rect );
    /** The bounding rectangle. I.e. the rectangle including
      * the border width 
      */
    TQRect boundingRect() const;

    /** The drawing rectangle. I.e. the rectangle with the
      * border width substracted
      */
    void setRect( const TQRect & rect );
    /** The drawing rectangle. I.e. the rectangle with the
      * border width substracted
      */
    TQRect rect() const;

    /** the bounding rectangle including the border in 1/1000mm
      */
    void setRectMM( const TQRect & rect );
    /** the bounding rectangle including the border in 1/1000mm
      */
    TQRect rectMM() const;
    
    /** set the item to be locked in the label editor
      * i.e protect it from being move or resized by the user
      */
    void setLocked( bool locked );
    const bool locked() const;

    /** set a javascript script for this item which is evaluate 
     *  to determine wether this item should be printed (only in Label
     *  as items are always shown in the labeleditor.
     *  The script shall return true if the item should be visible.
     *  If script returns false the item will not be printed.
     */
    inline void setVisibilityScript( const TQString & script );
    inline const TQString visibilityScript() const;
    
    int z() const;
    void setZ( int z );

    /** Only the z index is compared
      */
    bool operator<( const DocumentItem & docitem )
    {
        return m_z < docitem.m_z;
    }
    
    /** Only the z index is compared
      */
    bool operator==( const DocumentItem & docitem )
    {
        return m_z == docitem.m_z;
    }
private:
    void init();
            
private:
    /**
     * Defines wether this item has a border or not
     */
     bool m_border;
     TQPen m_pen;
     TQRect m_rect;
     int m_z;
     bool m_locked;

    /**
     * Background color of this document item
     */
     TQColor m_background;

     TQString m_visibilityScript;

     TQPaintDevice* m_device;     
     TCanvasItem* m_canvasitem;
     TokenProvider* m_token;
};

void DocumentItem::setVisibilityScript( const TQString & script )
{
    m_visibilityScript = script;
}

const TQString DocumentItem::visibilityScript() const
{
    return m_visibilityScript;
}

typedef TQSortedList<DocumentItem> DocumentItemList;

#endif //DOCUMENTITEM_H

