/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_TOOL_TIP
#define KBFX_TOOL_TIP

#include <tqcursor.h>
#include <tqimage.h>
#include <tqlabel.h>
#include <tqmovie.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqtimer.h>
#include <tqwidget.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <kicontheme.h>
#include <kstandarddirs.h>
#include <ktip.h>
#include <kuser.h>

#include <kbfxconfig.h>

#include <kbfxplasmapixmapprovider.h>

class KbfxToolTip:public TQWidget
{

		Q_OBJECT
  
	public:
		KbfxToolTip ( TQWidget * parent=0,const char * name=0,WFlags fl=WType_TopLevel );
		~KbfxToolTip();
		void setStartPos ( int x=0, int y=0 );
		virtual void paintEvent ( TQPaintEvent *pe );
		void setBackground ( TQPixmap bg );
		void setAnimationImage ( TQString path );
		void setWindow ( TQPixmap win );

	public slots:
		void hideToolTip();
		void logoMove();
		void setUserImage();
		void setBoundBox();
		void setAnimated ( bool  );
		void setLabelText ( TQString  );
		void setHeadingText ( TQString  );
		void setVersionText ( TQString  );

	private:
		TQTimer * _hide_timer;
		TQTimer * _move_timer;
		TQTimer * _update_timer;
		int _x,_y;
		int _maxW;
		int _width;
		int _height;
		int _logo_move_x;
		TQPixmap _dude;
		TQPixmap _dude_box;
		TQImage _bg;
		TQLabel * _window;
		TQLabel * _agent;
		TQMovie * _agent_anim;
		bool _animate;
		TQString _label_text;
		TQString _heading_text;
		TQString _version_text;
		TQFont m_fontTooltipFont;
		TQImage logo;
		TQImage tooltip_win;
		TQImage tooltip_mask;
		TQImage dude_img;
};
#endif
