/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXDOCUMENTLISTVIEW_H
#define KBIBTEXDOCUMENTLISTVIEW_H

#include <tdelistview.h>
#include <kxmlguifactory.h>

#include "fileimporter.h"
#include "settings.h"
#include "file.h"

class TQString;
class KURL;
class TDEActionMenu;
class TDEPopupMenu;

namespace KBibTeX
{
    class DocumentWidget;
    class DocumentListViewItem;

    class DocumentListView : public TDEListView
    {
        Q_OBJECT
    public:
        DocumentListView( KBibTeX::DocumentWidget *docWidget, bool isReadOnly, TQWidget *parent = 0, const char *name = 0 );
        ~DocumentListView();

        void setFactory( KXMLGUIFactory *factory, KXMLGUIClient *client );
        void setViewShowColumnsMenu( TDEActionMenu *actionMenu );

        bool setBibTeXFile( BibTeX::File *bibtexFile );
        BibTeX::File* getBibTeXFile( );
        KBibTeX::DocumentListViewItem *insertItem( BibTeX::Element *item, KBibTeX::DocumentListViewItem *after );

        void deleteSelected();
        const TQValueList<BibTeX::Element*> selectedItems();
//         void sendSelectedToLyx();

        void updateVisiblity();
        void updateVisiblity( KBibTeX::DocumentListViewItem *item );

        void deferredInitialization();
        void restoreState();

    signals:
        void modified();
        void executed( DocumentListViewItem* );

    public slots:
        void copy();
        void copyReferences();
        void cut();
        bool paste();
        bool paste( const TQString& text, DocumentListViewItem *at );
        void selectAll();
        void filter( const TQString& text, BibTeX::Element::FilterType filterType, BibTeX::EntryField::FieldType fieldType );
        void setReadOnly( bool isReadOnly );
        void activateShowColumnMenu( int id );

        void insertItems( BibTeX::File *items, KBibTeX::DocumentListViewItem *after = NULL );
        void insertItem( BibTeX::Element *item );

    private slots:
        void slotDoubleClick( TQListViewItem * item = NULL );
        void setSortingColumn( int column );
        void showBibtexListContextMenu( TDEListView *, TQListViewItem *, const TQPoint &p );
        void slotDropped( TQDropEvent* event, TQListViewItem* item );
        void saveColumnIndex();
        void restoreColumnIndex();
        void saveColumnWidths( int col = -1 );
        void restoreColumnWidths();
        void restoreSortingColumn();
        void makeNewItemsUnread();

    protected:
        bool acceptDrag( TQDropEvent* e ) const;
        void startDrag();

        virtual bool eventFilter( TQObject *watched, TQEvent *e );

        virtual void keyPressEvent( TQKeyEvent *e );

    private:
        static const int maxColumns = 256;
        KBibTeX::DocumentWidget *m_docWidget;
        BibTeX::File *m_bibtexFile;
        TDEPopupMenu *m_contextMenu;
        TDEPopupMenu *m_headerMenu;
        TDEActionMenu *m_columnVisibleAction;
        bool m_isReadOnly;
        TQValueList<DocumentListViewItem*> m_unreadItems;

        TQString m_filter;
        BibTeX::Element::FilterType m_filterType;
        BibTeX::EntryField::FieldType m_filterFieldType;
        int m_newElementCounter;

        void setItems();
        TQString selectedToBibTeXText();
        TQString selectedToBibTeXRefs();

        void showColumn( int col, int colWidth = 0xffff );
        void hideColumn( int col );
        void buildColumns();
    };
}

#endif
