/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXSIDEBAR_H
#define KBIBTEXSIDEBAR_H

#include <tqwidget.h>
#include <tqlistview.h>

#include "entryfield.h"
#include "file.h"

class TQComboBox;
class TQToolButton;
class TDEListView;
class TQListViewItem;
class TDEPopupMenu;

namespace KBibTeX
{
    class SideBar : public TQWidget
    {
        Q_OBJECT
    public:
        SideBar( bool isReadOnly, TQWidget *parent = 0, const char *name = 0 );
        ~SideBar();

        void restoreState();
        void setReadOnly( bool isReadOnly );

    signals:
        void selected( const TQString& text, BibTeX::Element::FilterType, BibTeX::EntryField::FieldType fieldType );
        void valueRenamed();

    public slots:
        void refreshLists( BibTeX::File *bibtexFile = NULL );

    protected:
        void resizeEvent( TQResizeEvent *event );

    private:
        BibTeX::File *m_bibtexFile;
        TQToolButton *m_buttonToggleShowAll;
        TQToolButton *m_buttonToggleMultiSelect;
        TQComboBox *m_listTypeList;
        TDEListView *m_listAvailableItems;
        static const BibTeX::EntryField::FieldType importantFields[ 6 ];
        bool m_isReadOnly;
        TDEPopupMenu *m_popupMenu;
        TQString m_oldText;

        void setupGUI();

    private slots:
        void prepareSearch();
        void toggleShowAll( bool showAll );
        void toggleMultiSelect( bool showAll );
        void showContextMenu( TQListViewItem * item, const TQPoint & pos );
        void startRenaming();
        void endRenaming( TQListViewItem * item, int col, const TQString & text );
    };

    class SideBarListViewItem: TQListViewItem
    {
    public:
        SideBarListViewItem( TQListView *parent, TQString label1, TQString label2 );

        int compare( TQListViewItem* item, int column, bool ascending ) const;
    };

}

#endif
