/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXWEBQUERY_H
#define KBIBTEXWEBQUERY_H

#include <tqobject.h>
#include <tqstring.h>

#include <kdialogbase.h>
#include <tdelistview.h>
#include <klineedit.h>
#include <tdeio/jobclasses.h>
#include <kprogress.h>

#include "entry.h"

class TQWidget;
class TQFrame;
class TQCheckBox;
class TQSpinBox;
class KComboBox;
class TDEListView;
class KPushButton;

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryWidget : public TQWidget
    {
        Q_OBJECT
    public:
        WebQueryWidget( TQWidget *parent, const char *name = 0 );
        virtual bool searchPossible();

        KLineEdit *lineEditQuery;
        TQSpinBox *spinBoxMaxHits;

    protected:
        virtual void init();

    signals:
        void enableSearch( bool );
        void startSearch();

    protected slots:
        void slotTextChanged( const TQString& );
        void slotTextChanged( const TQString&, bool delayed );

    private slots:
        void slotEnableSearchTrue();
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQuery : public TQObject
    {
        Q_OBJECT
    public:
        enum Status { statusSuccess, statusError, statusAborted, statusInvalidQuery, statusInsufficientPermissions };

        WebQuery( TQWidget *parent );
        virtual ~WebQuery();

        virtual void query();

        virtual TQString title() { return "no_title"; };
        virtual TQString disclaimer() = 0;
        virtual TQString disclaimerURL() = 0;

        virtual WebQueryWidget *widget() = 0;

    signals:
        void foundEntry( BibTeX::Entry*, bool );
        void endSearch( WebQuery::Status );

    protected:
        bool m_aborted;
        TQWidget *m_parent;
        KProgressDialog *m_progressDialog;

        virtual void cancelQuery();

        void setEndSearch( WebQuery::Status );
        void setNumStages( int numStages );
        void enterNextStage();
        TQString download( const KURL& url );
        TQString downloadHTML( const KURL& url );
        BibTeX::File *downloadBibTeXFile( const KURL& url, TQTextStream::Encoding = TQTextStream::UnicodeUTF8 );

    private:
        int m_currentStage;
        int m_numStages;
        TDEIO::TransferJob *m_currentJob;
        int m_currentJobTotalSize;
        TQString m_incomingData;

    private slots:
        void slotCancelQuery();
        void slotSetJobTotalSize( TDEIO::Job *job, TDEIO::filesize_t size );
        void slotSetJobProcessedSize( TDEIO::Job *job, TDEIO::filesize_t size );
        void slotJobData( TDEIO::Job *job, const TQByteArray &data );
        void slotJobFinished( TDEIO::Job *job );
    };

    class WebQueryWizard: public TQWidget
    {
        Q_OBJECT
    public:
        ~WebQueryWizard();

        static int execute( TQWidget *parent, TQValueList<BibTeX::Entry*> &results );

    signals:
        void changeButtonOK( bool state );

    protected:
        TDEListView *m_listViewResults;
        KComboBox *m_comboBoxEngines;
        TQWidgetStack *m_widgetStackQueries;
        KURLLabel *m_disclaimerLabel;
        TQCheckBox *m_checkBoxImportAll;
        TQValueList<WebQuery*> m_webQueries;
        KDialogBase *m_dlg;

        WebQueryWizard( KDialogBase *dlg, const char* name = 0 );
        void showEvent( TQShowEvent * );

    private slots:
        void previewEntry( TQListViewItem *item );
        void importEnableChanging( );
        void otherEngineSelected( int index );
        void startSearch();
        void endSearch( WebQuery::Status );
        void addHit( BibTeX::Entry*, bool keepId = false );
        void enableSearch( bool );
        void openURL( const TQString& );

    private:
        KPushButton *m_pushButtonSearch;

        void setupGUI( );
        void setupQueries();
        void restoreWindowSize( TDEConfig *config );
        void saveWindowSize( TDEConfig *config ) const;
    };

    class ResultsListViewItem: public TQListViewItem
    {
    public:
        ResultsListViewItem( TQListView * parent, BibTeX::Entry *entry );
        ~ResultsListViewItem();

        BibTeX::Entry* entry();
    private:
        BibTeX::Entry *m_entry;
    };
}

#endif
