/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXENTRYWIDGETOTHER_H
#define KBIBTEXENTRYWIDGETOTHER_H

#include <kurl.h>

#include "entrywidgettab.h"

class TQPushButton;
class TDEListView;
class TQLineEdit;

namespace KBibTeX
{

    class ValueListViewItem;

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class EntryWidgetOther : public EntryWidgetTab
    {
        TQ_OBJECT
    public:
        EntryWidgetOther( BibTeX::File *bibtexfile, bool isReadOnly, TQWidget *parent = 0, const char *name = 0 );
        ~EntryWidgetOther();

        bool isModified();

    public slots:
        void updateGUI( BibTeX::Entry::EntryType /*entryType*/, bool enableAll );
        void apply( BibTeX::Entry *entry );
        void reset( BibTeX::Entry *entry );
        void updateWarnings( BibTeX::Entry::EntryType entryType, TQListView * /*listViewWarnings*/ );

    private:
        bool m_isModified;

        TQPushButton *m_pushButtonAdd;
        TQPushButton *m_pushButtonDelete;
        TQPushButton *m_pushButtonOpen;
        TQLineEdit *m_lineEditKey;
        FieldLineEdit *m_fieldLineEditValue;
        TDEListView *m_listViewFields;
        KURL m_internalURL;

        void setupGUI();

    private slots:
        void updateGUI();
        void fieldExecute( TQListViewItem * item );
        void addClicked();
        void deleteClicked();
        void openClicked();

    };

    class ValueListViewItem : public TQListViewItem
    {
    public:
        ValueListViewItem( const TQString& title, BibTeX::Value *value, TQListView *parent );
        ~ValueListViewItem();

        const BibTeX::Value *value();
        TQString title();
        void setValue( BibTeX::Value *value );
        void setTitle( const TQString &title );

    private:
        TQString m_title;
        BibTeX::Value *m_value;

        void setTexts( const TQString& title );
    };

}

#endif
