/***************************************************************************
*   Copyright (C) 2004-2009 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <tqbuffer.h>

#include "fileexporterxml.h"
#include "xsltransform.h"

#include "fileexporterxslt.h"

namespace BibTeX
{

    FileExporterXSLT::FileExporterXSLT( XSLTransform *transformer )
            : FileExporter()
    {
        m_transformer = transformer;
        m_exporterXML = new FileExporterXML();
    }


    FileExporterXSLT::~FileExporterXSLT()
    {
        delete m_exporterXML;
    }

    bool FileExporterXSLT::save( TQIODevice* iodevice, const File* bibtexfile, TQStringList *errorLog )
    {
        m_mutex.lock();
        TQBuffer buffer;

        buffer.open( IO_WriteOnly );
        if ( m_exporterXML->save( &buffer, bibtexfile, errorLog ) )
        {
            buffer.close();
            buffer.open( IO_ReadOnly );
            TQTextStream ts( &buffer );
            ts.setEncoding( TQTextStream::UnicodeUTF8 );
            TQString xml = ts.read();
            buffer.close();
            TQString html = m_transformer->transform( xml );
            TQTextStream htmlTS( iodevice );
            htmlTS.setEncoding( TQTextStream::UnicodeUTF8 );
            htmlTS << html << endl;
            m_mutex.unlock();
            return true;
        }

        m_mutex.unlock();
        return false;
    }

    bool FileExporterXSLT::save( TQIODevice* iodevice, const Element* element, TQStringList *errorLog )
    {
        m_mutex.lock();
        TQBuffer buffer;

        buffer.open( IO_WriteOnly );
        if ( m_exporterXML->save( &buffer, element, errorLog ) )
        {
            buffer.close();
            buffer.open( IO_ReadOnly );
            TQTextStream xmlTS( &buffer );
            xmlTS.setEncoding( TQTextStream::UnicodeUTF8 );
            TQString xml = xmlTS.read();
            buffer.close();
            TQString html = m_transformer->transform( xml );
            TQTextStream output( iodevice );
            output.setEncoding( TQTextStream::UnicodeUTF8 );
            output << html << endl;
            m_mutex.unlock();
            return true;
        }

        m_mutex.unlock();
        return false;
    }

}
