/***************************************************************************
 *   Copyright (C) 2005 by Alexander Nemish   *
 *   atlanter@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BOOKMARK_H
#define BOOKMARK_H

#include <tqdatetime.h>
#include <tqstring.h>
#include <vector>

class Bookmark;
typedef std::vector<Bookmark> Bookmarks;

/**
*/
class Bookmark
{
public:
	Bookmark(int page, const TQString& name = TQString(), 
		TQDateTime dateTime = TQDateTime::currentDateTime());
	~Bookmark();

	void setPage(unsigned int page) { m_page = page; }
	unsigned int page() const { return m_page; }
	const TQString & name() const { return m_name; }
	const TQDateTime & dateTime() const { return m_dateTime; }

	bool operator < (const Bookmark& rhs) const { return (m_page < rhs.m_page); }

	void setName(const TQString& theValue)
	{
		m_name = theValue;
	}
	
private:
	unsigned int m_page;
	TQString m_name;
	TQDateTime m_dateTime;
};

#endif
