/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "forcebackupdialog.h"

#include <tdelocale.h>
#include <tqlayout.h>
#include <kurl.h>
#include <dcopref.h>
#include <kdebug.h>
#include <kactivelabel.h>
#include <kmimetype.h>
#include <tqpixmap.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kprogress.h>
#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <tqvaluelist.h>
#include <tdemessagebox.h>

#include "backupconfig.h"
#include "backuplistviewitem.h"

ForceBackupDialog::ForceBackupDialog(TQWidget *parent):KDialogBase(Plain, i18n("Backup now"),
	Help|Cancel|Ok, Cancel, parent, "forceBackupDialog", true, false)
{
	TQGridLayout* toplayout = new TQGridLayout(plainPage());
	m_view = new ForceBackupDialogView(plainPage());
	toplayout->addWidget(m_view,0,0);

	loadBackupList();
	
	m_manager = new RDBManager();
	connect( m_manager, TQT_SIGNAL(backupError(Backup,TQString)), this, TQT_SLOT(slotBackupError(Backup,TQString)) );

	connect( this, TQT_SIGNAL(okClicked()), this, TQT_SLOT(slotForceBackup()));
}

ForceBackupDialog::~ForceBackupDialog()
{
	delete m_manager;
}

void ForceBackupDialog::loadBackupList()
{
	BackupConfig backupConfig;
	TQValueList<Backup> backupList = backupConfig.backupList();
	TQValueList<Backup>::iterator it;
	for ( it = backupList.begin(); it != backupList.end(); ++it )
	{
		new BackupListViewItem(m_view->m_lstBackup,*it);
	}
}

void ForceBackupDialog::slotForceBackup()
{
	TQValueList<Backup> backupList;
	TQListViewItemIterator it( m_view->m_lstBackup );
	while ( it.current() ) 
	{
		TQListViewItem *item = it.current();
		if ( item->isSelected() )
		{
			BackupListViewItem *backupItem = static_cast<BackupListViewItem*>(item);
			backupList.append(backupItem->backup());
		}
		++it;
	}
	RDBManager *manager;
	m_manager->slotForceBackup(backupList);
}

void ForceBackupDialog::slotBackupError(Backup backup,TQString errorMessage)
{
	KMessageBox::error(this,i18n("<p><b>An error occured making %1 backup:</b></p><p>%2</p>").arg(backup.source()).arg(errorMessage));
}

#include "forcebackupdialog.moc"
