/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "backuplistwidget.h"

#include <tqpushbutton.h>
#include <tdelistbox.h>
#include <tqstringlist.h>
#include <kurlrequester.h>
#include <kdebug.h>

#include "backuplistviewitem.h"
#include "listviewtooltip.h"
#include "addbackupwizard.h"
#include "backupconfig.h"

BackupListWidget::BackupListWidget(TQWidget *parent,char *name): BackupListView(parent,name)
{
	TQToolTip::remove(m_lstBackup);
	new ListViewToolTip(m_lstBackup);
	slotReadSettings();

	connect( m_btnAdd, TQT_SIGNAL( clicked()), this, TQT_SLOT( slotAddClicked() ) );
	connect( m_btnRemove, TQT_SIGNAL( clicked()), this, TQT_SLOT( slotRemoveClicked() ) );
	connect( m_btnEdit, TQT_SIGNAL( clicked()), this, TQT_SLOT( slotEditClicked() ) );	
}

BackupListWidget::~BackupListWidget()
{
}

void BackupListWidget::slotReadSettings()
{
	m_lstBackup->clear();
	BackupConfig *backupConfig = new BackupConfig();
	TQValueList<Backup> backupList = backupConfig->backupList();
	TQValueList<Backup>::iterator it;
	for ( it = backupList.begin(); it != backupList.end(); ++it )
	{
		BackupListViewItem *item = new BackupListViewItem(m_lstBackup,*it);
	}
	delete backupConfig;
}

void BackupListWidget::slotSaveSettings()
{
	TQValueList<Backup> backupList;
	TQListViewItemIterator it( m_lstBackup );
	while ( it.current() ) {
		TQListViewItem *item = it.current();
		BackupListViewItem *backupItem = static_cast<BackupListViewItem*>(item);
		backupList.append(backupItem->backup());
		++it;
	}
	BackupConfig *backupConfig = new BackupConfig();
	backupConfig->setBackupList(backupList);
	delete backupConfig;
}

void BackupListWidget::slotAddClicked()
{
	AddBackupWizard *wizard = new AddBackupWizard(this,"addBackupWizard");
	connect(wizard,TQT_SIGNAL(backupSetted(Backup) ), this, TQT_SLOT(slotAddBackup(Backup)));
	wizard->show();	
}

void BackupListWidget::slotEditClicked()
{
	TQListViewItem *item = m_lstBackup->currentItem();
	if ( item )
	{
		BackupListViewItem *backupItem = static_cast<BackupListViewItem*>(item);
		AddBackupWizard *wizard = new AddBackupWizard(backupItem->backup(),this,"addBackupWizard");
		connect(wizard,TQT_SIGNAL(backupSetted(Backup) ), this, TQT_SLOT(slotUpdateBackup(Backup)));
		wizard->show();	
	}
}

void BackupListWidget::slotRemoveClicked()
{
	m_lstBackup->removeItem(m_lstBackup->currentItem());
}

void BackupListWidget::slotAddBackup(Backup backup)
{
	BackupListViewItem *item = new BackupListViewItem(m_lstBackup,backup);
}

void BackupListWidget::slotUpdateBackup(Backup backup)
{
	TQListViewItem *item = m_lstBackup->currentItem();
	if ( item )
	{
		BackupListViewItem *backupItem = static_cast<BackupListViewItem*>(item);
		backupItem->setBackup(backup);
	}
}

#include "backuplistwidget.moc"
