/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mainactions.h"
#include "misc.h"
#include "kftpapi.h"
#include "kftpqueue.h"
#include "kftpbookmarks.h"
#include "configdialog.h"
#include "kftpsession.h"

#include "widgets/browser/view.h"
#include "widgets/browser/detailsview.h"
#include "widgets/browser/propsplugin.h"

#include "misc/kftpconfig.h"
#include "misc/filter.h"

#include <tdemainwindow.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <tdeaboutapplication.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kpropertiesdialog.h>
#include <tdeio/job.h>
#include <kshred.h>
#include <klineedit.h>

#include <tqclipboard.h>

using namespace KFTPGrabberBase;
using namespace KFTPWidgets::Browser;
using namespace KFTPCore::Filter;

MainActions::MainActions(MainWindow *parent)
 : TQObject(parent),
   m_configDialog(0),
   m_closeApp(false)
{
  // setup File menu
  m_fileConnectAction = new TDEAction(i18n("Quick &Connect..."), "connect_creating", TDEShortcut(), mainWidget(), SLOT(slotQuickConnect()), actionCollection(), "file_quick_connect");
  m_newSessionAction = new TDEActionMenu(i18n("&New Session"), "document-new", actionCollection(), "file_newsession");

  TDEAction *leftSide = new TDEAction(i18n("&Left Side"), TDEShortcut(), this, SLOT(slotNewSessionLeft()), actionCollection());
  TDEAction *rightSide = new TDEAction(i18n("&Right Side"), TDEShortcut(), this, SLOT(slotNewSessionRight()), actionCollection());
  m_newSessionAction->insert(leftSide);
  m_newSessionAction->insert(rightSide);
  m_newSessionAction->setStickyMenu(true);
  m_newSessionAction->setDelayed(false);
  KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());

  // setup Settings menu
  //KStdAction::configureToolbars(this, SLOT(slotConfigureToolbars()), actionCollection());
  //KStdAction::keyBindings(this, SLOT(slotKeyBindings()), actionCollection());
  KStdAction::saveOptions(this, SLOT(slotSettingsSave()), actionCollection());
  KStdAction::preferences(this, SLOT(slotSettingsConfig()), actionCollection());
  mainWidget()->createStandardStatusBarAction();
  mainWidget()->setStandardToolBarMenuEnabled(true);

  // setup transfermode actions
  m_transModeAction = new TDEActionMenu(i18n("&Transfer Mode (Auto)"), "application-octet-stream", actionCollection(), "transfermode");
  m_modeAscii = new TDERadioAction(i18n("ASCII"), "text-vnd.tde.ascii", TDEShortcut(), this, SLOT(slotModeAscii()), actionCollection());
  m_modeBinary = new TDERadioAction(i18n("Binary"), "application-octet-stream", TDEShortcut(), this, SLOT(slotModeBinary()), actionCollection());
  m_modeAuto = new TDERadioAction(i18n("Auto"), TDEShortcut(), this, SLOT(slotModeAuto()), actionCollection());

  // Set grouping so only one action can be selected
  m_modeAscii->setExclusiveGroup("Transfer mode");
  m_modeBinary->setExclusiveGroup("Transfer mode");
  m_modeAuto->setExclusiveGroup("Transfer mode");

  // Insert the actions into the menu
  m_transModeAction->insert(m_modeAscii);
  m_transModeAction->insert(m_modeBinary);
  m_transModeAction->popupMenu()->insertSeparator();
  m_transModeAction->insert(m_modeAuto);
  m_transModeAction->setStickyMenu(true);
  m_transModeAction->setDelayed(false);
}

TDEActionCollection *MainActions::actionCollection()
{
  return KFTPAPI::getInstance()->mainWindow()->actionCollection();
}

TDEMainWindow *MainActions::mainWidget()
{
  return KFTPAPI::getInstance()->mainWindow();
}

void MainActions::slotModeAscii()
{
  m_transModeAction->setIcon("text-vnd.tde.ascii");
  m_transModeAction->setText(i18n("&Transfer Mode (ASCII)"));
  KFTPCore::Config::self()->setGlobalMode('A');
}

void MainActions::slotModeBinary()
{
  m_transModeAction->setIcon("application-octet-stream");
  m_transModeAction->setText(i18n("&Transfer Mode (Binary)"));
  KFTPCore::Config::self()->setGlobalMode('I');
}

void MainActions::slotModeAuto()
{
  m_transModeAction->setText(i18n("&Transfer Mode (Auto)"));
  KFTPCore::Config::self()->setGlobalMode('X');
}

void MainActions::slotFileQuit()
{
  m_closeApp = true;
  mainWidget()->close();
}

void MainActions::slotSettingsSave()
{
  KFTPCore::Config::self()->saveConfig();
}

void MainActions::slotSettingsConfig()
{
  if (!m_configDialog)
    m_configDialog = new KFTPWidgets::ConfigDialog(mainWidget());

  m_configDialog->prepareDialog();
  m_configDialog->exec();
}

void MainActions::slotNewSessionLeft()
{
  KFTPSession::Manager::self()->spawnLocalSession(KFTPSession::LeftSide, true);
}

void MainActions::slotNewSessionRight()
{
  KFTPSession::Manager::self()->spawnLocalSession(KFTPSession::RightSide, true);
}

void MainActions::slotKeyBindings()
{
  KKeyDialog::configure(actionCollection());
}

void MainActions::slotConfigureToolbars()
{
  KEditToolbar dlg(actionCollection());

  if (dlg.exec())
    mainWidget()->createGUI();
}

#include "mainactions.moc"
