/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2004 by the KFTPGrabber developers
 * Copyright (C) 2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPBOOKMARKEDITORLISTVIEW_H
#define KFTPBOOKMARKEDITORLISTVIEW_H

#include <tqdom.h>
#include <tqtimer.h>

#include "../listview.h"

class TDEAction;
class TDEActionCollection;
class Sidebar;
class KFTPSelectServerDialog;

namespace KFTPBookmarks {
  class Site;
  class Manager;
  class BookmarkEditor;
  class Sidebar;
}

namespace KFTPWidgets {

namespace Bookmarks {

class ListView;

class ListViewItem : public TDEListViewItem
{
friend class BookmarkEditor;
friend class KFTPWidgets::Bookmarks::ListView;
friend class Sidebar;
friend class ::KFTPSelectServerDialog;
public:
    ListViewItem(TQListView *parent, const TQString &t1);
    ListViewItem(TQListViewItem *parent, const TQString &t1);

    int compare(TQListViewItem *i, int col, bool) const;

    void setSite(KFTPBookmarks::Site *site) { m_site = site; }
    void setType(int type) { m_type = type; }
private:
    int m_type;
    KFTPBookmarks::Site *m_site;
};

/**
@author Jernej Kos
*/
class ListView : public KFTPWidgets::ListView
{
Q_OBJECT
public:
    ListView(KFTPBookmarks::Manager *bookmarks, TQWidget *parent = 0, const char *name = 0);

    /**
     * Fill current treeview with all the bookmarks.
     */
    void fillBookmarkData();

    /**
     * This changes the auto-update behaviour of the ListView. If set to true, this
     * list view will automaticly update when bookmarks are changed. Defaults
     * to false.
     *
     * @param value True to enable auto update, false otherwise
     */
    void setAutoUpdate(bool value);

    /**
     * This changes the connect-on-click behaviour of the ListView. If set to true,
     * a new remote session will be spawned whenever the users double clicks the
     * bookmark.
     *
     * @param value True to enable connect on click, false otherwise
     */
    void setConnectBookmark(bool value);

    /**
     * Get the bookmarks, the listview operates on
     */
    KFTPBookmarks::Manager *getBookmarks();

    /**
     * Specifiy, whether an edit menuitem should be placed in the contextmenu
     *
     * @param value True to enable the edit menuitem, false otherwise
     */
    void setEditMenuItem(bool value);

private:
    enum BookmarkType {
      BT_CATEGORY = 0,
      BT_SERVER
    };

    bool m_autoUpdate;
    bool m_connectBookmark;
    bool m_editMenuItem;
    TQDragObject *m_dragObject;

    /* Actions */
    TDEAction *m_newAction;
    TDEAction *m_renameAction;
    TDEAction *m_deleteAction;
    TDEAction *m_subCatAction;
    TDEAction *m_copyAction;

    /* Auto open categories support */
    TQListViewItem *m_dropItem;
    TQListViewItem* m_currentBeforeDropItem;
    TQTimer *m_openTimer;

    /* Specifies, on which bookmarks we operate */
    KFTPBookmarks::Manager *m_bookmarks;

    KFTPBookmarks::Site *m_activeSite;
    KFTPBookmarks::Site *m_activeCategory;
    KFTPWidgets::Bookmarks::ListViewItem *m_activeItem;

    TDEActionCollection *actionCollection();

    /* Drag & drop support */
    TQDragObject *dragObject();
    bool acceptDrag(TQDropEvent *e) const;
    void contentsDragEnterEvent(TQDragEnterEvent *e);
    void contentsDragMoveEvent(TQDragMoveEvent *e);
    void contentsDragLeaveEvent(TQDragLeaveEvent*);
private slots:
    void slotDropped(TQDropEvent *e, TQListViewItem*);
    void slotDoubleClicked(TQListViewItem *item);
    void slotOpenTimer();

    void slotClicked(TQListViewItem*);
    void slotNewAction();
    void slotRenameAction();
    void slotDeleteAction();
    void slotSubCatAction();
    void slotDuplicateAction();
    void slotContextMenu(TQListViewItem*, const TQPoint&, int col);

    void slotAutoUpdate();
    void slotBookmarkExecuted(TQListViewItem*);
signals:
    void bookmarkMoved();
    void bookmarkNew(ListViewItem*, KFTPBookmarks::Site*);
    void bookmarkDeleted();
    void bookmarkDuplicated(ListViewItem*, KFTPBookmarks::Site*);
    void bookmarkClicked(TQListViewItem*);

    void categoryRenamed();
};

}

}

#endif
