/***************************************************************************
    begin                : Tuesday Nov 15 2005
    copyright            : (C) 2005 by Holger Danielsson
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kilestatswidget.h"
  
#include <kdialog.h>
#include <tdelocale.h>

#include <tqvariant.h>
#include <tqlabel.h>
#include <tqbuttongroup.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include "kiledebug.h"

KileWidgetStatistics::KileWidgetStatistics( TQWidget* parent, const char* name, WFlags fl )
    : TQWidget( parent, name, fl )
{
	TQVBoxLayout *vbox = new TQVBoxLayout(parent, 5,KDialog::spacingHint() );

	// characters groupbox
	TQGroupBox *chargroup = new TQGroupBox( i18n("Characters"),parent); 
	chargroup->setColumnLayout(0, Qt::Vertical );
	chargroup->layout()->setSpacing( 6 );
	chargroup->layout()->setMargin( 11 );
	chargrouplayout = new TQGridLayout( chargroup->layout() );
	chargrouplayout->setAlignment( TQt::AlignTop );

	m_wordCharText = new TQLabel(i18n("Words and numbers:"), chargroup);
	m_commandCharText = new TQLabel(i18n("LaTeX commands and environments:"), chargroup);
	m_whitespaceCharText = new TQLabel(i18n("Punctuation, delimiter and whitespaces:"), chargroup);
	m_totalCharText = new TQLabel(i18n("Total characters:"), chargroup);
	m_wordChar = new TQLabel( chargroup, "m_wordChar" );
	m_commandChar = new TQLabel( chargroup, "m_commandChar" );
	m_whitespaceChar = new TQLabel( chargroup, "m_whitespaceChar" );
	m_totalChar = new TQLabel( chargroup, "m_totalChar" );

	TQFrame *charframe = new TQFrame(chargroup);
	charframe->setFrameStyle(TQFrame::HLine | TQFrame::Sunken);
	charframe->setLineWidth(1);

	chargrouplayout->addWidget( m_wordCharText, 0,0 );
	chargrouplayout->addWidget( m_commandCharText, 1,0 );
	chargrouplayout->addWidget( m_whitespaceCharText, 2,0 );
	chargrouplayout->addWidget( m_totalCharText, 4,0 );
	chargrouplayout->addWidget( m_wordChar, 0,2,TQt::AlignRight );
	chargrouplayout->addWidget( m_commandChar, 1,2,TQt::AlignRight );
	chargrouplayout->addWidget( m_whitespaceChar, 2,2,TQt::AlignRight );
	chargrouplayout->addMultiCellWidget( charframe, 3,3,1,2 );
	chargrouplayout->addWidget( m_totalChar, 4,2,TQt::AlignRight );
	chargrouplayout->setColSpacing(1,16);
	chargrouplayout->setColSpacing(3,1);
	chargrouplayout->setColStretch(3,1);

	// string groupbox
	TQGroupBox *stringgroup = new TQGroupBox( i18n("Strings"),parent);
	stringgroup->setColumnLayout(0, Qt::Vertical );
	stringgroup->layout()->setSpacing( 6 );
	stringgroup->layout()->setMargin( 11 );
	stringgrouplayout = new TQGridLayout( stringgroup->layout() );
	stringgrouplayout->setAlignment( TQt::AlignTop );

	m_wordStringText = new TQLabel(i18n("Words:"), stringgroup);
	m_commandStringText = new TQLabel(i18n("LaTeX commands:"), stringgroup);
	m_environmentStringText = new TQLabel(i18n("LaTeX environments:"), stringgroup);
	m_totalStringText = new TQLabel(i18n("Total strings:"), stringgroup);
	m_wordString = new TQLabel( stringgroup, "m_wordString" );
	m_commandString = new TQLabel( stringgroup, "m_commandStringText" );
	m_environmentString = new TQLabel( stringgroup, "m_environmentStringText" );
	m_totalString = new TQLabel( stringgroup, "m_totalStringText" );

	TQFrame *stringframe = new TQFrame(stringgroup);
	stringframe->setFrameStyle(TQFrame::HLine | TQFrame::Sunken);
	stringframe->setLineWidth(1);

	stringgrouplayout->addWidget( m_wordStringText, 0,0 );
	stringgrouplayout->addWidget( m_commandStringText, 1,0 );
	stringgrouplayout->addWidget( m_environmentStringText, 2,0 );
	stringgrouplayout->addWidget( m_totalStringText, 4,0 );
	stringgrouplayout->addWidget( m_wordString, 0,2,TQt::AlignRight );
	stringgrouplayout->addWidget( m_commandString, 1,2,TQt::AlignRight );
	stringgrouplayout->addWidget( m_environmentString, 2,2,TQt::AlignRight );
	stringgrouplayout->addMultiCellWidget( stringframe, 3,3,1,2 );
	stringgrouplayout->addWidget( m_totalString, 4,2,TQt::AlignRight );
	stringgrouplayout->setColSpacing(1,16);
	stringgrouplayout->setColSpacing(3,1);
	stringgrouplayout->setColStretch(3,1);

	m_commentAboutHelp = new TQLabel(parent);
	m_warning =  new TQLabel(parent);
 
	vbox->addWidget(chargroup);
	vbox->addWidget(stringgroup);
	vbox->addSpacing(12);
	vbox->addWidget(m_commentAboutHelp);
	vbox->addWidget(m_warning);
	vbox->addStretch(1);

	int w = m_commandCharText->sizeHint().width();
	if ( m_whitespaceCharText->sizeHint().width() > w )
		w = m_whitespaceCharText->sizeHint().width();
	stringgrouplayout->setColSpacing(0,w);

}

KileWidgetStatistics::~KileWidgetStatistics()
{
}

void KileWidgetStatistics::updateColumns()
{
	int w = m_totalChar->sizeHint().width();
	if ( m_totalString->sizeHint().width() > w )
		w = m_totalString->sizeHint().width();
	chargrouplayout->setColSpacing(2,w);
	stringgrouplayout->setColSpacing(2,w);
}


#include "kilestatswidget.moc"
