/***************************************************************************
                         texdocdialog.h
                         --------------
    date                 : Feb 15 2007
    version              : 0.14
    copyright            : (C) 2005-2007 by Holger Danielsson
    email                : holger.danielsson@versanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEXDOCDIALOG_H
#define TEXDOCDIALOG_H

#include <kdialogbase.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kprocess.h>
#include <tdetempfile.h>
#include <tdelistview.h>

#include <tqlabel.h>
#include <tqstringlist.h>
#include <tqmap.h>

namespace KileDialog
{

class TexDocDialog : public KDialogBase  
{
	Q_OBJECT
  

public:
	TexDocDialog(TQWidget *parent=0, const char *name=0);
	~TexDocDialog();

private:	
	TDEListView *m_texdocs;
	KLineEdit *m_leKeywords;
	KPushButton *m_pbSearch;

	TQString m_texmfPath, m_texmfdocPath, m_texdoctkPath;
	
	TQStringList m_tocList,m_tocSearchList;
	TQMap<TQString,TQString> m_dictDocuments;
	TQMap<TQString,TQString> m_dictStyleCodes;
	
	void readToc();
	void showToc(const TQString &caption,const TQStringList &doclist, bool toc=true);

	TQString m_filename;
	TQString m_output;
	
	KTempFile *m_tempfile;
	KShellProcess *m_proc;
	
	void callSearch();
	void executeScript(const TQString &command);
	void showFile(const TQString &filename);

	TQString searchFile(const TQString &docfilename,const TQString &listofpathes, 
	                   const TQString &subdir=TQString());
	void decompressFile(const TQString &docfile,const TQString &command);
	void showStyleFile(const TQString &filename,const TQString &stylecode);
	
	TQString getMimeType(const TQString &filename);
	TQString getIconName(const TQString &filename);

protected:
	bool eventFilter(TQObject *o, TQEvent *e); 

signals:
	void processFinished();

protected slots:
	void slotHelp(); 
	
private slots:
	void slotListViewDoubleClicked(TQListViewItem *item,const TQPoint &,int); 
	void slotTextChanged(const TQString &text);
	void slotSearchClicked();
	
	void slotProcessOutput(TDEProcess*,char* buf,int len);
	void slotProcessExited (TDEProcess *proc);

	void slotInitToc();
	void slotShowFile();
};

}

#endif
