/***************************************************************************
    begin                : Sun Jun 3 2001
    copyright            : (C) 2001 - 2003 by Brachet Pascal, 2003 Jeroen Wijnhout
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef USERMENUDIALOG_H
#define USERMENUDIALOG_H

#include <tqstring.h>
#include <tqstringlist.h>

#include <kdialogbase.h>

#include "kileactions.h"

class TQRadioButton;
class KTextEdit;
class TQLineEdit;
class TQComboBox;
class TQLabel;
class KPushButton;

namespace KileDialog
{

class UserTags: public KDialogBase
{
	Q_OBJECT
  

public:
	UserTags( const TQValueList<KileAction::TagData> &list, TQWidget* parent = 0, const char* name = 0, const TQString &caption = TQString());
	~UserTags();

	int index() { return m_prevIndex; }
	const TQValueList<KileAction::TagData>& result() {return m_list; }

	static TQString completeTag(const KileAction::TagData & td);
	static KileAction::TagData splitTag(const TQString & name, const TQString & tag);

private slots:
	void change(int index);
	void redraw();

	void slotAdd();
	void slotInsert();
	void slotRemove();

	void slotApply();

private:
	int 				m_prevIndex;
	KTextEdit 		*m_editTag;
	TQLineEdit 		*m_editName;
	TQComboBox 		*m_combo;
	TQLabel			*m_labelName;
	TQLabel			*m_labelTag;
	KPushButton		*m_buttonRemove, *m_buttonAdd, *m_buttonInsert;

	TQValueList<KileAction::TagData> 	m_list;
};

}

#endif // USERMENUDIALOG_H
