/* this file is part of the kmplayer application
   copyright (c) 2003 koos vriezen <koos.vriezen@xs4all.nl>

   this program is free software; you can redistribute it and/or
   modify it under the terms of the gnu general public
   license as published by the free software foundation; either
   version 2 of the license, or (at your option) any later version.

   this program is distributed in the hope that it will be useful,
   but without any warranty; without even the implied warranty of
   merchantability or fitness for a particular purpose.  see the gnu
    general public license for more details.

   you should have received a copy of the gnu general public license
   along with this program; see the file copying.  if not, write to
   the free software foundation, inc., 59 temple place - suite 330,
   boston, ma 02110-1301, usa.
*/

#ifndef _KMPLAYER_BROADCAST_SOURCE_H_
#define _KMPLAYER_BROADCAST_SOURCE_H_

#include <list>
#include <vector>

#include <tqframe.h>
#include <tqguardedptr.h>

#include "kmplayerappsource.h"
#include "kmplayerprocess.h"
#include "kmplayerconfig.h"

class KMPlayerPrefBroadcastPage;        // broadcast
class KMPlayerPrefBroadcastFormatPage;  // broadcast format
class TQListBox;
class TQComboBox;
class TQLineEdit;
class TQTable;
class TQPushButton;
class KLed;

namespace KMPlayer {
    class FFMpeg;
}

class KMPLAYER_NO_EXPORT FFServerSetting {
public:
    KDE_NO_CDTOR_EXPORT FFServerSetting () {}
    FFServerSetting (int i, const TQString & n, const TQString & f, const TQString & ac, int abr, int asr, const TQString & vc, int vbr, int q, int fr, int gs, int w, int h);
    KDE_NO_CDTOR_EXPORT FFServerSetting (const TQStringList & sl) { *this = sl; }
    KDE_NO_CDTOR_EXPORT ~FFServerSetting () {}
    int index;
    TQString name;
    TQString format;
    TQString audiocodec;
    TQString audiobitrate;
    TQString audiosamplerate;
    TQString videocodec;
    TQString videobitrate;
    TQString quality;
    TQString framerate;
    TQString gopsize;
    TQString width;
    TQString height;
    TQStringList acl;
    FFServerSetting & operator = (const TQStringList &);
    FFServerSetting & operator = (const FFServerSetting & fs);
    const TQStringList list ();
    TQString & ffconfig (TQString & buf);
};

typedef std::vector <FFServerSetting *> FFServerSettingList;


class KMPLAYER_NO_EXPORT KMPlayerPrefBroadcastPage : public TQFrame {
    Q_OBJECT
  
public:
    KMPlayerPrefBroadcastPage (TQWidget * parent);
    KDE_NO_CDTOR_EXPORT ~KMPlayerPrefBroadcastPage () {}

    TQLineEdit * bindaddress;
    TQLineEdit * port;
    TQLineEdit * maxclients;
    TQLineEdit * maxbandwidth;
    TQLineEdit * feedfile;
    TQLineEdit * feedfilesize;
};

class KMPLAYER_NO_EXPORT KMPlayerPrefBroadcastFormatPage : public TQFrame {
    Q_OBJECT
  
public:
    KMPlayerPrefBroadcastFormatPage (TQWidget * parent, FFServerSettingList &);
    KDE_NO_CDTOR_EXPORT ~KMPlayerPrefBroadcastFormatPage () {}

    TQListBox * profilelist;
    TQComboBox * format;
    TQLineEdit * audiocodec;
    TQLineEdit * audiobitrate;
    TQLineEdit * audiosamplerate;
    TQLineEdit * videocodec;
    TQLineEdit * videobitrate;
    TQLineEdit * quality;
    TQLineEdit * framerate;
    TQLineEdit * gopsize;
    TQLineEdit * moviewidth;
    TQLineEdit * movieheight;
    TQLineEdit * profile;
    TQPushButton * startbutton;
    KLed * serverled;
    KLed * feedled;
    void setSettings (const FFServerSetting &);
    void getSettings (FFServerSetting &);
private slots:
    void slotIndexChanged (int index);
    void slotItemHighlighted (int index);
    void slotTextChanged (const TQString &);
    void slotLoad ();
    void slotSave ();
    void slotDelete ();
private:
    TQTable * accesslist;
    TQPushButton * load;
    TQPushButton * save;
    TQPushButton * del;
    FFServerSettingList & profiles;
};


/*
 * Preference page for ffmpeg commandline arguments
 */
class KMPLAYER_NO_EXPORT KMPlayerFFServerConfig : public KMPlayer::PreferencesPage {
public:
    KMPlayerFFServerConfig ();
    KDE_NO_CDTOR_EXPORT ~KMPlayerFFServerConfig () {}
    virtual void write (TDEConfig *);
    virtual void read (TDEConfig *);
    virtual void sync (bool fromUI);
    virtual void prefLocation (TQString & item, TQString & icon, TQString & tab);
    virtual TQFrame * prefPage (TQWidget * parent);
    int ffserverport;
    int maxclients;
    int maxbandwidth;
    TQString feedfile;
    int feedfilesize;
    TQString bindaddress;
private:
    TQGuardedPtr <KMPlayerPrefBroadcastPage> m_configpage;
};

/*
 * Preference page for ffserver
 */
class KMPLAYER_NO_EXPORT KMPlayerBroadcastConfig : public TQObject, public KMPlayer::PreferencesPage {
    Q_OBJECT
  
public:
    KMPlayerBroadcastConfig (KMPlayer::PartBase * player, KMPlayerFFServerConfig * fsc);
    KDE_NO_CDTOR_EXPORT ~KMPlayerBroadcastConfig ();

    virtual void write (TDEConfig *);
    virtual void read (TDEConfig *);
    virtual void sync (bool fromUI);
    virtual void prefLocation (TQString & item, TQString & icon, TQString & tab);
    virtual TQFrame * prefPage (TQWidget * parent);

    bool broadcasting () const;
    void stopServer ();
    KDE_NO_EXPORT const TQString & serverURL () const { return m_ffserver_url; }

    FFServerSetting ffserversettings;
    FFServerSettingList ffserversettingprofiles;
signals:
    void broadcastStarted ();
    void broadcastStopped ();
private slots:
    void processOutput (TDEProcess *, char *, int);
    void processStopped (TDEProcess * process);
    void startServer ();
    void startFeed ();
    void stateChange (KMPlayer::Process::State, KMPlayer::Process::State);
    void sourceChanged (KMPlayer::Source *, KMPlayer::Source *);
private:
    KMPlayer::PartBase * m_player;
    KMPlayerFFServerConfig * m_ffserverconfig;
    TQGuardedPtr <KMPlayerPrefBroadcastFormatPage> m_configpage;
    KMPlayer::FFMpeg * m_ffmpeg_process;
    TDEProcess * m_ffserver_process;
    bool m_endserver;
    TQString m_ffserver_out;
    TQString m_ffserver_url;
};


#endif //_KMPLAYER_BROADCAST_SOURCE_H_
