/* This file is part of the KMPlayer application
   Copyright (C) 2003 Koos Vriezen <koos.vriezen@xs4all.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _KMPLAYER_TV_SOURCE_H_
#define _KMPLAYER_TV_SOURCE_H_

#include <tqguardedptr.h>
#include <tqstring.h>
#include <tqframe.h>

#include "kmplayerappsource.h"
#include "kmplayerconfig.h"
#include "kmplayer.h"

const short id_node_tv_document = 40;
const short id_node_tv_device = 41;
const short id_node_tv_input = 42;
const short id_node_tv_channel = 43;

class KMPlayerPrefSourcePageTV;         // source, TV
class TVDeviceScannerSource;
class KMPlayerTVSource;
class KURLRequester;
class KHistoryCombo;
class KMPlayerApp;
class TQTabWidget;
class TQGroupBox;
class TQLineEdit;
class TQCheckBox;
class KComboBox;
class TDEConfig;


class KMPLAYER_NO_EXPORT TVDevicePage : public TQFrame {
    Q_OBJECT
  
public:
    TVDevicePage (TQWidget *parent, KMPlayer::NodePtr dev);
    KDE_NO_CDTOR_EXPORT ~TVDevicePage () {}

    TQLineEdit * name;
    KURLRequester * audiodevice;
    TQLineEdit * sizewidth;
    TQLineEdit * sizeheight;
    TQCheckBox * noplayback;
    TQTabWidget * inputsTab;
    KMPlayer::NodePtrW device_doc;
signals:
    void deleted (TVDevicePage *);
private slots:
    void slotDelete ();
};

class KMPLAYER_NO_EXPORT KMPlayerPrefSourcePageTV : public TQFrame {
    Q_OBJECT
  
public:
    KMPlayerPrefSourcePageTV (TQWidget *parent, KMPlayerTVSource *);
    KDE_NO_CDTOR_EXPORT ~KMPlayerPrefSourcePageTV () {}
    TQLineEdit * driver;
    KURLRequester * device;
    TQPushButton * scan;
    TQTabWidget * notebook;
protected:
    void showEvent (TQShowEvent *);
    KMPlayerTVSource * m_tvsource;
};

class KMPLAYER_NO_EXPORT TVNode : public KMPlayer::GenericMrl {
public:
    TVNode (KMPlayer::NodePtr &d, const TQString &s, const char * t, short id, const TQString &n=TQString ());
    virtual void setNodeName (const TQString &);
};

/*
 * Element for channels
 */
class KMPLAYER_NO_EXPORT TVChannel : public TVNode {
public:
    TVChannel (KMPlayer::NodePtr & d, const TQString & n, double f);
    TVChannel (KMPlayer::NodePtr & d);
    KDE_NO_CDTOR_EXPORT ~TVChannel () {}
    void closed ();
};

/*
 * Element for inputs
 */
class KMPLAYER_NO_EXPORT TVInput : public TVNode {
public:
    TVInput (KMPlayer::NodePtr & d, const TQString & n, int id);
    TVInput (KMPlayer::NodePtr & d);
    KDE_NO_CDTOR_EXPORT ~TVInput () {}
    KMPlayer::NodePtr childFromTag (const TQString &);
    void setNodeName (const TQString &);
    void closed ();
};

/*
 * Element for TV devices
 */
class KMPLAYER_NO_EXPORT TVDevice : public TVNode {
public:
    TVDevice (KMPlayer::NodePtr & d, const TQString & s);
    TVDevice (KMPlayer::NodePtr & d);
    ~TVDevice ();
    KMPlayer::NodePtr childFromTag (const TQString &);
    void closed ();
    void childDone (KMPlayer::NodePtr child);
    void setNodeName (const TQString &);
    bool expose () const { return false; }
    void updateNodeName ();
    void updateDevicePage ();
    bool zombie;
    TQGuardedPtr <TVDevicePage> device_page;
};

class KMPLAYER_NO_EXPORT TVDocument : public FileDocument {
    KMPlayerTVSource * m_source;
public:
    TVDocument (KMPlayerTVSource *);
    KMPlayer::NodePtr childFromTag (const TQString &);
    void defer ();
    KDE_NO_EXPORT const char * nodeName () const { return "tvdevices"; }
    void childDone (KMPlayer::NodePtr child);
};


/*
 * Source form scanning TV devices
 */
class KMPLAYER_NO_EXPORT TVDeviceScannerSource : public KMPlayer::Source {
    Q_OBJECT
  
public:
    TVDeviceScannerSource (KMPlayerTVSource * src);
    KDE_NO_CDTOR_EXPORT ~TVDeviceScannerSource () {};
    virtual void init ();
    virtual bool processOutput (const TQString & line);
    virtual TQString filterOptions ();
    virtual bool hasLength ();
    virtual bool isSeekable ();
    virtual bool scan (const TQString & device, const TQString & driver);
public slots:
    virtual void activate ();
    virtual void deactivate ();
    virtual void play ();
    virtual void stateChange (KMPlayer::Process *, KMPlayer::Process::State os, KMPlayer::Process::State ns);
signals:
    void scanFinished (TVDevice * tvdevice);
private:
    KMPlayerTVSource * m_tvsource;
    TVDevice * m_tvdevice;
    KMPlayer::Source * m_old_source;
    TQString m_driver;
    TQRegExp m_nameRegExp;
    TQRegExp m_sizesRegExp;
    TQRegExp m_inputRegExp;
};

/*
 * Source form TV devices, also implementing preference page for it
 */
class KMPLAYER_NO_EXPORT KMPlayerTVSource : public KMPlayerMenuSource, public KMPlayer::PreferencesPage {
    Q_OBJECT
  
public:
    KMPlayerTVSource (KMPlayerApp * app, TQPopupMenu * m);
    virtual ~KMPlayerTVSource ();
    virtual TQString filterOptions ();
    virtual bool hasLength ();
    virtual bool isSeekable ();
    virtual KMPlayer::NodePtr root ();
    void buildMenu ();
    virtual TQString prettyName ();
    virtual void write (TDEConfig *);
    virtual void read (TDEConfig *);
    virtual void sync (bool);
    virtual void prefLocation (TQString & item, TQString & icon, TQString & tab);
    virtual TQFrame * prefPage (TQWidget * parent);
    void readXML ();
public slots:
    virtual void activate ();
    virtual void deactivate ();
    virtual void playCurrent ();
    virtual void jump (KMPlayer::NodePtr e);
    void menuAboutToShow ();
    void menuClicked (int id);
private slots:
    void slotScan ();
    void slotScanFinished (TVDevice * device);
    void slotDeviceDeleted (TVDevicePage *);
private:
    void addTVDevicePage (TVDevice * dev, bool show=false);
    void buildArguments ();
    KMPlayer::NodePtrW m_cur_tvdevice;
    KMPlayer::NodePtrW m_cur_tvinput;
    TQPopupMenu * m_channelmenu;
    TQString tvdriver;
    KMPlayerPrefSourcePageTV * m_configpage;
    TVDeviceScannerSource * scanner;
    int tree_id;
    bool config_read; // whether tv.xml is read
};

#endif //_KMPLAYER_TV_SOURCE_H_
