//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFNETWORK_H
#define KMFNETWORK_H

#include "kmfdoc.h"
#include "kmfundoengine.h"

// QT includes
#include <tqdom.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>

// KDE includes
#include <kurl.h>

// Project includes
#include "ipaddress.h"
#include "kmfprotocol.h"

namespace KMF {
class KMFError;
class KMFNetZone;
class KMFTarget;
class IPAddress;
class KMFCompilerInterface;
class KMyFirewallInterface;

/**
@author Christian Hubinger
*/

class KDE_EXPORT KMFNetwork : public KMFDoc {

//##### static stuff ####
public:
	

//##### end static stuff

public:
	KMFNetwork( NetfilterObject*, const char*, KMyFirewallInterface* app );

	~KMFNetwork();
	/** resets the document to the initial values */
	virtual void clear();

	/** Reeturn if the Network is empty */
	bool isEmpty();
	
	/** Return DomDocument of this Chain */
	const TQDomDocument& getDOMTree();

	virtual void loadXML( const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	virtual int type();
	
	void parseDocument( const KURL&, TQStringList& errors );
		
	/** Get the File dialog filter string for the document type */	
	virtual const TQString& getFileDialogFilter();
		
 	KMFDoc* currentDoc();
	KMFIPTDoc* currentDocAsIPTDoc();
	KMFGenericDoc* currentDocAsGenericDoc();

 	KMFTarget* currentTarget();
 	void setCurrentTarget( KMFTarget* );
 	
	KMFNetZone* netzone() const {
		return m_myNetwork;
	}	
	
	virtual KMFError* exportXMLRuleset( bool promtFile, bool asTemplate );
	
protected:
	virtual KMFError* exportXMLRuleset( const KURL& url  );
	void initDoc();
	void setupDefaultHosts();
	
private:
	bool loadProtocolLibrary();
	bool loadCustomProtocolLibrary();
// 	KMFCompilerInterface* compiler();

private: // DATA
	TQGuardedPtr<KMFNetZone> m_myNetwork;
	TQGuardedPtr<KMFTarget> m_target;
	
/*	KMFNetZone *m_myNetwork;
	KMFTarget *m_target;*/
};
}
#endif
