//
// C++ Interface: kmfprotocolusage
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFPROTOCOLUSAGE_H
#define KMFPROTOCOLUSAGE_H

#include "netfilterobject.h"

// QT includes
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqguardedptr.h>
#include <tqptrlist.h>
#include <tqmap.h>
#include <tqobject.h>
// KDE includes
#include <kdemacros.h>
#include <kurl.h>

// Project includes
#include "kmfprotocol.h"

namespace KMF {
/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class KMFProtocolUsage : public NetfilterObject {
	friend class KMFProtocol;
TQ_OBJECT
  
public:
	
    ~KMFProtocolUsage();
    
    void setProtocol( KMFProtocol* );
    KMFProtocol *protocol() const {
    	return m_protocol;
    }
    
    virtual int type();
    virtual void clear();
    
    virtual const TQString& name();
    virtual const TQString& description();
    
    bool validUsage();
    
    void setLimitInterval( const TQString& );
	void setLimit( int );
	
	int limit() const {
		return m_limit;
	};

	const TQString& limitInterval() const {
		return m_limit_interval;
	};
	
	void setLogging( bool );
    bool logging() const {
		return m_log;
	};
	
	enum { OUTGOING, INCOMING } IO;
	void setIO ( int );
	int io() const {
		return m_io;
	};
	
	const TQDomDocument& getDOMTree();
	virtual void loadXML(const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );

public slots:
	void slotOnProtocolDeleted( TQObject* protocol );

private: 
	KMFProtocolUsage( NetfilterObject* parent, const char* name );
	TQGuardedPtr<KMFProtocol> m_protocol;
	TQString m_limit_interval;
	int m_limit;
	int m_protocolType, m_io;
	bool m_log;
};
}
#endif
