//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterface.h"

// qt includes
#include <tqstring.h>
#include <tqlayout.h>
#include <tqtabwidget.h>

// kde includes
#include <tdelocale.h>
#include <kdebug.h>
#include <tdeglobal.h>
#include <kiconloader.h>


// project includes
#include "../core/kmfnetwork.h"
#include "../core/kmfgenericdoc.h"

#include "../kmfwidgets/kmfmynetworkwidget.h"
#include "kmfgenericinterfaceprotocol.h"
//#include "kmfgenericinterfaceeditprotocol.h"
#include "kmfgenericinterfacenat.h"
#include "kmfgenericinterfacehost.h"
#include "kmfgenericinterfacelogging.h"
#include "kmfgenericinterfaceicmp.h"

namespace KMF {

KMFGenericInterface::KMFGenericInterface( TQWidget *parent, const char *name ) : KJanusWidget( parent, name,  KJanusWidget::IconList ) {
	connect( this,TQT_SIGNAL( aboutToShowPage( TQWidget* ) ),
		this,TQT_SLOT( slotPageChanged( TQWidget* ) ) );
	loadIcons();
	
	//###################### My Network Widget ###################################
	myNetworkFrame = addPage(i18n("My Network"), i18n("Define and configure the  firewall host you like to configure"), icon_zone_page );
	m_myNetworkWidget =  new KMFMyNetworkWidget( myNetworkFrame, "m_myNetworkWidget" );
	connect( this, TQT_SIGNAL( sigUpdateView() ),
		m_myNetworkWidget, TQT_SLOT( slotUpdateView() ) );
	connect( this, TQT_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_myNetworkWidget, TQT_SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	connect( m_myNetworkWidget, TQT_SIGNAL( sigActiveTargetChanged() ), this, TQT_SIGNAL( sigTargetChanged() ) );
	
	TQGridLayout *myNetworkLayout = new TQGridLayout( myNetworkFrame, 1, 1, 2, 2 );
	myNetworkLayout->addWidget( m_myNetworkWidget,0,0 );
	
	//###################### Access Control PAGE #################################
	protocolFrame = addPage(i18n("Access Control"), i18n("Access configuration for incoming and outgoing connections"), icon_protocol_page );

	m_protocolPageZones = new KMFGenericInterfaceProtocol( protocolFrame, "m_protocolPageIncoming");
	connect( this, TQT_SIGNAL( sigUpdateView() ),
		m_protocolPageZones, TQT_SLOT( slotUpdateView() ) );
	connect( this, TQT_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_protocolPageZones, TQT_SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	TQGridLayout *protocoLayout = new TQGridLayout( protocolFrame, 1, 1, 2, 2 );
	protocoLayout->addWidget( m_protocolPageZones,0,0 );

	//###################### HOSTS PAGE ###################################
	hostFrame = addPage(i18n("Special Hosts"), i18n("Define Hosts that should be treated specially."), icon_host_page );
	m_hostPage = new KMFGenericInterfaceHost(hostFrame,"m_hostPageTrusted");
	connect( this, TQT_SIGNAL( sigUpdateView() ),
		m_hostPage, TQT_SLOT( slotUpdateView() ) );
	connect( this, TQT_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_hostPage, TQT_SLOT( slotUpdateView( NetfilterObject* ) ) );

	TQGridLayout *hostLayout = new TQGridLayout( hostFrame, 1, 1, 2, 2 );
	hostLayout->addWidget( m_hostPage,0,0 );

	//###################### ICMP PAGE #################################
	icmpFrame = addPage(i18n("ICMP Options"), i18n("Define how ICMP packets should be handled."), icon_icmp_page );
	TQGridLayout *icmpLayout = new TQGridLayout( icmpFrame, 1, 1, 2, 2 );
	m_icmpPage = new KMFGenericInterfaceIcmp(icmpFrame,"m_icmpPage");
	connect( this, TQT_SIGNAL( sigUpdateView() ),
		m_icmpPage, TQT_SLOT( slotUpdateView() ) );
	connect( this, TQT_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_icmpPage, TQT_SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	icmpLayout->addWidget( m_icmpPage,0,0 );


	//###################### NAT PAGE ###################################
	natFrame = addPage(i18n("NAT Configuration"), i18n("Configure NAT (Network Address Translation) here."), icon_nat_page );
	TQGridLayout *natLayout = new TQGridLayout( natFrame, 1, 1, 2, 2 );
	m_natPage = new KMFGenericInterfaceNat(natFrame,"m_natPage");
	connect( this, TQT_SIGNAL( sigUpdateView() ),
		m_natPage, TQT_SLOT( slotUpdateView() ) );
	connect( this, TQT_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_natPage, TQT_SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	natLayout->addWidget( m_natPage,0,0 );

	//###################### LOGGING PAGE ###################################
	logFrame = addPage(i18n("Logging"), i18n("Configure your firewall's logging behavior here."), icon_logging_page );
	TQGridLayout *logLayout = new TQGridLayout( logFrame, 1, 1, 2, 2 );
	m_loggingPage = new KMFGenericInterfaceLogging(logFrame,"m_loggingPage");
	connect( this, TQT_SIGNAL( sigUpdateView() ),
		m_loggingPage, TQT_SLOT( slotUpdateView() ) );
	connect( this, TQT_SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_loggingPage, TQT_SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	logLayout->addWidget( m_loggingPage,0,0 );
	
	setEnabled( false );
}

KMFGenericInterface::~KMFGenericInterface() {}

void KMFGenericInterface::loadDoc( KMFNetwork* doc ) {
	kdDebug() << "void KMFGenericInterface::loadDoc( KMFGenericDoc* )" << endl;
	if ( ! doc ) {
		setEnabled( false );
		return;
	}
	setEnabled( true );
	m_network = doc;

	m_myNetworkWidget->setNetwork( m_network );
	m_myNetworkWidget->slotUpdateView();
	m_myNetworkWidget->parent();
	
	m_protocolPageZones->loadDoc( m_network );
	m_protocolPageZones->slotUpdateView();
	
	m_hostPage->loadDoc( m_network );
	m_hostPage->slotUpdateView();

// 	m_protocolPageEditProtocol->loadDoc( m_network );
// 	m_protocolPageEditProtocol->slotUpdateView();

	m_icmpPage->loadDoc( m_network );
	m_icmpPage->slotUpdateView();

	m_natPage->loadDoc( m_network );
	m_natPage->slotUpdateView();

	m_loggingPage->loadDoc( m_network );
	m_loggingPage->slotUpdateView();
}

/* 
void KMFGenericInterface::slotUpdateView( NetfilterObject* obj ) {
	kdDebug() << "KMFGenericInterface::slotUpdateView( NetfilterObject* )" << endl;
	if ( ! m_network ) {
			setEnabled( false );
			return;
		}
		m_myNetworkWidget->slotUpdateView( obj );

		m_protocolPageZones->slotUpdateView( obj );

		m_hostPage->slotUpdateView( obj );

		m_icmpPage->slotUpdateView( obj );

		m_natPage->slotUpdateView( obj );

		m_loggingPage->slotUpdateView( obj );
}

void KMFGenericInterface::slotUpdateView() {
		if ( ! m_network ) {
			setEnabled( false );
			return;
		}
		m_myNetworkWidget->slotUpdateView();

		m_protocolPageZones->slotUpdateView();

		m_hostPage->slotUpdateView();

		m_icmpPage->slotUpdateView();

		m_natPage->slotUpdateView();

		m_loggingPage->slotUpdateView();
}
*/

void KMFGenericInterface::slotPageChanged( TQWidget* /*wid*/ ){
	kdDebug() << "KMFGenericInterface::slotPageChanged( TQWidget* )" << endl;
	emit sigUpdateView();
	// slotUpdateView();
}

void KMFGenericInterface::loadIcons() {
	kdDebug() << "void KMFGenericInterface::loadIcons()" << endl;
	TDEIconLoader *loader = TDEGlobal:: iconLoader();
	TQString icon_name;

	icon_name = "network";
	icon_zone_page = loader->loadIcon( icon_name, TDEIcon::Desktop );

	icon_name = "services";
	icon_protocol_page = loader->loadIcon( icon_name, TDEIcon::Desktop );

	icon_name = "nfs-unmounted";
	icon_edit_protocol_page = loader->loadIcon( icon_name, TDEIcon::Desktop );

	icon_name = "pipe";
	icon_icmp_page = loader->loadIcon( icon_name, TDEIcon::Desktop );

	icon_name = "text-x-log";
	icon_logging_page = loader->loadIcon( icon_name, TDEIcon::Desktop );

	icon_name = "network_local";
	icon_host_page = loader->loadIcon( icon_name, TDEIcon::Desktop );

	icon_name = "document-save-as";
	icon_nat_page = loader->loadIcon( icon_name, TDEIcon::Desktop );
}

}

#include "kmfgenericinterface.moc"
