//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACE_H
#define KMFGENERICINTERFACE_H

#include <kjanuswidget.h>

/**
@author Christian Hubinger
*/

// QT includes
#include <tqpixmap.h>
#include <tqguardedptr.h>

class TQFrame;
class TQVBox;
class TQTabWidget;

// KDE includes



// Project includes
namespace KMF {
class KMFGenericInterfaceProtocol;
class KMFGenericInterfaceNat;
class KMFGenericInterfaceHost;
class KMFGenericInterfaceLogging;
class KMFGenericInterfaceEditProtocol;
class KMFGenericInterfaceIcmp;
class KMFGenericDoc;
class KMFNetwork;
class KMFMyNetworkWidget;
class NetfilterObject;

class KMFGenericInterface : public KJanusWidget {
	TQ_OBJECT
  
public:

	KMFGenericInterface( TQWidget *parent = 0, const char *name = 0 );
	~KMFGenericInterface();

	void loadDoc( KMFNetwork* );


private slots:
	void slotPageChanged( TQWidget* );
// 	void slotUpdateView();
// 	void slotUpdateView( NetfilterObject* );

private:
	void loadIcons();
	
signals:
	void sigUpdateView();	
	void sigUpdateView( NetfilterObject* );
	void sigTargetChanged();
		
private:
	KMFMyNetworkWidget *m_myNetworkWidget;
	KMFGenericInterfaceProtocol *m_protocolPageZones;
	KMFGenericInterfaceEditProtocol *m_protocolPageEditProtocol;
	KMFGenericInterfaceNat *m_natPage;
	KMFGenericInterfaceHost *m_hostPage;
	KMFGenericInterfaceLogging *m_loggingPage;
	KMFGenericInterfaceIcmp *m_icmpPage;

	TQGuardedPtr<KMFNetwork> m_network;

	TQFrame *myNetworkFrame,  *zoneFrame, *protocolFrame, *editProtocolFrame,*icmpFrame,  *hostFrame,*natFrame, *logFrame;

	TQPixmap icon_zone_page, icon_protocol_page,
					icon_edit_protocol_page, icon_icmp_page,
					icon_logging_page, icon_host_page, icon_nat_page;

	
};
}
#endif
