//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACEPROTOCOL_H
#define KMFGENERICINTERFACEPROTOCOL_H

#include <kmyfirewallgenericinterfaceprotocolwidget.h>

// QT includes
class TQListViewItem;


#include <tqptrlist.h>
#include <tqstring.h>
#include <tqguardedptr.h>
#include <tqpixmap.h>
#include <tquuid.h>

// KDE includes
class TDEPopupMenu;

// Project includes
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocolusage.h"
#include "../core/kmfprotocolcategory.h"


class TQCheckBox;
class TQTextEdit;

/*class KMFErrorHandler;*/

namespace KMF {
class KMFNetwork;
class KMFGenericDoc;
class KMFNetZone;
class KMFListViewItem;
class KMFNetHost;
class KMFNetworkWidget;
class KMFNetHostPropertiesWidget;
class KMFProtocolPropertiesWidget;
class KMFProtocolListView;

class KMFGenericInterfaceProtocol : public KMyFirewallGenericInterfaceProtocolWidget {
	TQ_OBJECT
  
public:
	KMFGenericInterfaceProtocol( TQWidget *parent = 0, const char *name = 0, WFlags f = 0 );

	~KMFGenericInterfaceProtocol();
	void loadDoc( KMFNetwork* );

// 	void setType( int );
// 	enum { INCOMING, OUTGOING };

public slots:
	void slotUpdateView();
	void slotUpdateView( NetfilterObject* );

private slots:
// 	void slotNewProtocolSelected( TQListViewItem* );
	void slotNewItemSelected( TQListViewItem* );
	void slotZoneRBM( TQListViewItem*, const TQPoint&, int );
	void slotAddZone();
	void slotDelZone();
	void slotAddHost();
	void slotDelHost();
	void slotAddressChanged( const TQString& );
	void slotZoneChanged( KMFNetZone* );
	void slotCurrentZoneChanged( const TQString& );
	void slotRenameZone();
	void slotRenameHost();
	void slotRenameItem( TQListViewItem* item, int, const TQString& name );
	void slotRestrictionChanged();
	void slotProtocolClicked( KMFProtocolUsage*, bool );
	void slotProtocolCategoryClicked( KMFProtocolCategory* );
private:
	void loadIcons();
 	KMFListViewItem* findItem( const TQUuid& obj_id );

private:
	TQGuardedPtr<KMFNetwork> m_doc;
	
	TDEPopupMenu* m_contextMenu;

	KMFNetworkWidget *m_network_widget;
	KMFNetHostPropertiesWidget *m_nethostProperties_widget;
	KMFProtocolPropertiesWidget *m_protocolProperties_widget;
	KMFProtocolListView *m_protocolLIstView;
	
	TQPtrList<KMFNetZone> m_zones;
	TQGuardedPtr<KMFProtocolUsage> m_protocolUsage;
	TQGuardedPtr<KMFNetZone> m_zone;
	TQGuardedPtr<KMFNetHost> m_host;
	
	int m_type;
	TQPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
	        icon_target, icon_queue, icon_new, icon_copy, icon_move;

};
}
#endif
