/***************************************************************************
 begin                : Sat Mar 9 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfnewchaindlg.h"

// qt includes
#include <tqstring.h>
#include <tqradiobutton.h>
#include <tqlineedit.h>
#include <tqnamespace.h>
#include <tqevent.h>

// kde includes
#include <tdelocale.h>
#include <kdebug.h>
#include <tdemessagebox.h>

// my includes
#include "../core/xmlnames.h"
#include "../core/kmfdoc.h"
#include "../core/kmfiptdoc.h"
#include "../core/kmferror.h"
#include "../core/kmfcheckinput.h"
#include "../core/kmferrorhandler.h"
#include "../core/kmfnetwork.h"
#include "../core/kmfundoengine.h"
namespace KMF {
KMFNewChainDlg::KMFNewChainDlg ( TQWidget *parent, const char *name, bool modal, WFlags fl ) : KMyFirewallChainEditorNewChain ( parent, name, modal, fl ) {
	kmfdoc = 0;
	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler ( "KMFNewChainDlg" );
	m_check_input = new KMFCheckInput();
}

KMFNewChainDlg::~KMFNewChainDlg() {}

void KMFNewChainDlg::keyPressEvent ( TQKeyEvent * e ) {
	// kdDebug() << "KMFNewChainDlg::keyPressEvent ( TQKeyEvent * " <<  e->key()  << ")" << endl;
	if ( e->key() == TQt::Key_Enter ||
			e->key() == TQt::Key_Return ) {
		accept();
		e-> accept();
	}
	if ( e->key() == TQt::Key_Escape ||
			e->key() == TQt::Key_Backspace ) {
		TQDialog::reject();
		e-> accept();
	}
}

void KMFNewChainDlg::loadDoc ( KMFIPTDoc* doc ) {
	kmfdoc = doc;
}
/** No descriptions */
void KMFNewChainDlg::accept() {
	if ( kmfdoc == 0 ) {
		KMessageBox::error ( 0, i18n ( "KMFNewChainDlg: kmfdoc = 0. This happened because of a bug." ) );
		return ;
	}
	TQStringList StringList;
	TQString name = t_name->text();
	TQString target = "DROP";
	if ( !name.isEmpty() ) {
		m_check_input->checkInput ( name, "CHAINNAME", m_err );
		if ( ! m_err_handler->showError ( m_err ) ) {
			return;
		}

		IPTChain* chain = 0;
		TQString table = Constants::FilterTable_Name;
		if ( c_filter->isChecked() ) {
			table = Constants::FilterTable_Name;
		} else if ( c_nat->isChecked() ) {
			table = Constants::NatTable_Name;
		} else if ( c_mangle->isChecked() ) {
			table = Constants::MangleTable_Name;
		} else {
			return;
		}

		KMFUndoEngine::instance()->startTransaction (
			kmfdoc->table ( table ),
			i18n ( "Added Chain: %1 to Table: %1" ).arg ( name ).arg ( table )
		);
		chain = kmfdoc->table ( table )->addChain ( name, target, false, m_err );
		if ( m_err_handler->showError ( m_err ) ) {
			kmfdoc->table ( table )->changed();
			KMFUndoEngine::instance()->endTransaction();
			emit sigUpdateView();
		} else {
			KMFUndoEngine::instance()->abortTransaction();
			return;
		}
		TQDialog::accept();
	} else {
		KMessageBox::sorry ( 0, i18n ( "You must set a name for your chain." ) );
		return;
	}
}

}

#include "kmfnewchaindlg.moc"
