//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfinterfacewidget.h"

// QT includes
#include <tqstringlist.h>

// KDE includes
#include <tdelocale.h>
#include <kcombobox.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kurlrequester.h>
#include <kguiitem.h>
#include <kpushbutton.h>
#include <knuminput.h>
#include <tdelistbox.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <tdeglobal.h>
#include <tdemessagebox.h>
#include <tdelistview.h>

// Prokject includes
#include "../core/kmftarget.h"
#include "../core/kmftargetconfig.h"
#include "../core/kmfundoengine.h"
namespace KMF {
KMFInterfaceWidget::KMFInterfaceWidget( TQWidget* parent, const char* name, WFlags fl )
		: KMyFirewallInterfaceWidget( parent, name, fl ) {
		connect( m_b_add_int, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotAddInterface() ) );
		connect( m_b_del_int, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotDelInterface() ) );
		
		m_cb_int_name->clear();
		m_cb_int_name->insertItem( "eth" );
		m_cb_int_name->insertItem( "ppp" );
		m_cb_int_name->insertItem( "ippp" );
		m_cb_int_name->insertItem( "ppoe" );
		m_cb_int_name->insertItem( "wlan" );
		m_cb_int_name->insertItem( "tun" );
		m_cb_int_name->insertItem( "tap" );
		m_cb_int_name->insertItem( "gre" );
		m_cb_int_name->insertItem( "lo" );
}

KMFInterfaceWidget::~KMFInterfaceWidget() {}

void KMFInterfaceWidget::loadTarget( KMFTarget* target ) {
	kdDebug() << "KMFInterfaceWidget::loadTarget( KMFTarget* target )" << endl;
	m_target = target;
	updateView();
}

void KMFInterfaceWidget::updateView(){
	kdDebug() << "KMFInterfaceWidget::updateView()" << endl;
	if ( ! m_target ) {
		return;
	}
	KMFTargetConfig *conf = m_target->config();
	kdDebug() << "Load Config:" << endl;
	kdDebug() << conf->toString() << endl;
	m_lb_int->clear();
	TQStringList ints = conf->interfaces();
	for ( TQStringList::Iterator it = ints.begin(); it != ints.end(); ++it ) {
        TQString s = *it;
        kdDebug() << "Load Interface: " << s << endl; 
        m_lb_int->insertItem( s );
    }
}

void KMFInterfaceWidget::slotAddInterface() {
	TQString int_name = m_cb_int_name->currentText();
	int int_num = m_sb_int_num->value();
	TQString str_num;
	str_num.setNum( int_num );
	TQString interface = int_name;
	if ( int_name != "lo" )
		interface += str_num;
	for ( uint i = 0;i < m_lb_int->count();i++ ) {
		TQString interf = m_lb_int->text( i );
		if ( interface == interf ) {
			KMessageBox::sorry( this, i18n( "You cannot have more then one interface with the same name." ),
								i18n( "Configuration" ) );
			return ;
		}
	}
	m_lb_int->insertItem( interface );
	
	
	KMFUndoEngine::instance()->startTransaction(
		m_target->config(),
		i18n( "Edit interfaces for target: %1.").arg( m_target->guiName() )
	);
	m_target->config()->setInterfaces( interfaces() );
	KMFUndoEngine::instance()->endTransaction();

}

void KMFInterfaceWidget::addInterface( const TQString& interface ) {
	for ( uint i = 0;i < m_lb_int->count();i++ ) {
		TQString interf = m_lb_int->text( i );
		if ( interface == interf ) {
			KMessageBox::sorry( this, i18n( "You cannot have more then one interface with the same name." ),
								i18n( "Configuration" ) );
			return ;
		}
	}
	m_lb_int->insertItem( interface );
}

void KMFInterfaceWidget::addInterfaces( TQStringList interfcaes ) {
	m_lb_int-> insertStringList( interfcaes );
}

void KMFInterfaceWidget::slotDelInterface() {
	int index = m_lb_int->currentItem();
	if ( index > -1 ) {
		switch ( TQMessageBox::warning( this, i18n( "Configuration" ),
				 i18n( "Are you sure that you want to delete\n"
						 "this interface?\n" ),
				 i18n( "&OK" ), i18n( "&Cancel" ),
				 0, 2 ) ) {

					 case 0:      // OK clicked
						m_lb_int->removeItem( index );
						KMFUndoEngine::instance()->startTransaction(
							m_target->config(),
							i18n( "Edit interfaces for target: %1.").arg( m_target->guiName() )
						);
						m_target->config()->setInterfaces( interfaces() );
						KMFUndoEngine::instance()->endTransaction();
						break;
				 }

	} else {
		KMessageBox::sorry( this, i18n( "You have to select an interface first before you can delete it." ),
							i18n( "Configuration" ) );
		return ;

	}
}

void KMFInterfaceWidget::clear() {
	m_lb_int->clear();
}

TQStringList KMFInterfaceWidget::interfaces() {
	TQStringList ifs;
	for ( uint i = 0;i < m_lb_int->count();i++ ) {
		TQString interf = m_lb_int->text( i );
		if ( !interf.isEmpty() ) {
			kdDebug() << "Found Interface " << interf << endl;
			ifs << interf;
		}
	}
	return ifs;
}

}
#include "kmfinterfacewidget.moc"

