/***************************************************************************
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmferrorhandler.h"

// TQt includes
#include <tdemessagebox.h>
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h> 
// my includes
#include "kmferror.h"

namespace KMF {

KMFErrorHandler::KMFErrorHandler( const TQString& name ) {
	m_caller_name = new TQString( name );
}
KMFErrorHandler::~KMFErrorHandler() {}

bool KMFErrorHandler::showError( KMFError* err ) {
// 	kdDebug() << "KMFErrorHandler::showError(KMFError* err)" << endl;
	TQString header = "";
	if ( err->errType() == KMFError::OK ) {
// 		kdDebug() << "Found Error Type: KMFError::OK" << endl;
		return true;
	}

	if ( err->errType() == KMFError::HINT ) {
// 		kdDebug() << "Found Error Type: KMFError::HINT" << endl;
		header += i18n( "Hint" );
		const TQString err_msg = err->errMsg();
// 		kdDebug() << "Error Msg: " + err_msg << endl;
		KMessageBox::information( 0, err_msg, header, err_msg);
		return true;
	}
	if ( err->errType() == KMFError::NORMAL ) {
// 		kdDebug() << "Found Error Type: KMFError::NORMAL " << endl;
		header += *m_caller_name;
		const TQString err_msg = err->errMsg();
// 		kdDebug() << "Error Msg: " + err_msg << endl;
		KMessageBox::sorry( 0, err_msg, header );
		return false;
	}

	if ( err->errType() == KMFError::FATAL ) {
// 		kdDebug() << "Found Error Type:  KMFError::FATAL" << endl;
		header += *m_caller_name;
		const TQString err_msg = err->errMsg();
// 		kdDebug() << "Error Msg: " + err_msg << endl;
		KMessageBox::error( 0, err_msg, header );
		return false;
	}
	return false;
}

}


