/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditip.h"


// TQt includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditip.h"

namespace KMF {
KMFRuleOptionEditIP::KMFRuleOptionEditIP(TQObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditIP::KMFRuleOptionEditIP(TQObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditIP( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,TQ_SIGNAL(sigHideMe() ), 
		this,TQ_SLOT( slotShowOverview() ) );
}
KMFRuleOptionEditIP::~KMFRuleOptionEditIP() {}

void KMFRuleOptionEditIP::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const TQString& KMFRuleOptionEditIP::optionEditName() const {
	return *( new TQString( i18n("IP Option") ) );
}
const TQString& KMFRuleOptionEditIP::description() const {
	return *( new TQString( i18n("This plugin manages the IP based options of iptables.") ) );
}

void KMFRuleOptionEditIP::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditIP::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleOptionEditIP::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditIP::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

// TDEInstance* KMFRuleOptionEditIPFactory::s_instance = 0L;
// TDEAboutData* KMFRuleOptionEditIPFactory::s_about = 0L;

KMFRuleOptionEditIPFactory::KMFRuleOptionEditIPFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new TDEInstance( "KMFRuleOptionEditIPFactory" );
}

TQObject* KMFRuleOptionEditIPFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleOptionEditIP( parent, name );
	emit objectCreated( obj );
	return obj;
}


// TDEInstance* KMFRuleOptionEditIPFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new TDEInstance( "KMFRuleOptionEditIPFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_ip() {
		return new KMFRuleOptionEditIPFactory;
	}
}

}


#include "kmfruleoptioneditip.moc"
