//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruletargetoptioneditlog.h"


// TQt includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../ipteditor/kmfruleedit.h"
#include "kmfruleedittargetlog.h"

namespace KMF {
KMFRuleTargetOptionEditLog::KMFRuleTargetOptionEditLog(TQObject *parent, const char *name)
		: KMFRuleTargetOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleTargetOptionEditLog::KMFRuleTargetOptionEditLog(TQObject *parent, const char *name)" << endl;
	
	m_managedTargets << "LOG";
	
	
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditTargetLog( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,TQ_SIGNAL(sigHideMe() ), 
		this,TQ_SLOT( slotShowOverview() ) );
}
KMFRuleTargetOptionEditLog::~KMFRuleTargetOptionEditLog() {}

void KMFRuleTargetOptionEditLog::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleTargetOptionEditLog::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}


const TQString& KMFRuleTargetOptionEditLog::optionEditName() const {
	return *( new TQString( i18n("NAT Option") ) );
}
const TQString& KMFRuleTargetOptionEditLog::description() const {
	return *( new TQString( i18n("This plugin manages the NAT options of iptables.") ) );
}

void KMFRuleTargetOptionEditLog::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleTargetOptionEditLog::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleTargetOptionEditLog::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleTargetOptionEditLog::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}

bool KMFRuleTargetOptionEditLog::setTarget( const TQString& target ){
	if ( ! manageTarget( target ) ) {
		return false;
	}
	return true;
}



// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

// TDEInstance* KMFRuleTargetOptionEditLogFactory::s_instance = 0L;
// TDEAboutData* KMFRuleTargetOptionEditLogFactory::s_about = 0L;

KMFRuleTargetOptionEditLogFactory::KMFRuleTargetOptionEditLogFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new TDEInstance( "KMFRuleTargetOptionEditLogFactory" );
}

TQObject* KMFRuleTargetOptionEditLogFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleTargetOptionEditLog( parent, name );
	emit objectCreated( obj );
	return obj;
}


// TDEInstance* KMFRuleTargetOptionEditLogFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new TDEInstance( "KMFRuleTargetOptionEditLogFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruletargetoptionedit_log() {
		return new KMFRuleTargetOptionEditLogFactory;
	}
}


}

#include "kmfruletargetoptioneditlog.moc"
