//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfacelogging.h"

// TQt includes
#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqtimer.h>

// KDE includes
#include <tdelocale.h>
#include <kdebug.h>
#include <krestrictedline.h>

// Project includes
#include "../core/kmfnetwork.h"
#include "../core/kmfgenericdoc.h"
namespace KMF {
KMFGenericInterfaceLogging::KMFGenericInterfaceLogging( TQWidget *parent, const char *name, WFlags f )
		: KMyFirewallGenericInterfaceLogging( parent, name, f ) {
	connect( m_c_log, TQ_SIGNAL( toggled( bool ) ),
		this,TQ_SLOT( slotLoggingChanged( bool ) ) );

	connect( m_c_limitLog, TQ_SIGNAL( toggled( bool ) ),
		this,TQ_SLOT( slotLimitChanged( bool ) ) );
	
	connect( m_le_logPrefix, TQ_SIGNAL( textChanged( const TQString & ) ),
		this,TQ_SLOT ( slotLogPrefixChanged( const TQString & ) ) );
}


KMFGenericInterfaceLogging::~KMFGenericInterfaceLogging() {}

void KMFGenericInterfaceLogging::slotUpdateView( NetfilterObject* ) {
	kdDebug() << "KMFGenericInterfaceLogging::slotUpdateView( NetfilterObject* )" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	slotUpdateView();
}

void KMFGenericInterfaceLogging::slotUpdateView() {
	kdDebug() << "KMFGenericInterfaceLogging::slotUpdateView()" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	m_c_log->setChecked( m_doc->currentDocAsGenericDoc()-> logDropped() );
	m_c_limitLog->setChecked( m_doc->currentDocAsGenericDoc()->limitLog() );
	
	if (  m_doc->currentDocAsGenericDoc()->logPrefix() != m_le_logPrefix->text().simplifyWhiteSpace() ) {
		m_le_logPrefix->setText( m_doc->currentDocAsGenericDoc()->logPrefix() );
	}
}

/*!
    \fn KMFGenericInterfaceLogging::loadDoc( KMFGenricDoc* )
 */
void KMFGenericInterfaceLogging::loadDoc( KMFNetwork* doc ) {
	kdDebug() << "void KMFGenericInterfaceLogging::loadDoc( KMFGenericDoc* )" << endl;
	m_doc = doc;
	slotUpdateView();
}

void KMFGenericInterfaceLogging::slotLoggingChanged( bool onoff ) {
	if ( m_doc->currentDocAsGenericDoc()->logDropped() == onoff ) {
		return;
	}
	
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "%1 logging of dropped packets." ).arg( onoff ? i18n( "Enable" ) : i18n( "Disable" ) )
	);
	m_doc->currentDocAsGenericDoc()->setLogDropped( onoff );
	KMFUndoEngine::instance()->endTransaction();
}

void KMFGenericInterfaceLogging::slotLimitChanged( bool onoff ) {
	if ( m_doc->currentDocAsGenericDoc()->limitLog() == onoff ) {
		return;
	}
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "%1 logging limit." ).arg( onoff ? i18n( "Enable" ) : i18n( "Disable" ) )
	);
	m_doc->currentDocAsGenericDoc()->setLimitLog( onoff );
	KMFUndoEngine::instance()->endTransaction();
}

void KMFGenericInterfaceLogging::slotLogPrefixChanged( const TQString & ) {
	if ( m_doc->currentDocAsGenericDoc()->logPrefix() == m_le_logPrefix->text().simplifyWhiteSpace() ) {
		return;
	}
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "Change logging prefix to %1." ).arg( m_le_logPrefix->text().simplifyWhiteSpace() )
	);
	m_doc->currentDocAsGenericDoc()->setLogPrefix( m_le_logPrefix->text().simplifyWhiteSpace() );
	KMFUndoEngine::instance()->endTransaction();
	
}

}
#include "kmfgenericinterfacelogging.moc"
