
/***************************************************************************
 *                                                                         *
 *   KCPULoad and KNetLoad are copyright (c) 1999-2000, Markus Gustavsson  *
 *                                       (c) 2002, Ben Burton              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SPEEDDIALOG_H
#define __SPEEDDIALOG_H

#include <kdialogbase.h>

/**
 * A dialog used to select the update speed for a StatPopup.
 */
class SpeedDialog : public KDialogBase {
    Q_OBJECT
  

    public:
        /**
         * Constructor.
         */
        SpeedDialog(int defaultSpeed, TQWidget* parent);

        /**
         * Returns the speed currently selected in the dialog.
         * This is valid after the dialog has closed.
         */
        int getSpeed() const;

    private slots:
        /**
         * Updates the speed variable to reflect the latest changes in
         * the speed combo box.
         */
        virtual void updateSpeed(const TQString&);

    private:
        int speed;
            /**< The speed currently selected in the speed combo box. */
};

#endif
