/***************************************************************************
                          match_param.cpp  -  description
                             -------------------
    begin                : Tue Jun 25 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kstddirs.h>
#include <tqcstring.h>
#include <tqfile.h>
#include <tqregexp.h>
#include <string.h>
#include "match_param.moc"

match_param::match_param(resource *Rsrc) : TQObject()
{
	myResource = Rsrc;
	initialize();
}
match_param::match_param(resource *Rsrc, const int &whiteType, const int &blackType) : TQObject()
{
	myResource = Rsrc;
	initialize();

	myResource->Type[WHITE] = Type[WHITE] = whiteType;
	myResource->Type[BLACK] = Type[BLACK] = blackType;
	lookupNames();
	lookupImages();
}
match_param::~match_param()
{
}
///////////////////////////////////////
//
//	match_param::initialize
//
///////////////////////////////////////
void match_param::initialize( void )
{
	PlayerNames << "" << "" << "" << "";
	PlayerImages << TQPixmap() << TQPixmap() << TQPixmap() << TQPixmap();
	Type[WHITE] = myResource->Type[WHITE];
	Type[WHITE_HELPER] = myResource->Type[WHITE_HELPER];
	Type[BLACK] = myResource->Type[BLACK];
	Type[BLACK_HELPER] = myResource->Type[BLACK_HELPER];

	Strength[WHITE] = myResource->Strength[WHITE];
	Strength[WHITE_HELPER] = myResource->Strength[WHITE_HELPER];
	Strength[BLACK] = myResource->Strength[BLACK];
	Strength[BLACK_HELPER] = myResource->Strength[BLACK_HELPER];

	Variation = myResource->MatchRules;

	lookupTCP();
	lookupNames();
	lookupImages();
}
///////////////////////////////////////
//
//	match_param::lookupNames
//
///////////////////////////////////////
void match_param::lookupNames( void )
{
	engineList::Iterator IT;
	char ID = 0;
	for( int loop=0; loop < 4; loop++)
	{
		switch( Type[loop] )
		{
			case PLAYERLOCAL:
				PlayerNames[loop] = myResource->Local_Player;
				break;
			case PLAYERPC:
				/* Convert standard player numbers into engine Reference IDs */
				switch( loop )
				{
					case WHITE:
						ID = ENGINE_WHITE;
						break;
					case BLACK:
						ID = ENGINE_BLACK;
						break;
					case WHITE_HELPER:
						ID = ENGINE_WHITE_BK;
						break;
					case BLACK_HELPER:
						ID = ENGINE_BLACK_BK;
						break;
				}
				/* Search for Engine. I'm starting to like the idea of maps. =) */
				for( IT = myResource->engines.begin(); IT != myResource->engines.end(); ++IT )
				{
					if( (*IT).CurrentRef & ID ) break;
				}
				if( IT == myResource->engines.end() )
				{
					PlayerNames[loop] = i18n("Unknown");
				}
				else
				{
					PlayerNames[loop] = (*IT).Name;
				}
				break;
			case PLAYEREMAIL:
				PlayerNames[loop] = myResource->Email_Address;
				break;
		}
	}
}
///////////////////////////////////////
//
//	match_param::lookupTCP
//
///////////////////////////////////////
void match_param::lookupTCP( void )
{
		Time_White = myResource->TCPWhite;
		Time_Black = myResource->TCPBlack;
}
///////////////////////////////////////
//
//	match_param::lookupImages
//
///////////////////////////////////////
void match_param::lookupImages( void )
{
	for( int loop=0; loop < 4; loop++)
	{
		switch( Type[loop] )
		{
			case PLAYERLOCAL:
				PlayerImages[loop] = myResource->loadSCIDImage( PlayerNames[loop] );
				if( PlayerImages[loop].isNull() )
					PlayerImages[loop].load( locate("data", "knights/default-portrait.jpg" ) );
				break;
			case PLAYERPC:
				PlayerImages[loop] = myResource->loadSCIDImage( PlayerNames[loop] );
				if( PlayerImages[loop].isNull() )
					PlayerImages[loop].load( locate("data", "knights/default-engine-portrait.jpg" ) );
				break;
			case PLAYEREMAIL:
				PlayerImages[loop] = myResource->loadSCIDImage( PlayerNames[loop] );
				if( PlayerImages[loop].isNull() )
					PlayerImages[loop].load( locate("data", "knights/default-portrait.jpg" ) );
				break;
		}
	}
}
///////////////////////////////////////
//
//	match_param::time
//
///////////////////////////////////////
TCPList match_param::time( const char &player )
{
	if( player == BLACK )
		return Time_Black;
	return Time_White;
}

///////////////////////////////////////
//
//	match_param::setTime
//
///////////////////////////////////////
void match_param::setTime( const char &player, const TCPList &tcp )
{
	if( player == BLACK )
		myResource->TCPBlack = Time_Black = tcp;
	else
		myResource->TCPWhite = Time_White = tcp;
	setTimer();
}

///////////////////////////////////////
//
//	match_param::getVariation
//
///////////////////////////////////////

int match_param::getVariation(void)
{
	return Variation;
}

///////////////////////////////////////
//
//	match_param::setVariation
//
///////////////////////////////////////
void match_param::setVariation(const int variation)
{
	Variation = variation;
	setTimer();
}

///////////////////////////////////////
//
//	match_param::setTimer
//
///////////////////////////////////////
void match_param::setTimer( void )
{
	if( TimerFlag ) return;
	TQTimer::singleShot( 0, this, TQT_SLOT( slot_Timer() ) );
	TimerFlag = TRUE;
}

///////////////////////////////////////
//
//	match_param::slot_Timer
//
///////////////////////////////////////
void match_param::slot_Timer( void )
{
	emit valuesChanged();
	TimerFlag = FALSE;
}

///////////////////////////////////////
//
//	match_param::setType
//
///////////////////////////////////////
void match_param::setType( const int &player, const char &type )
{
	myResource->Type[player] = Type[player] = type;
	lookupNames();
	lookupImages();
	setTimer();
}

