/***************************************************************************
                          tabmanager.h  -  description
                             -------------------
    begin                : Sat Sep 14 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABMANAGER_H
#define TABMANAGER_H

#include <tqobject.h>
#include <tqptrlist.h>
#include <kapp.h>
#include <tdeconfig.h>
#include "tabbox.h"

/**
  *@author Troy Corbin Jr.
  */

typedef TQPtrList<TabBox> TabBoxList;
class resource;

class TabManager : public TQObject
{
	Q_OBJECT
  
	public:
								TabManager( resource *rsrc );
								~TabManager();
		void				addTab( TQWidget *child, const TQString &caption );
		void				childEvent( TQChildEvent *event );
		void				changeCaption( TQWidget *child, const TQString &caption );
		void				showTab( TQWidget *child );
		bool				isTab( TQWidget *child );

	public slots:
		void				removeTab( TQObject *child );

	protected slots:
		void				manageNewBox( TabBox *newBox );
		void				saveTabGeometry( const TQString&, const TQSize& );

	protected:
		TabBox*			getParentBox( TQWidget* );

	private:
		TabBoxList	myList;
		TDEConfig			*appConfig;
		resource		*myResource;
};

#endif
