/***************************************************************************
                          tabpage.cpp  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabpage.moc"
#include "tabmanager.h"
#include "tabgrip.h"
#include "resource.h"
#include <kiconloader.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tqlayout.h>
#include <tqtoolbutton.h>

///////////////////////////////////////
//
//	TabPage::constructor
//
///////////////////////////////////////
TabPage::TabPage( TQWidget *parent, TQWidget *child, resource *rsrc ) : TQVBox(parent)
{
	myResource = rsrc;
	myChild = child;

	actionBar = new TQHBox( this );
	actionBar->show();

	grip = new TabGrip( actionBar );
	connect( grip, TQT_SIGNAL( wasDragged(const TQPoint&, const TQPoint&) ), this, TQT_SLOT( tabDragged(const TQPoint&, const TQPoint&) ) );

	TDEIconLoader icons( TQString( "knights" ) );
	TQPixmap map = icons.loadIcon( TQString("tab_remove"), TDEIcon::Small, 0, TDEIcon::DefaultState, 0, TRUE );
	if( map.isNull() )
	{
		/* Keep for backward compatability with KDE 3.0 */
		map = icons.loadIcon( TQString("window-close"), TDEIcon::Small );
	}

	closeButton = new TQToolButton( actionBar, "closeButton" );
	closeButton->setIconSet( TQIconSet( map ) );
	closeButton->setAutoRaise( TRUE );
	closeButton->setTextLabel( i18n( "Close This Tab" ), TRUE );
	closeButton->setSizePolicy( TQSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed ) );
	connect( closeButton, TQT_SIGNAL( clicked() ), this, TQT_SIGNAL( requestDestruction() ) );

	myChild->reparent( this, TQPoint( 0, 0 ), TRUE );
	myChild->show();
	show();
}
///////////////////////////////////////
//
//	TabPage::destructor
//
///////////////////////////////////////
TabPage::~TabPage()
{
}
///////////////////////////////////////
//
//	TabPage::tabDragged
//
///////////////////////////////////////
void TabPage::tabDragged( const TQPoint &dest, const TQPoint &offset )
{
	TabBox *myParent = parentTabBox();
	if( myParent != NULL )
	{
		TQWidget *destWidget = TQApplication::widgetAt( dest, TRUE );
		/* Find a TabBox */
		while(1)
		{
			if( destWidget == NULL )
			{
				/* Create new TabBox */
				TabBox *newBox = new TabBox( myResource );
				newBox->resize( myParent->size() );
				newBox->move( dest + offset );
				newBox->show();
				emit newParent( newBox );
				myParent->removeTab( this );
				newBox->addTab( this, myCaption );
				break;
			}
			if( TQString( destWidget->className() ) == "TabBox" )
			{
				if( myParent != ((TabBox*)destWidget) )
				{
					/* We can latch on here */
					myParent->removeTab( this );
					((TabBox*)destWidget)->addTab( this, myCaption );
					break;
				}
				else
				{
					break;
				}
			}
			destWidget = destWidget->parentWidget();
		}
		if( myParent->count() == 0 )
		{
			/* TabManager will be notified of the delete via TQObject::destroyed(TQObject*) */
			delete myParent;
		}
	}
	else
	{
		kdError() << "TabPage::tabDragged: Can not move without a parent TabBox." << endl;
	}
}
///////////////////////////////////////
//
//	TabPage::setCaption
//
///////////////////////////////////////
void TabPage::setCaption( const TQString &caption )
{
	myCaption = caption;
}
///////////////////////////////////////
//
//	TabPage::parentTabBox
//
///////////////////////////////////////
TabBox* TabPage::parentTabBox( void )
{
	TQWidget *myParent = this->parentWidget();
	if( TQString( myParent->className() ) == "TQWidgetStack" )
	{
		myParent = myParent->parentWidget();
		if( TQString( myParent->className() ) == "TQTabWidget" )
		{
			myParent = myParent->parentWidget();
			if( TQString( myParent->className() ) == "TabBox" )
			{
				return ((TabBox*)myParent);
			}
		}
	}
	return NULL;
}
///////////////////////////////////////
//
//	TabPage::getChild
//
///////////////////////////////////////
TQWidget* TabPage::getChild( void )
{
	return myChild;
}

