/***************************************************************************
                          knowitlink.cpp  -  description
                             -------------------
    begin                : pi cze 27 2003
    copyright            : (C) 2003 by Micha Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knowitlink.h"
#include "notes.h"

#include <tqtoolbutton.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqvbox.h>

#include <tdefiledialog.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kcombobox.h>
#include <klineedit.h>

KnowitLinkDialog::KnowitLinkDialog()
   : KDialogBase(Plain, i18n("Modify link"), Ok|Cancel, Ok)
{
   TQVBoxLayout* layout = new TQVBoxLayout(plainPage());

   TQHBox* typeBox = new TQHBox(plainPage());
   layout->addWidget(typeBox);
   new TQLabel(i18n("Referenced item:"), typeBox);
   linkType = new KComboBox(typeBox, "LinkType");
   linkType->insertItem(i18n("File or URL"));
   linkType->insertItem(i18n("KnowIt note"));

   layout->addItem(new TQSpacerItem(0, 5));       
   TQHBox* editBox = new TQHBox(plainPage());
   layout->addWidget(editBox);
   linkValue = new KLineEdit("Link text", editBox);
   linkValue->setMinimumWidth(300);
   browse = new TQToolButton(editBox, "Browse");
   browse->setIconSet(TQIconSet(TDEGlobal::iconLoader()->loadIcon("document-open",
      TDEIcon::Toolbar, TDEIcon::SizeSmall)));
   
   layout->addItem(new TQSpacerItem(0, 5));
   layout->addWidget(new TQLabel(i18n("Link description:"), plainPage()));
   layout->addWidget(linkDescription = new KLineEdit("Link description", plainPage()));

   connect(browse, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotBrowse()));
   connect(linkType, TQ_SIGNAL(activated(int)), this, TQ_SLOT(slotTypeChanged(int)));
}

KnowitLinkDialog::~KnowitLinkDialog()
{
}

bool KnowitLinkDialog::modifyLink(TNoteLink& link)
{
   linkDescription->setText(link.description);
   linkType->setCurrentItem(link.isLocalReference());
   if (link.isLocalReference())
      linkValue->setText(link.link.remove(0, 9));
   else
      linkValue->setText(link.link);
   slotTypeChanged(linkType->currentItem());
   if (exec() == TQDialog::Accepted) {
      link.description = linkDescription->text();
      if (linkType->currentItem())
         link.link = "knowit://" + linkValue->text();
      else
         link.link = linkValue->text();
      return true;
   }
   else
      return false;
}

void KnowitLinkDialog::slotBrowse()
{
   KURL url=KFileDialog::getOpenURL(TQString(),
      i18n("*|All files"), this, i18n("Choose link..."));
   if (!url.isEmpty()) {
      linkValue->setText(url.url());
      linkType->setCurrentItem(0);
      }
}

void KnowitLinkDialog::slotTypeChanged(int index)
{
   browse->setEnabled(!index);
}

#include "knowitlink.moc"
