/*
 *  kis_pattern.h - part of Krayon
 *
 *  Copyright (c) 2000 Matthias Elter  <elter@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __kis_pattern_h__
#define __kis_pattern_h__

#include <tdeio/job.h>

#include "kis_debug_areas.h"
#include "kis_resource.h"
#include "kis_types.h"

class TQPoint;
class TQImage;
class KisColorSpace;
class KisPaintDevice;

class KisPattern : public KisResource {
    typedef KisResource super;
    Q_OBJECT
  

public:
    KisPattern(const TQString& file);
    KisPattern(KisPaintDevice* image, int x, int y, int w, int h);
    virtual ~KisPattern();

    virtual bool load();
    virtual bool save();
    virtual TQImage img();

    /**
     * returns a KisPaintDeviceSP made with colorSpace as the ColorSpace strategy
     * for use in the fill painter.
     **/
    KisPaintDeviceSP image(KisColorSpace * colorSpace);

    TQ_INT32 width() const;
    TQ_INT32 height() const;

    void setImage(const TQImage& img);

    KisPattern* clone() const;

protected:
    void setWidth(TQ_INT32 w);
    void setHeight(TQ_INT32 h);

private:
    bool init();

private:
    TQByteArray m_data;
    TQImage m_img;
    TQMap<TQString, KisPaintDeviceSP> m_colorspaces;
    bool m_hasFile;

    TQ_INT32 m_width;
    TQ_INT32 m_height;
};

#endif

