/*
 * This file is part of the KDE project
 *
 * Copyright (c) 2005 Cyrille Berger <cberger@cberger.net>
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include "scripting.h"

#include <stdlib.h>
#include <vector>

#include <tqapplication.h>
#include <tqpoint.h>

#include <kdebug.h>
#include <tdefiledialog.h>
#include <kgenericfactory.h>
#include <kiconloader.h>
#include <kinstance.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <tdetempfile.h>

#define KROSS_MAIN_EXPORT KDE_EXPORT
#include <main/manager.h>
#include <main/scriptguiclient.h>
#include <main/wdgscriptsmanager.h>

#include <kopalettemanager.h>

#include <kis_doc.h>
#include <kis_global.h>
#include <kis_types.h>
#include <kis_view.h>
#include <kis_image.h>
#include <kis_layer.h>

#include "chalkscripting/kis_script_progress.h"
#include "chalkscripting/kis_script_monitor.h"

typedef KGenericFactory<Scripting> ChalkScriptingFactory;
K_EXPORT_COMPONENT_FACTORY( chalkscripting, ChalkScriptingFactory( "chalk" ) )

Scripting::Scripting(TQObject *parent, const char *name, const TQStringList &)
        : KParts::Plugin(parent, name)
{
    setInstance(ChalkScriptingFactory::instance());


    if ( parent->inherits("KisView") )
    {
        setInstance(Scripting::instance());
        m_view = (KisView*) parent;
        m_scriptguiclient = new Kross::Api::ScriptGUIClient( m_view, m_view );
//         m_scriptguiclient ->setXMLFile(locate("data","chalkplugins/scripting.rc"), true);
        //BEGIN TODO: understand why the ScriptGUIClient doesn't "link" its actions to the menu
        setXMLFile(locate("data","chalkplugins/scripting.rc"), true);
        new TDEAction(i18n("Execute Script File..."), 0, 0, m_scriptguiclient, TQT_SLOT(executeScriptFile()), actionCollection(), "executescriptfile");
        new TDEAction(i18n("Script Manager..."), 0, 0, m_scriptguiclient, TQT_SLOT(showScriptManager()), actionCollection(), "configurescripts");
        //END TODO

        TQWidget * w = new Kross::Api::WdgScriptsManager(m_scriptguiclient, m_view);

        m_view->canvasSubject()->paletteManager()->addWidget(w, "Scripts Manager", chalk::LAYERBOX, 10,  PALETTE_DOCKER, false);

        connect(m_scriptguiclient, TQT_SIGNAL(executionFinished( const Kross::Api::ScriptAction* )), this, TQT_SLOT(executionFinished(const Kross::Api::ScriptAction*)));
        connect(m_scriptguiclient, TQT_SIGNAL(executionStarted( const Kross::Api::ScriptAction* )), this, TQT_SLOT(executionStarted(const Kross::Api::ScriptAction*)));
        KisScriptMonitor::instance()->monitor( m_scriptguiclient );

        Kross::Api::Manager::scriptManager()->addTQObject(m_view->canvasSubject()->document(), "ChalkDocument");
        Kross::Api::Manager::scriptManager()->addTQObject(TQT_TQOBJECT(m_view), "ChalkView");
        m_scriptProgress = new KisScriptProgress(m_view);
        Kross::Api::Manager::scriptManager()->addTQObject(m_scriptProgress, "ChalkScriptProgress");

    }

}

Scripting::~Scripting()
{
}

void Scripting::executionFinished(const Kross::Api::ScriptAction*)
{
    m_view->canvasSubject()->document()->setModified(true);
    m_view->canvasSubject()->document()->currentImage()->activeLayer()->setDirty();
    m_scriptProgress->progressDone();
    TQApplication::restoreOverrideCursor();
}

void Scripting::executionStarted(const Kross::Api::ScriptAction* act)
{
    kdDebug(41011) << act->getPackagePath() << endl;
    m_scriptProgress->setPackagePath( act->getPackagePath() );
}


#include "scripting.moc"
