/*
 *  Copyright (c) 1999 Matthias Elter  <me@kde.org>
 *  Copyright (c) 2004 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KIS_TQPAINTDEVICE_CANVAS_H_
#define KIS_TQPAINTDEVICE_CANVAS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqwidget.h>

#include "kis_global.h"
#include "kis_canvas.h"

#ifdef Q_MOC_RUN
#define Q_WS_X11
#endif // Q_MOC_RUN

#ifdef Q_WS_X11
#include <X11/Xlib.h>
#endif // Q_WS_X11

class KisTQPaintDeviceCanvasWidget : public virtual TQWidget, public virtual KisCanvasWidget {
public:
    KisTQPaintDeviceCanvasWidget(TQWidget *parent = 0, const char *name = 0);
    ~KisTQPaintDeviceCanvasWidget();

    virtual KisCanvasWidgetPainter *createPainter();

#if defined(EXTENDED_X11_TABLET_SUPPORT)
    virtual void selectTabletDeviceEvents();
#endif

protected:
    virtual void paintEvent(TQPaintEvent *event);
    virtual void mousePressEvent(TQMouseEvent *event);
    virtual void mouseReleaseEvent(TQMouseEvent *event);
    virtual void mouseDoubleClickEvent(TQMouseEvent *event);
    virtual void mouseMoveEvent(TQMouseEvent *event);
    virtual void tabletEvent(TQTabletEvent *event);
    virtual void enterEvent(TQEvent *event );
    virtual void leaveEvent(TQEvent *event);
    virtual void wheelEvent(TQWheelEvent *event);
    virtual void keyPressEvent(TQKeyEvent *event);
    virtual void keyReleaseEvent(TQKeyEvent *event);
    virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);
#ifdef Q_WS_X11
    bool x11Event(XEvent *event);
#endif // Q_WS_X11
};

#endif // KIS_TQPAINTDEVICE_CANVAS_H_

